<?php
/**
 * LSVR Pressville Widgets Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Pressville_Widgets' ) ) {
    class Lsvr_Shortcode_Pressville_Widgets {

        public static function shortcode( $atts = array(), $content = null, $tag ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'id' => '',
                    'sidebar_id' => 'lsvr-pressville-default-sidebar',
                    'columns_count' => 3,
                    'enable_dark_bg' => '',
                ),
                $atts
            );

            // Check if dark BG
            $enable_dark_bg = '1' === $args['enable_dark_bg'] || 'true' === $args['enable_dark_bg'] ? true : false;

            ob_start(); ?>

            <section class="lsvr-pressville-widgets<?php if ( true === $enable_dark_bg ) { echo ' lsvr-pressville-widgets--dark-bg'; } ?>" <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-pressville-widgets__bg">
                    <div class="lsvr-container">
                        <div class="lsvr-pressville-widgets__inner">

                            <?php if ( ! empty( $args['sidebar_id'] ) && is_active_sidebar( $args['sidebar_id'] ) ) : ?>

                                <div class="lsvr-pressville-widgets__grid lsvr-pressville-widgets__grid--<?php echo ! empty( $args['columns_count'] ) ? esc_attr( $args['columns_count'] ) : 4; ?>-cols">
                                    <?php dynamic_sidebar( $args['sidebar_id'] ); ?>
                                </div>

                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </section>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Sidebar ID
                array(
                    'name' => 'sidebar_id',
                    'type' => 'select',
                    'label' => esc_html__( 'Sidebar', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose which sidebar will be used to create this section. You can manage custom sidebars under Customizer / Custom Sidebars and populate them with widgets under Appearance / Widgets.', 'lsvr-pressville-toolkit' ),
                    'choices' => lsvr_pressville_toolkit_get_sidebars(),
                    'default' => 'lsvr-pressville-default-sidebar',
                    'priority' => 10,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the widgets.', 'lsvr-pressville-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 3,
                    'priority' => 20,
                ),

                // Enable dark BG
                array(
                    'name' => 'enable_dark_bg',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Darken Background', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Darken the background color of this element.', 'lsvr-pressville-toolkit' ),
                    'priority' => 30,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 40,
                ),

            ), apply_filters( 'lsvr_pressville_widgets_shortcode_atts', array() ) );
        }

    }
}
?>