<?php
/**
 * Galleries Tailor Element
 *
 * Display galleries
 */
if ( ! class_exists( 'Lsvr_Pressville_Galleries_Element' ) && class_exists( 'Tailor_Element' ) ) {
    class Lsvr_Pressville_Galleries_Element extends Tailor_Element {

        protected function register_controls() {

            // General Section
            $this->add_section( 'general', array(
                'title' => esc_html__( 'General', 'lsvr-pressville-toolkit' ),
                'priority' => 10,
            ));

                // Title
                $this->add_setting( 'title', array(
                    'default' => esc_html__( 'Town Galleries', 'lsvr-pressville-toolkit' ),
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'title', array(
                    'section' => 'general',
                    'setting' => 'title',
                    'type' =>'text',
                    'label' => esc_html__( 'Title', 'lsvr-pressville-toolkit' ),
                    'priority' => 10,
                ));

                // Subtitle
                $this->add_setting( 'subtitle', array(
                    'default' => esc_html__( 'Interesting sights and past events', 'lsvr-pressville-toolkit' ),
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'subtitle', array(
                    'section' => 'general',
                    'setting' => 'subtitle',
                    'type' =>'text',
                    'label' => esc_html__( 'Subtitle', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ));

                // Icon
                $this->add_setting( 'icon', array(
                    'default' => 'icon-folder-image',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'icon', array(
                    'section' => 'general',
                    'setting' => 'icon',
                    'type' =>'text',
                    'label' => esc_html__( 'Icon Class', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Class of the icon which will be displayed in element title. Check out the documentation to learn more about icons. Leave blank to hide.', 'pressville' ),
                    'priority' => 30,
                ));

                // Category
                $this->add_setting( 'category', array(
                    'default' => '0',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'category', array(
                    'section' => 'general',
                    'setting' => 'category',
                    'type' =>'select',
                    'label' => esc_html__( 'Category', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Display galleries from a specific category.', 'lsvr-pressville-toolkit' ),
                    'choices' => array( 0 => esc_html__( 'No Category', 'lsvr-pressville-toolkit' ) ) + (array) lsvr_pressville_toolkit_get_terms( 'lsvr_gallery_cat' ),
                    'priority' => 40,
                ));

                // More label
                $this->add_setting( 'more_label', array(
                    'default' => esc_html__( 'More Galleries', 'lsvr-pressville-toolkit' ),
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'more_label', array(
                    'section' => 'general',
                    'setting' => 'more_label',
                    'type' =>'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Link to gallery archive. Leave blank to hide.', 'lsvr-pressville-toolkit' ),
                    'priority' => 50,
                ));

                // ID
                $this->add_setting( 'id', array(
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'id', array(
                    'section' => 'general',
                    'setting' => 'id',
                    'type' =>'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 60,
                ));


            // Layout Section
            $this->add_section( 'layout', array(
                'title' => esc_html__( 'Layout', 'lsvr-pressville-toolkit' ),
                'priority' => 20,
            ));

                // Layout
                $this->add_setting( 'layout', array(
                    'default' => 'title-top',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'layout', array(
                    'section' => 'layout',
                    'setting' => 'layout',
                    'type' =>'select',
                    'label' => esc_html__( 'Element Layout', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose the layout of this element. Please note that the "Title in the Background" layout doesn\'t display the subtitle and icon on desktops and all layouts are displayed as "Title on the Top" on small devices.', 'lsvr-pressville-toolkit' ),
                    'choices' => array(
                        'title-top' => esc_html__( 'Title on the Top', 'lsvr-pressville-toolkit' ),
                        'title-left' => esc_html__( 'Title on the Left', 'lsvr-pressville-toolkit' ),
                        'title-bg' => esc_html__( 'Title in the Background', 'lsvr-pressville-toolkit' ),
                    ),
                    'priority' => 10,
                ));

                // Limit
                $this->add_setting( 'limit', array(
                    'default' => '8',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'limit', array(
                    'section' => 'layout',
                    'setting' => 'limit',
                    'type' =>'range',
                    'label' => esc_html__( 'Number of Galleries', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many galleries should be displayed. Set to 0 to display all.', 'lsvr-pressville-toolkit' ),
                    'input_attrs' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'priority' => 20,
                ));

                // Columns count
                $this->add_setting( 'columns_count', array(
                    'default' => '4',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'columns_count', array(
                    'section' => 'layout',
                    'setting' => 'columns_count',
                    'type' =>'range',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display galleries.', 'lsvr-pressville-toolkit' ),
                    'input_attrs' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'priority' => 30,
                ));

                // Enable dark BG
                $this->add_setting( 'enable_dark_bg', array(
                    'default' => '1',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'enable_dark_bg', array(
                    'section' => 'layout',
                    'setting' => 'enable_dark_bg',
                    'type' =>'switch',
                    'label' => esc_html__( 'Darken Background', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Darken the background color of this element.', 'lsvr-pressville-toolkit' ),
                    'priority' => 40,
                ));

                // Enable slider
                $this->add_setting( 'enable_slider', array(
                    'default' => '1',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'enable_slider', array(
                    'section' => 'layout',
                    'setting' => 'enable_slider',
                    'type' =>'switch',
                    'label' => esc_html__( 'Enable Slider', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Display galleries as a slider.', 'lsvr-pressville-toolkit' ),
                    'priority' => 50,
                ));

        }

    }
} ?>