<?php
/**
 * Sitemap Tailor Element
 *
 * Display custom menu
 */
if ( ! class_exists( 'Lsvr_Pressville_Sitemap_Element' ) && class_exists( 'Tailor_Element' ) ) {
    class Lsvr_Pressville_Sitemap_Element extends Tailor_Element {

        protected function register_controls() {

            // General Section
            $this->add_section( 'general', array(
                'title' => esc_html__( 'General', 'lsvr-pressville-toolkit' ),
                'priority' => 10,
            ));

                // Menu ID
                $this->add_setting( 'menu_id', array(
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'menu_id', array(
                    'section' => 'general',
                    'setting' => 'menu_id',
                    'type' =>'select',
                    'label' => esc_html__( 'Menu', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose which menu will be used to create the sitemap. You can manage menus under Appearance / Menus.', 'lsvr-pressville-toolkit' ),
                    'choices' => lsvr_pressville_toolkit_get_menus(),
                    'priority' => 10,
                ));

                // ID
                $this->add_setting( 'id', array(
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'id', array(
                    'section' => 'general',
                    'setting' => 'id',
                    'type' =>'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ));


            // Layout Section
            $this->add_section( 'layout', array(
                'title' => esc_html__( 'Layout', 'lsvr-pressville-toolkit' ),
                'priority' => 20,
            ));

                // Background image
                $this->add_setting( 'bg_image', array(
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'bg_image', array(
                    'section' => 'layout',
                    'setting' => 'bg_image',
                    'type' =>'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Optimal resolution is about 2000x1600px or more.', 'lsvr-pressville-toolkit' ),
                    'priority' => 10,
                ));

                // Columns count
                $this->add_setting( 'columns_count', array(
                    'default' => '4',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'columns_count', array(
                    'section' => 'layout',
                    'setting' => 'columns_count',
                    'type' =>'range',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the sitemap.', 'lsvr-pressville-toolkit' ),
                    'input_attrs' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'priority' => 20,
                ));

        }

    }
} ?>