<?php

// Load custom Tailor elements
add_action( 'tailor_load_elements', 'lsvr_pressville_toolkit_load_tailor_elements', 20 );
if ( ! function_exists( 'lsvr_pressville_toolkit_load_tailor_elements' ) ) {
    function lsvr_pressville_toolkit_load_tailor_elements() {
    	require_once( 'classes/tailor-elements/lsvr-pressville-directory-element.php' );
    	require_once( 'classes/tailor-elements/lsvr-pressville-events-element.php' );
    	require_once( 'classes/tailor-elements/lsvr-pressville-galleries-element.php' );
        require_once( 'classes/tailor-elements/lsvr-pressville-posts-element.php' );
        require_once( 'classes/tailor-elements/lsvr-pressville-sitemap-element.php' );
        require_once( 'classes/tailor-elements/lsvr-pressville-widgets-element.php' );
    }
}

// Register custom Tailor elements
add_action( 'tailor_register_elements', 'lsvr_pressville_toolkit_register_tailor_elements' );
if ( ! function_exists( 'lsvr_pressville_toolkit_register_tailor_elements' ) ) {
    function lsvr_pressville_toolkit_register_tailor_elements( $element_manager ) {

    	// Directory
        $element_manager->add_element(
            'lsvr_pressville_directory',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Directory', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying directory listings', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    	// Events
        $element_manager->add_element(
            'lsvr_pressville_events',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Events', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying events', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    	// Galleries
        $element_manager->add_element(
            'lsvr_pressville_galleries',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Galleries', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying galleries', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    	// Posts
        $element_manager->add_element(
            'lsvr_pressville_posts',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Posts', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying standard posts', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    	// Sitemap
        $element_manager->add_element(
            'lsvr_pressville_sitemap',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Sitemap', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying custom menu', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    	// Widgets
        $element_manager->add_element(
            'lsvr_pressville_widgets',
            array(
            	'type' => 'content',
                'label' => esc_html__( 'Pressville Widgets', 'lsvr-pressville-toolkit' ),
                'description' => esc_html__( 'Fullwidth section displaying sidebar widgets', 'lsvr-pressville-toolkit' ),
                'badge' => esc_html__( 'LSVR', 'lsvr-pressville-toolkit' ),
                'dynamic' => true,
            )
        );

    }
}

?>