<?php // Config Visual Composer Page Builder
add_action( 'plugins_loaded', 'lsvr_pressville_toolkit_vc_config' );
if ( ! function_exists( 'lsvr_pressville_toolkit_vc_config' ) ) {
	function lsvr_pressville_toolkit_vc_config() {

		if ( function_exists( 'vc_set_as_theme' ) ) {

			// Set as theme
			add_action( 'vc_before_init', 'lsvr_pressville_toolkit_vc_init' );
			if ( ! function_exists( 'lsvr_pressville_toolkit_vc_init' ) && function_exists( 'vc_set_as_theme' ) ) {
				function lsvr_pressville_toolkit_vc_init() {
					vc_set_as_theme();
				}
			}

			// Register VC elements
			add_action( 'init', 'lsvr_pressville_toolkit_register_vc_elements' );
			if ( ! function_exists( 'lsvr_pressville_toolkit_register_vc_elements' ) ) {
				function lsvr_pressville_toolkit_register_vc_elements() {

					 if ( function_exists( 'lsvr_framework_vc_map' ) ) {

						// Pressville Container
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_container',
			                'name' => esc_html__( 'Pressville Container', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'Container with fixed max width', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'has_content' => true,
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Container::lsvr_shortcode_atts(),
						));

						// Pressville Directory
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_directory',
			                'name' => esc_html__( 'Pressville Directory', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'List of Listings', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Directory::lsvr_shortcode_atts(),
						));

						// Pressville Events
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_events',
			                'name' => esc_html__( 'Pressville Events', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'List of Events', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Events::lsvr_shortcode_atts(),
						));

						// Pressville Galleries
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_galleries',
			                'name' => esc_html__( 'Pressville Galleries', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'List of Galleries', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Galleries::lsvr_shortcode_atts(),
						));

						// Pressville Posts
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_posts',
			                'name' => esc_html__( 'Pressville Posts', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'List of Posts', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Posts::lsvr_shortcode_atts(),
						));

						// Pressville Post List Widget
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_post_list_widget',
			                'name' => esc_html__( 'Pressville Post List Widget', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'List of Posts', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Post_List_Widget::lsvr_shortcode_atts(),
						));

						// Pressville Sitemap
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_sitemap',
			                'name' => esc_html__( 'Pressville Sitemap', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'Custom menu', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Sitemap::lsvr_shortcode_atts(),
						));

						// Pressville Widgets
						lsvr_framework_vc_map(array(
			                'base' => 'lsvr_pressville_widgets',
			                'name' => esc_html__( 'Pressville Widgets', 'lsvr-pressville-toolkit' ),
			                'description' => esc_html__( 'Sidebar widgets', 'lsvr-pressville-toolkit' ),
			                'category' => esc_html__( 'Pressville', 'lsvr-pressville-toolkit' ),
			                'content_element' => true,
			                'show_settings_on_create' => true,
			                'params' => Lsvr_Shortcode_Pressville_Widgets::lsvr_shortcode_atts(),
						));

					}

				}
			}

		}

	}
}
?>