<?php
/**
 * The Header for our theme
 * @since copper 1.0.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
global $enable_home_page;
$enable_home_page = copper_options_array('enable_home_page');
?>
 <header id="header" class="navbar navbar-onex" role="banner">
<div class="container">
        <div class="navbar-header logo">
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-collapse">
      				<span class="sr-only"><?php _e("Toggle navigation","copper");?></span>
      				<span class="fa fa-bars fa-2x"></span>
       </button>
				  <div class="navbar-brand">
        <a href="<?php echo esc_url(home_url('/')); ?>">
        <?php if ( copper_options_array('logo')!="") { ?>
        <img src="<?php echo copper_options_array('logo'); ?>" alt="<?php bloginfo('name'); ?>" />
        <?php }else{ ?>
        <span class="site-name">
        <?php bloginfo('name'); ?>
        </span>
        <?php }?>
        </a>
        <span class="navbar-brand-tagline tagline"><?php echo  get_bloginfo( 'description' );?></span>
        </div></div>
        
        <nav class="collapse navbar-collapse main-menu" id="navbar-collapse" role="navigation">

             <?php wp_nav_menu(array('theme_location'=>'primary','depth'=>0,'fallback_cb' =>false,'container'=>'','menu_id'=>'main-menu','menu_class'=>'main-nav','link_before' => '<span>', 'link_after' => '</span>','items_wrap'=> '<ul id="%1$s" class="%2$s nav navbar-nav">%3$s</ul>'));?>
        
    </nav>
    </div>
    </header> <!-- END #header -->