<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 *
 */
function optionsframework_option_name() {

	// This gets the theme name from the stylesheet (lowercase and without spaces)
	$themename = get_option( 'stylesheet' );
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option(COPPER_OPTIONS_PREFIXED.'optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option(COPPER_OPTIONS_PREFIXED.'optionsframework', $optionsframework_settings);

	// echo $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 */

function optionsframework_options() {

	// Background Defaults
	
	$slide_image = array(
	     COPPER_THEME_BASE_URL.'/images/slide1.jpg',
		 COPPER_THEME_BASE_URL.'/images/slide2.jpg',
		 COPPER_THEME_BASE_URL.'/images/slide3.jpg',
		 COPPER_THEME_BASE_URL.'/images/slide4.jpg',
		
			);
		$footer_widget_background_defaults = array(
		'color' => '',
		'image' => COPPER_THEME_BASE_URL.'/images/footer-widget-bg.png',
		'repeat' => 'repeat',
		'position' => 'top left',
		'attachment'=>'scroll' );
		$footer_copyright_background_defaults = array(
		'color' => '#666666',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top left',
		'attachment'=>'scroll' );
		$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top left',
		'attachment'=>'scroll' );
		
	
	$slide_content   = array('<h4>Aliquam tincidunt mauris eu risus.</h4><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis. Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede.</p>','','','');
	
	$options = array();
   // HEADER
	$options[] = array(
		'name' => __('General Options', 'copper'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Upload Logo', 'copper'),
		'id' => 'logo',
		'std' => COPPER_THEME_BASE_URL.'/images/logo.png',
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Favicon', 'copper'),
		'desc' => __('An icon associated with a URL that is variously displayed, as in a browser\'s address bar or next to the site name in a bookmark list. Learn more about <a href="'.esc_url("http://en.wikipedia.org/wiki/Favicon").'" target="_blank">Favicon</a>', 'copper'),
		'id' => 'favicon',
		'type' => 'upload');
		
	 $options[] = array(
		"name" => __('Post Sidebar', 'copper'),
		"id" => "post_sidebar",
		"std" => "",
		"type" => "select",
		"options" => array("right-sidebar"=>"right sidebar","left-sidebar"=>"left sidebar","dual-sidebar"=>"dual sidebar","full-width"=>"full width") );
	 
		
	$options[] = array(
		'name' => __('Custom CSS', 'copper'),
		'desc' => __('The following css code will add to the header before the closing &lt;/head&gt; tag.', 'copper'),
		'id' => 'custom_css',
		'std' => 'body{margin:0px;}',
		'type' => 'textarea');
	
		////HOME PAGE
		$options[] = array(
		'name' => __('Home Page', 'copper'),
		'type' => 'heading');
		
		$options[] = array(
		'name' => __('Enable Home Page Layout', 'copper'),
		'desc' => __('Active widget area home page layout. ', 'copper'),
		'id' => 'enable_home_page',
		'std'=>'',
		'type' => 'checkbox');
		
		$options[] = array(
		'name' => __('Enable Home Page Top Slider', 'copper'),
		'id' => 'enable_top_slider',
		'std'=>'1',
		'desc' => __('Display home page top slider. ', 'copper'),
		'type' => 'checkbox');
		
		//HOME PAGE slide
				
		$options[] = array(
		'name' => __('slide Num', 'copper'),
		'desc' => __('The number of home slides.', 'copper'),
		'id' => 'slide_num',
		'std' => '4',
		'type' => 'text');
		
		$default_slide_num = count($slide_image);
		$slide_num = copper_options_array('slide_num');
		
		if(isset($slide_num) && is_numeric($slide_num) && $slide_num>0){
		$slide_num = $slide_num;
		}
		else{
		$slide_num = $default_slide_num;
		}
	
		for($i=0; $i < $slide_num; $i++){
		
		if(!isset($slide_content[$i])){$slide_content[$i] = "";}
		
		$options[] = array('name' => sprintf(__('slide %s', 'copper'),($i+1)),'id' => 'slide_group_start_'.$i.'','type' => 'start_group','class'=>'group_close');
		
		$options[] = array(
		'name' => __('Slide Image', 'copper'),
		'id' => 'slide_image_'.$i,
		'std' => isset($slide_image[$i])?$slide_image[$i]:"",
		'type' => 'upload');

	    $options[] = array(
		'name' => __('Slide Description', 'copper'),
		'id' => 'slide_description_'.$i,
		'std' => $slide_content[$i],
		'type' => 'editor');
	
		$options[] = array('name' => '','id' => 'slide_group_end_'.$i.'','type' => 'end_group');
		
		}


$options[] = array(
		'name' => __('Home Page Widget Areas', 'copper'),
		'id' => 'home_page_sections',
		'std' => '{"section-widget-area-name":["Home Area One","Home Area Two","Home Area Three","Home Area Four","Home Area Five"],"list-item-color":["","","","",""],"list-item-image":["","","","",""],"list-item-repeat":["","","","no-repeat",""],"list-item-position":["","","","",""],"list-item-attachment":["","","","",""],"widget-area-layout":["boxed","full","boxed","boxed","boxed"],"widget-area-padding":["0","0","0","0","0"],"widget-area-column":["1","1","1","2","2"],"widget-area-column-item":{"home-area-one":["3","3","3","3"],"home-area-two":["12"],"home-area-three":["12"],"home-area-four":["6","6"],"home-area-five":["6","6"]}}',
		'type' => 'widget-area');
		//footer
		
	
		
		$options[] = array(
		'name' => __('Footer', 'copper'),
		'type' => 'heading');
		
		$options[] = array(
		'name' => __('Enable Footer Widget', 'copper'),
		'desc' =>  __('Display footer widget.', 'copper'),
		'id' => 'enable_footer_widget',
		'std'=>1,
		'type' => 'checkbox');
		$options[] = array(
		'name' =>  __('Footer Widget Background', 'copper'),
		'id' => 'footer_widget_background',
		'std' => $footer_widget_background_defaults,
		'type' => 'background' );
		$options[] = array(
		'name' =>  __('Footer Copyright Background', 'copper'),
		'id' => 'footer_copyright_background',
		'std' => $footer_copyright_background_defaults,
		'type' => 'background' );
		
		
		$options[] = array('name' => __('Footer Social Network', 'copper'),'id' => 'group_title','type' => 'title');
		
		 $social_array = array(""=>"==== select ====","facebook"=>"Facebook","twitter"=>"Twitter","googleplus"=>"Google+","vimeo"=>"Vimeo","rss"=>"Rss","linkedin"=>"LinkedIn","flickr"=>"Flickr","youtube"=>"Youtube","pinterest"=>"Pinterest");
		 
		for($i=0; $i < 9; $i++){
		
		$options[] = array('name' => sprintf(__('Social Network %s', 'copper'),($i+1)),'id' => 'social_group_start_'.$i.'','type' => 'start_group','class'=>'group_close');
		
		$options[] = array(
                'name' => __('Slide Effect', 'copper'),
                'id' => 'social_icon_'.$i,
                'std' => '',
                'type' => 'select',
                'options' => $social_array);

	    $options[] = array(
		'name' => __('Link', 'copper'),
		'id' => 'social_link_'.$i,
		'std' => '#',
		'type' => 'text');
	
		$options[] = array('name' => '','id' => 'social_group_end_'.$i.'','type' => 'end_group');
		
		}
		
		 $options[] = array(
		'name' => __('Copyright', 'copper'),
		'id' => 'copyright',
		'std' => 'Copyright &copy; 2014 Copper. All Rights Reserved.',
		'type' => 'textarea');
		
		////404 Page
		$options[] = array(
		'name' => __('404 Page', 'copper'),
		'type' => 'heading');
				
		$options[] = array(
		'name' => __('Page Title', 'copper'),
		'id' => 'page_404_title',
		'std' => '404: Page not found...',
		'type' => 'text');
		$options[] = array(
		'name' => __('Page Content', 'copper'),
		'id' => 'page_404_content',
		'std' => 'Sorry, the page you were looking for was not found. Please use the search form below or have a look at the list of popular pages. ',
		'type' => 'editor');
		
		

	return $options;
}