jQuery(document).ready(function ($) {

    $('.sp-logo-carousel-pro-area.mode_standard').each(function (index) {

        var custom_id = $(this).attr('id');
        var splcp_conf = $.parseJSON($(this).closest('.sp-logo-carousel-pro-section').find('.sp-lcp-conf').text());

        if ( splcp_conf.vertical == 'false' ) {
            switch ( splcp_conf.nav_arrow_type_horizon ) {
                case 'chevron_arrow_horizon':
                   var nav_arrow_horizon_one = 'fa fa-chevron-left';
                   var nav_arrow_horizon_two = 'fa fa-chevron-right';
                    break;
                case 'double_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-angle-double-left';
                    nav_arrow_horizon_two = 'fa fa-angle-double-right';
                    break;
                case 'bold_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-arrow-left';
                    nav_arrow_horizon_two = 'fa fa-arrow-right';
                    break;
                case 'long_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-long-arrow-left';
                    nav_arrow_horizon_two = 'fa fa-long-arrow-right';
                    break;
                case 'caret_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-caret-left';
                    nav_arrow_horizon_two = 'fa fa-caret-right';
                    break;
                default:
                    nav_arrow_horizon_one = 'fa fa-angle-left';
                    nav_arrow_horizon_two = 'fa fa-angle-right';
            }
        } else {
            switch ( splcp_conf.nav_arrow_type_horizon ) {
                case 'chevron_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-chevron-up';
                    nav_arrow_horizon_two = 'fa fa-chevron-down';
                    break;
                case 'double_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-angle-double-up';
                    nav_arrow_horizon_two = 'fa fa-angle-double-down';
                    break;
                case 'bold_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-arrow-up';
                    nav_arrow_horizon_two = 'fa fa-arrow-down';
                    break;
                case 'long_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-long-arrow-up';
                    nav_arrow_horizon_two = 'fa fa-long-arrow-down';
                    break;
                case 'caret_arrow_horizon':
                    nav_arrow_horizon_one = 'fa fa-caret-up';
                    nav_arrow_horizon_two = 'fa fa-caret-down';
                    break;
                default:
                    nav_arrow_horizon_one = 'fa fa-angle-up';
                    nav_arrow_horizon_two = 'fa fa-angle-down';
            }
        }


        if ( splcp_conf.nav_type === "nav_text" ){
            previousArrow = '<div class="slick-prev"><span>Prev</span></div>';
            nextiousArrow = '<div class="slick-next"><span>Next</span></div>';
        } else {
            previousArrow = '<div class="slick-prev"><i class="' + nav_arrow_horizon_one + '"></i></div>';
            nextiousArrow = '<div class="slick-next"><i class="' + nav_arrow_horizon_two + '"></i></div>';
        }

        if (custom_id != '') {
            jQuery('#' + custom_id).slick({
                infinite: (splcp_conf.infinite) == "true" ? true : false,
                pauseOnHover: (splcp_conf.pause_on_hover) == "true" ? true : false,
                adaptiveHeight: (splcp_conf.adaptive_height) == "true" ? true : false,
                slidesToShow: parseInt(splcp_conf.items),
                autoplay: (splcp_conf.auto_play) == "true" ? true : false,
                speed: parseInt(splcp_conf.speed),
                rtl: (splcp_conf.rtl_mode) == "true" ? true : false,
                dots: (splcp_conf.dots) == "true" ? true : false,
                arrows: (splcp_conf.nav) == "true" ? true : false,
                slidesToScroll: parseInt(splcp_conf.slides_to_scroll),
                autoplaySpeed: parseInt(splcp_conf.auto_play_speed),
                draggable: (splcp_conf.draggable) == "true" ? true : false,
                swipe: (splcp_conf.swipe) == "true" ? true : false,
                lazyload: (splcp_conf.pause_on_hover) == "true" ? "ondemand" : false,
                centerMode: (splcp_conf.center_mode) == "true" ? true : false,
                centerPadding: parseInt(splcp_conf.center_mode_padding),
                vertical: (splcp_conf.vertical) == "true" ? true : false,
                slidesPerRow: parseInt(splcp_conf.slides_to_scroll),
                rows: parseInt(splcp_conf.lcp_row),
                responsive: [
                    {
                        breakpoint: 1280,
                        settings: {
                            slidesToShow: parseInt(splcp_conf.items_desktop)
                        }
                    },
                    {
                        breakpoint: 980,
                        settings: {
                            slidesToShow: parseInt(splcp_conf.items_desktop_small)
                        }
                    },
                    {
                        breakpoint: 736,
                        settings: {
                            slidesToShow: parseInt(splcp_conf.items_tablet)
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: parseInt(splcp_conf.items_mobile),
                            slidesToScroll: parseInt(splcp_conf.slides_to_scroll_mobile),
                            slidesPerRow: parseInt(splcp_conf.slides_to_scroll_mobile),
                            dots: (splcp_conf.dots_mobile) == "true" ? true : false,
                            arrows: (splcp_conf.nav_mobile) == "true" ? true : false,
                        }
                    }
                ],
                prevArrow: previousArrow,
                nextArrow: nextiousArrow,

            }); // Slick end
            
        }
    });
    
});


