<?php
/**
 * LSVR Notice List Widget Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Notice_List_Widget' ) ) {
    class Lsvr_Shortcode_Notice_List_Widget {

        public static function shortcode( $atts = array(), $content = null, $tag ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'title' => '',
                    'icon' => '',
                    'category' => 0,
                    'limit' => 4,
                    'show_date' => 'true',
                    'show_category' => 'true',
                    'more_label' => '',
                    'id' => '',
                ),
                $atts
            );

            ob_start(); ?>

            <?php the_widget( 'Lsvr_Widget_Notice_List', array(
                'title' => $args['title'],
                'category' => $args['category'],
                'limit' => $args['limit'],
                'show_date' => $args['show_date'],
                'show_category' => $args['show_category'],
                'more_label' => $args['more_label'],
            ), array(
                'before_widget' => '<div ' . ( ! empty( $args['id'] ) ? 'id="' . esc_attr( $args['id'] ) . '"' : '' ) . ' class="widget lsvr_notice-list-widget"><div class="widget__inner">',
                'after_widget' => '</div></div>',
                'before_title' => ! empty( $args['icon'] ) ? '<h3 class="widget__title widget__title--has-icon"><i class="widget__title-icon ' . esc_attr( $args['icon'] ) . '"></i>' : '<h3 class="widget__title">',
                'after_title' => '</h3>',
            )); ?>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-notices' ),
                    'description' => esc_html__( 'Title of this section.', 'lsvr-notices' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'lsvr_notice_cat',
                    'label' => esc_html__( 'Category', 'lsvr-notices' ),
                    'description' => esc_html__( 'Display notices from a specific category.', 'lsvr-notices' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Limit', 'lsvr-notices' ),
                    'description' => esc_html__( 'How many notices to display.', 'lsvr-notices' ),
                    'choices' => array( 0 => esc_html__( 'All', 'lsvr-notices' ) ) + range( 1, 20, 1 ),
                    'default' => 4,
                    'priority' => 30,
                ),

                // Display date
                array(
                    'name' => 'show_date',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Date', 'lsvr-notices' ),
                    'default' => true,
                    'priority' => 40,
                ),

                // Display category
                array(
                    'name' => 'show_category',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Category', 'lsvr-notices' ),
                    'default' => true,
                    'priority' => 50,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Link Label', 'lsvr-notices' ),
                    'description' => esc_html__( 'Link to notices archive. Leave blank to hide.', 'lsvr-notices' ),
                    'priority' => 60,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-notices' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-notices' ),
                    'priority' => 70,
                ),

            ), apply_filters( 'lsvr_notice_list_widget_shortcode_atts', array() ) );
        }

    }
}
?>