<?php
/**
 * LSVR Pressville Post List Widget Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Pressville_Post_List_Widget' ) ) {
    class Lsvr_Shortcode_Pressville_Post_List_Widget {

        public static function shortcode( $atts = array(), $content = null, $tag ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'id' => '',
                    'title' => '',
                    'category' => 0,
                    'limit' => 4,
                    'show_date' => 0,
                    'show_category' => 'title-top',
                    'more_label' => '',
                ),
                $atts
            );

            ob_start(); ?>

            <?php the_widget( 'Lsvr_Widget_Pressville_Post_List', array(
                'title' => $args['title'],
                'category' => $args['category'],
                'limit' => $args['limit'],
                'show_date' => $args['show_date'],
                'show_category' => $args['show_category'],
                'more_label' => $args['more_label'],
            ), array(
                'before_widget' => '<div' . ( ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : '' ) . ' class="widget lsvr-pressville-post-list-widget"><div class="widget__inner">',
                'after_widget' => '</div></div>',
                'before_title' => '<h3 class="widget__title">',
                'after_title' => '</h3>',
            )); ?>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-pressville-toolkit' ),
                    'priority' => 10,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'category',
                    'label' => esc_html__( 'Category', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Display posts from a specific category.', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Posts', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many posts should be displayed. Set to 0 to display all.', 'lsvr-pressville-toolkit' ),
                    'choices' => range( 0, 10, 1 ),
                    'default' => 4,
                    'priority' => 30,
                ),

                // Show date
                array(
                    'name' => 'show_date',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Date', 'lsvr-pressville-toolkit' ),
                    'priority' => 40,
                ),

                // Show category
                array(
                    'name' => 'show_category',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Display Category', 'lsvr-pressville-toolkit' ),
                    'priority' => 50,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Link to post archive. Leave blank to hide.', 'lsvr-pressville-toolkit' ),
                    'priority' => 60,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 110,
                ),

            ), apply_filters( 'lsvr_pressville_post_list_widget_shortcode_atts', array() ) );
        }

    }
}
?>