<?php
/**
 * Widgets Tailor Element
 *
 * Display sidebar widgets
 */
if ( ! class_exists( 'Lsvr_Pressville_Widgets_Element' ) && class_exists( 'Tailor_Element' ) ) {
    class Lsvr_Pressville_Widgets_Element extends Tailor_Element {

        protected function register_controls() {

            // General Section
            $this->add_section( 'general', array(
                'title' => esc_html__( 'General', 'lsvr-pressville-toolkit' ),
                'priority' => 10,
            ));

                // Sidebar ID
                $this->add_setting( 'sidebar_id', array(
                    'default' => 'lsvr-pressville-default-sidebar',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'sidebar_id', array(
                    'section' => 'general',
                    'setting' => 'sidebar_id',
                    'type' =>'select',
                    'label' => esc_html__( 'Sidebar', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose which sidebar will be used to create this section. You can manage custom sidebars under Customizer / Custom Sidebars and populate them with widgets under Appearance / Widgets.', 'lsvr-pressville-toolkit' ),
                    'choices' => lsvr_pressville_toolkit_get_sidebars(),
                    'priority' => 10,
                ));

                // ID
                $this->add_setting( 'id', array(
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'id', array(
                    'section' => 'general',
                    'setting' => 'id',
                    'type' =>'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ));


            // Layout Section
            $this->add_section( 'layout', array(
                'title' => esc_html__( 'Layout', 'lsvr-pressville-toolkit' ),
                'priority' => 20,
            ));

                // Columns count
                $this->add_setting( 'columns_count', array(
                    'default' => '3',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'columns_count', array(
                    'section' => 'layout',
                    'setting' => 'columns_count',
                    'type' =>'range',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the widgets.', 'lsvr-pressville-toolkit' ),
                    'input_attrs' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'priority' => 20,
                ));

                // Enable dark BG
                $this->add_setting( 'enable_dark_bg', array(
                    'default' => '0',
                    'sanitize_callback' => 'tailor_sanitize_text',
                ));
                $this->add_control( 'enable_dark_bg', array(
                    'section' => 'layout',
                    'setting' => 'enable_dark_bg',
                    'type' =>'switch',
                    'label' => esc_html__( 'Darken Background', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Darken the background color of this element.', 'lsvr-pressville-toolkit' ),
                    'priority' => 30,
                ));

        }

    }
} ?>