<?php

// Load event JS files
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_event_load_js', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_load_js' ) ) {
	function lsvr_pressville_event_load_js() {

		// Masonry
		if ( lsvr_pressville_is_event() && ! is_singular( 'lsvr_event' ) &&
			true === get_theme_mod( 'lsvr_event_archive_masonry_enable', false ) &&
			'default' === get_theme_mod( 'lsvr_event_archive_layout', 'default' ) ) {
			wp_enqueue_script( 'masonry' );
		}

		// Datepicker
		if ( lsvr_pressville_is_event() && ! is_singular( 'lsvr_event' ) ) {
			wp_enqueue_script( 'jquery-ui-datepicker' );
		}

	}
}

// Page title
add_filter( 'document_title_parts', 'lsvr_pressville_event_title', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_title' ) ) {
	function lsvr_pressville_event_title( $title ) {

		if ( is_post_type_archive( 'lsvr_event' ) ) {
			$title['title'] = sanitize_text_field( lsvr_pressville_get_event_archive_title() );
		}
		return $title;

	}
}

// Add lsvr_event to search filter
add_filter( 'lsvr_pressville_add_header_search_filter', 'lsvr_pressville_event_search_filter', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_search_filter' ) ) {
	function lsvr_pressville_event_search_filter( $filter ) {

		$filter = array_merge( $filter, array(
			array(
				'name' => 'lsvr_event',
				'label' => esc_html__( 'events', 'pressville' ),
			),
		));
		return $filter;

	}
}

// Breadcrumbs
add_filter( 'lsvr_pressville_add_to_breadcrumbs', 'lsvr_pressville_event_breadcrumbs', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_breadcrumbs' ) ) {
	function lsvr_pressville_event_breadcrumbs( $breadcrumbs ) {

		if ( lsvr_pressville_is_event() && ! is_post_type_archive( 'lsvr_event' ) ) {
			$breadcrumbs = array(
				array(
					'url' => get_post_type_archive_link( 'lsvr_event' ),
					'label' => lsvr_pressville_get_event_archive_title(),
				),
			);
		}
		return $breadcrumbs;

	}
}

// Sidebar position
add_filter( 'lsvr_pressville_sidebar_position', 'lsvr_pressville_event_sidebar_position', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_sidebar_position' ) ) {
	function lsvr_pressville_event_sidebar_position( $sidebar_position ) {

		// Is event single
		if ( is_singular( 'lsvr_event' ) ) {
			$sidebar_position = get_theme_mod( 'lsvr_event_single_sidebar_position', 'disable' );
		}

		// Is event archive
		else if ( lsvr_pressville_is_event() ) {
			$sidebar_position = get_theme_mod( 'lsvr_event_archive_sidebar_position', 'disable' );
		}

		return $sidebar_position;

	}
}

// Sidebar ID
add_filter( 'lsvr_pressville_sidebar_id', 'lsvr_pressville_event_sidebar_id', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_event_sidebar_id' ) ) {
	function lsvr_pressville_event_sidebar_id( $sidebar_id ) {

		// Is event single
		if ( is_singular( 'lsvr_event' ) ) {
			$sidebar_id = get_theme_mod( 'lsvr_event_single_sidebar_id' );
		}

		// Is event archive
		else if ( lsvr_pressville_is_event() ) {
			$sidebar_id = get_theme_mod( 'lsvr_event_archive_sidebar_id' );
		}

		return $sidebar_id;

	}
}

// Events Filter language
add_action( 'lsvr_pressville_event_archive_filter_form_fields_before', 'lsvr_pressville_event_archive_filter_wpml_language' );
if ( ! function_exists( 'lsvr_pressville_event_archive_filter_wpml_language' ) ) {
	function lsvr_pressville_event_archive_filter_wpml_language() {
		if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
			echo '<input type="hidden" name="lang" value="' . ICL_LANGUAGE_CODE . '">';
		}
	}
}

// Add post meta data
add_action( 'lsvr_pressville_event_single_bottom', 'lsvr_pressville_add_event_single_meta', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_add_event_single_meta' ) ) {
	function lsvr_pressville_add_event_single_meta() { ?>

		<script type="application/ld+json">
		{
			"@context" : "http://schema.org",
			"@type" : "Event",
			"eventStatus" : "EventScheduled",
			"name": "<?php echo esc_js( get_the_title() ); ?>",
			"url" : "<?php echo esc_url( get_permalink() ); ?>",
			"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
		 	"description" : "<?php echo esc_js( get_the_excerpt() ); ?>",
		 	"startDate" : "<?php echo lsvr_pressville_get_next_event_occurrence_start( get_the_ID(), 'Y-m-d H:i:s' ); ?>",
		 	"endDate" : "<?php echo lsvr_pressville_get_next_event_occurrence_end( get_the_ID(), 'Y-m-d H:i:s' ); ?>"

		 	<?php if ( lsvr_pressville_has_event_location( get_the_ID() ) ) : ?>
			,"location" : {
			    "@type" : "Place",
			    "name" : "<?php echo esc_js( lsvr_pressville_get_event_location_name( get_the_ID() ) ); ?>",
			    <?php if ( lsvr_pressville_has_event_location_acurrate_address( get_the_ID() ) ) : ?>
			    "address" : "<?php echo esc_js( lsvr_pressville_get_event_location_accurate_address( get_the_ID() ) ); ?>"
			    <?php elseif ( lsvr_pressville_has_event_location_address( get_the_ID() ) ) : ?>
			    "address" : "<?php echo esc_js( preg_replace( "/\r|\n/", "", lsvr_pressville_get_event_location_address( get_the_ID() ) ) ); ?>"
			    <?php endif; ?>
			}
		 	<?php endif; ?>

			<?php if ( has_post_thumbnail() ) : ?>
		 	,"image": {
		 		"@type" : "ImageObject",
		 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
		 		"width" : "<?php echo esc_js( lsvr_pressville_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"height" : "<?php echo esc_js( lsvr_pressville_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
		 	}
		 	<?php endif; ?>

		}
		</script>

	<?php }
}

?>