<?php get_header(); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<?php // MAIN BEGIN
get_template_part( 'template-parts/main', 'begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_event-post-page post-single lsvr_event-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST HEADER : begin -->
				<header class="post__header">

					<!-- POST TITLE : begin -->
					<h1 class="post__title is-main-headline"><?php the_title(); ?></h1>
					<!-- POST TITLE : end -->

					<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_event_cat' ) ) : ?>

						<!-- POST META : begin -->
						<p class="post__meta">
							<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_event_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
						</p>
						<!-- POST META : end -->

					<?php endif; ?>

				</header>
				<!-- POST HEADER : end -->

				<?php if ( has_post_thumbnail() && true === get_theme_mod( 'lsvr_event_single_featured_image_enable', true ) ) : ?>
				<!-- POST THUMBNAIL : begin -->
				<p class="post__thumbnail">
					<?php the_post_thumbnail( 'full' ); ?>
				</p>
				<!-- POST THUMBNAIL : end -->
				<?php endif; ?>

				<?php // Ended event
				if ( ! lsvr_pressville_has_next_event_occurrences( get_the_ID() ) ) : ?>

					<p class="post__status post__status--ended"><?php esc_html_e( 'This event has ended', 'pressville' ); ?></p>

				<?php elseif ( lsvr_pressville_is_recurring_event( get_the_ID() ) && lsvr_pressville_has_next_event_occurrences( get_the_ID() ) ) : ?>

					<h5 class="post__next-date-title"><?php esc_html_e( 'Next Date', 'pressville' ); ?></h5>

				<?php endif; ?>

				<!-- POST INFO : begin -->
				<ul class="post__info<?php if ( lsvr_pressville_is_multiday_event( get_the_ID() ) ) { echo ' post__info--multiday'; } else { echo ' post__info--singleday'; } ?>">

					<?php // Multi-day event
					if ( lsvr_pressville_is_multiday_event( get_the_ID() ) ) : ?>

						<li class="post__info-item post__info-item--date">

							<h5 class="post__info-item-title"><?php esc_html_e( 'Start', 'pressville' ); ?></h5>
							<p class="post__info-item-text">
								<?php lsvr_pressville_the_event_start_date( get_the_ID() ); ?>
								<?php if ( ! lsvr_pressville_is_allday_event( get_the_ID() ) ) : ?>
									<br><?php lsvr_pressville_the_event_start_time( get_the_ID() ); ?>
								<?php else : ?>
									<br><?php esc_html_e( 'All-day Event', 'pressville' ); ?>
								<?php endif; ?>
							</p>

						</li>

						<li class="post__info-item post__info-item--date">

							<h5 class="post__info-item-title"><?php esc_html_e( 'End', 'pressville' ); ?></h5>
							<p class="post__info-item-text">
								<?php lsvr_pressville_the_event_end_date( get_the_ID() ); ?>
								<?php if ( ! lsvr_pressville_is_allday_event( get_the_ID() ) && lsvr_pressville_has_event_end_time( get_the_ID() ) ) : ?>
									<br><?php lsvr_pressville_the_event_end_time( get_the_ID() ); ?>
								<?php elseif ( lsvr_pressville_is_allday_event( get_the_ID() ) ) : ?>
									<br><?php esc_html_e( 'All-day Event', 'pressville' ); ?>
								<?php endif; ?>
							</p>

						</li>

					<?php // Single-day event
					else : ?>

						<li class="post__info-item post__info-item--date">

							<h5 class="post__info-item-title"><?php esc_html_e( 'Date', 'pressville' ); ?></h5>
							<p class="post__info-item-text">
								<?php lsvr_pressville_the_event_start_date( get_the_ID() ); ?>
							</p>

						</li>

						<li class="post__info-item post__info-item--time">

							<h5 class="post__info-item-title"><?php esc_html_e( 'Time', 'pressville' ); ?></h5>
							<p class="post__info-item-text">
								<?php lsvr_pressville_the_event_time( get_the_ID(), esc_html__( '%s - %s', 'pressville' ) ); ?>
							</p>

						</li>

					<?php endif; ?>

					<?php // Recurring info
					if ( lsvr_pressville_is_recurring_event( get_the_ID() ) ) : ?>

						<li class="post__info-item post__info-item--recurring">
							<h5 class="post__info-item-title"><?php esc_html_e( 'This is a recurring event', 'pressville' ); ?></h5>
							<p class="post__info-item-text"><?php lsvr_pressville_the_event_recurrence_pattern( get_the_ID(), esc_html__( 'Repeating every %s', 'pressville' ) ); ?></p>
						</li>

					<?php endif; ?>

				</ul>
				<!-- POST INFO : end -->

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php the_content(); ?>
					</div>
					<!-- POST CONTENT : end -->

				<?php endif; ?>

				<?php // Map and address
				if ( true === get_theme_mod( 'lsvr_event_single_map_enable', true ) &&
					lsvr_pressville_has_event_location_map( get_the_ID() ) && lsvr_pressville_has_event_location_address( get_the_ID() ) ) : ?>

					<!-- POST ADDRESS & MAP : begin -->
					<div class="post__addressmap">

						<div class="post__addressmap-inner">
							<h3 class="post__addressmap-title"><?php esc_html_e( 'Address', 'pressville' ); ?></h3>
							<p class="post__addressmap-address">
								<?php lsvr_pressville_the_event_location_address( get_the_ID() ); ?>
							</p>
							<?php if ( lsvr_pressville_has_event_map_link( get_the_ID() ) ) : ?>
								<p class="post__addressmap-link-wrapper">
									<a href="<?php echo esc_url( lsvr_pressville_get_event_map_link( get_the_ID() ) ); ?>"
										class="post__addressmap-link"><?php esc_html_e( 'Open in Google Maps', 'pressville' ); ?></a>
								</p>
							<?php endif; ?>
						</div>

						<?php // Location map
						lsvr_pressville_the_event_location_map( get_the_ID() ); ?>

					</div>
					<!-- POST ADDRESS & MAP : end -->

				<?php // Map only
				elseif ( true === get_theme_mod( 'lsvr_event_single_map_enable', true ) && lsvr_pressville_has_event_location_map( get_the_ID() ) ) : ?>

					<?php // Location map
					lsvr_pressville_the_event_location_map( get_the_ID() ); ?>

				<?php // Address only
				elseif ( lsvr_pressville_has_event_location_address( get_the_ID() ) ) : ?>

					<!-- POST ADDRESS : begin -->
					<p class="post__address">
						<?php lsvr_pressville_the_event_location_address( get_the_ID(), false ); ?>
					</p>
					<!-- POST ADDRESS : end -->

				<?php endif; ?>

				<?php if ( lsvr_pressville_is_recurring_event( get_the_ID() ) && lsvr_pressville_has_next_event_occurrences( get_the_ID() ) ) : ?>

					<!-- UPCOMING DATES : begin -->
					<div class="post__dates">

						<h3 class="post__dates-title"><?php esc_html_e( 'Upcoming dates', 'pressville' ); ?></h3>
						<?php lsvr_pressville_the_event_upcoming_occurrences( get_the_ID() );  ?>

					</div>
					<!-- UPCOMING DATES : end -->

				<?php endif; ?>

				<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_event_tag' ) ) : ?>

					<!-- POST FOOTER : begin -->
					<footer class="post__footer">

						<?php // Post tags
						lsvr_pressville_the_post_tags( get_the_ID(), 'lsvr_event_tag' ); ?>

					</footer>
					<!-- POST FOOTER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_pressville_event_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // MAIN END
get_template_part( 'template-parts/main', 'end' ); ?>

<?php get_footer(); ?>