<!-- DOCUMENT POST ARCHIVE : begin -->
<div class="lsvr_document-post-page post-archive lsvr_document-post-archive lsvr_document-post-archive--default">

	<?php // ARCHIVE HEADER
	get_template_part( 'template-parts/lsvr_document/archive-header' ); ?>

	<?php // Document categories
	if ( true === get_theme_mod( 'lsvr_document_archive_categories_enable', true ) ) {
		lsvr_pressville_the_post_archive_categories( 'lsvr_document', 'lsvr_document_cat' );
	} ?>

	<?php if ( have_posts() ) : ?>

		<?php if ( is_tax( 'lsvr_document_cat' ) && ! empty( term_description( get_queried_object_id(), 'lsvr_document_cat' ) ) ) : ?>
			<!-- CATEGORY DESCRIPTION : begin -->
			<div class="post-category-description">
				<?php echo wpautop( term_description( get_queried_object_id(), 'lsvr_document_cat' ) ); ?>
			</div>
			<!-- CATEGORY DESCRIPTION : end -->
		<?php endif; ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div class="post-archive__list">

			<?php while ( have_posts() ) : the_post(); ?>

				<!-- POST : begin -->
				<article <?php post_class( 'post' ); ?>>
					<div class="post__inner">

						<!-- POST HEADER : begin -->
						<header class="post__header">

							<!-- POST TITLE : begin -->
							<h2 class="post__title">
								<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
							</h2>
							<!-- POST TITLE : end -->

							<!-- POST META : begin -->
							<p class="post__meta">

								<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time>

								<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_document_cat' ) ) : ?>
									<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_document_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
								<?php endif; ?>

							</p>
							<!-- POST META : end -->

						</header>
						<!-- POST HEADER : end -->

						<!-- POST CONTENT : begin -->
						<div class="post__content">
							<?php if ( ! empty( $post->post_excerpt ) ) : ?>

								<?php the_excerpt(); ?>

							<?php endif; ?>
						</div>
						<!-- POST CONTENT : end -->

						<?php // Post attachments
						if ( ! post_password_required( get_the_ID() ) ) {
							lsvr_pressville_the_document_attachments( get_the_ID() );
						} ?>

						<!-- POST PERMALINK : begin -->
						<p class="post__permalink">
							<a href="<?php the_permalink(); ?>" class="c-button post__permalink-link" rel="bookmark">
								<?php esc_html_e( 'Read More', 'pressville' ); ?>
							</a>
						</p>
						<!-- POST PERMALINK : end -->

					</div>
				</article>
				<!-- POST : end -->

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // PAGINATION
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_pressville_the_alert_message( esc_html__( 'There are no documents', 'pressville' ) ); ?>

	<?php endif; ?>

</div>
<!-- DOCUMENT POST ARCHIVE : end -->