<?php
/*
 * Events functionality supports recurring events created via custom DB table,
 * that's why we can't use standard WP loop, but will have to do it via custom function instead
 */
?>

<!-- POST ARCHIVE : begin -->
<div class="lsvr_event-post-page post-archive lsvr_event-post-archive lsvr_event-post-archive--default">

	<?php // ARCHIVE HEADER
	get_template_part( 'template-parts/lsvr_event/archive-header' ); ?>

	<?php // Events categories
	if ( true === get_theme_mod( 'lsvr_event_archive_categories_enable', true ) ) {
		lsvr_pressville_the_event_archive_categories();
	} ?>

	<?php // Archive filter
	lsvr_pressville_the_event_archive_filter(); ?>

	<?php if ( lsvr_pressville_has_events() ) : ?>

		<!-- POST ARCHIVE GRID : begin -->
		<div class="post-archive__grid">

			<?php $i = 1; $event_occurrences = lsvr_pressville_get_event_archive(); foreach ( lsvr_pressville_get_event_archive() as $event_occurrence ) : ?>

				<?php lsvr_pressville_the_event_post_archive_grid_begin( $event_occurrence, $i ); ?>

				<div class="<?php lsvr_pressville_the_event_post_archive_grid_column_class(); ?>">

					<!-- POST : begin -->
					<article <?php lsvr_pressville_the_event_post_class( $event_occurrence['postid'] ); ?>>
						<div class="post__inner">

							<?php if ( has_post_thumbnail( $event_occurrence['postid'] ) ) : ?>
							<!-- POST HEADER : begin -->
							<header class="post__header">

								<?php // Post thumbnail
								lsvr_pressville_the_event_post_archive_thumbnail( $event_occurrence['postid'] ); ?>

							</header>
							<!-- POST HEADER : end -->
							<?php endif; ?>

							<!-- POST CONTENT : begin -->
							<div class="post__content">

								<!-- POST DATE : begin -->
								<p class="post__date">
									<time datetime="<?php echo esc_attr( date_i18n( 'c', strtotime( $event_occurrence['start'] ) ) ); ?>">
										<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $event_occurrence['start'] ) ) ); ?>
									</time>
								</p>
								<!-- POST DATE : end -->

								<!-- POST TITLE : begin -->
								<h3 class="post__title">
									<a href="<?php echo get_permalink( $event_occurrence['postid'] ); ?>" class="post__title-link" rel="bookmark"><?php echo esc_html( get_the_title( $event_occurrence['postid'] ) ); ?></a>
								</h3>
								<!-- POST TITLE : end -->

								<!-- POST META : begin -->
								<p class="post__meta">
									<span class="post__meta-time"><?php lsvr_pressville_the_event_archive_time( $event_occurrence, esc_html__( '%s - %s', 'pressville' ) ); ?></span>
									<span class="post__meta-location"><?php lsvr_pressville_the_event_location_linked( $event_occurrence['postid'], esc_html__( 'at %s', 'pressville' ) ); ?></span>
								</p>
								<!-- POST META : end -->

							</div>
							<!-- POST CONTENT : begin -->

						</div>
					</article>
					<!-- POST : end -->

				</div>

				<?php lsvr_pressville_the_event_post_archive_grid_end( $i, count( $event_occurrences ) ); ?>

			<?php $i++; endforeach; ?>

		</div>
		<!-- POST ARCHIVE GRID : end -->

		<?php // Pagination
		lsvr_pressville_the_event_archive_pagination(); ?>

	<?php else : ?>

		<?php lsvr_pressville_the_alert_message( esc_html__( 'No events matched your criteria', 'pressville' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->