<!-- POST ARCHIVE : begin -->
<div class="lsvr_gallery-post-page post-archive lsvr_gallery-post-archive lsvr_gallery-post-archive--grid">

	<?php // ARCHIVE HEADER
	get_template_part( 'template-parts/lsvr_gallery/archive-header' ); ?>

	<?php // Gallery categories
	if ( true === get_theme_mod( 'lsvr_gallery_archive_categories_enable', true ) ) {
		lsvr_pressville_the_post_archive_categories( 'lsvr_gallery', 'lsvr_gallery_cat' );
	} ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE GRID : begin -->
		<div class="post-archive__grid">
			<div class="<?php lsvr_pressville_the_gallery_post_archive_grid_class(); ?>">

				<?php while ( have_posts() ) : the_post(); ?>

					<div class="<?php lsvr_pressville_the_gallery_post_archive_grid_column_class(); ?>">

						<!-- POST : begin -->
						<article <?php post_class( 'post' ); ?>
							<?php lsvr_pressville_the_gallery_post_background_thumbnail( get_the_ID() ); ?>>
							<div class="post__inner">
								<div class="post__bg">

									<!-- POST CONTENT : begin -->
									<div class="post__content">

										<!-- POST TITLE : begin -->
										<h2 class="post__title">
											<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
										</h2>
										<!-- POST TITLE : end -->

										<!-- POST META : begin -->
										<p class="post__meta">

											<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time>

											<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>
												<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_gallery_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
											<?php endif; ?>

											<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_image_count_enable', true ) ) : ?>
												<span class="post__meta-images-count"><?php echo esc_html( sprintf( _n( '%d image', '%d images', lsvr_pressville_get_gallery_images_count( get_the_ID() ), 'pressville' ), lsvr_pressville_get_gallery_images_count( get_the_ID() ) ) ); ?></span>
											<?php endif; ?>

										</p>
										<!-- POST META : end -->

									</div>
									<!-- POST CONTENT : end -->

									<!-- OVERLAY LINK : begin -->
									<a href="<?php the_permalink(); ?>"
										class="post__overlay-link">
										<span class="screen-reader-text"><?php esc_html_e( 'Open Gallery', 'pressville' ); ?></span>
									</a>
									<!-- OVERLAY LINK : end -->

								</div>
							</div>
						</article>
						<!-- POST : end -->

					</div>

				<?php endwhile; ?>

			</div>
		</div>
		<!-- POST ARCHIVE GRID : end -->

		<?php // PAGINATION
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_pressville_the_alert_message( esc_html__( 'No galleries matched your criteria', 'pressville' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->