<!-- POST ARCHIVE : begin -->
<div class="lsvr_person-post-page post-archive lsvr_person-post-archive lsvr_person-post-archive--default">

	<?php // ARCHIVE HEADER
	get_template_part( 'template-parts/lsvr_person/archive-header' ); ?>

	<?php // Person categories
	if ( true === get_theme_mod( 'lsvr_person_archive_categories_enable', true ) ) {
		lsvr_pressville_the_post_archive_categories( 'lsvr_person', 'lsvr_person_cat' );
	} ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE GRID : begin -->
		<div class="post-archive__grid">
			<div class="<?php lsvr_pressville_the_person_post_archive_grid_class(); ?>">

				<?php while ( have_posts() ) : the_post(); ?>

					<div class="<?php lsvr_pressville_the_person_post_archive_grid_column_class(); ?>">

						<!-- POST : begin -->
						<article <?php post_class( 'post' ); ?>>
							<div class="post__inner">

								<!-- POST HEADER : begin -->
								<header class="post__header">

									<?php if ( has_post_thumbnail() ) : ?>

										<!-- POST THUMBNAIL : begin -->
										<p class="post__thumbnail">
											<a href="<?php the_permalink(); ?>" class="post__thumbnail-link"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
										</p>
										<!-- POST THUMBNAIL : end -->

									<?php endif; ?>

									<!-- POST TITLE : begin -->
									<h2 class="post__title">
										<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
									</h2>
									<!-- POST TITLE : end -->

									<?php if ( lsvr_pressville_has_person_role( get_the_ID() ) ) : ?>
									<!-- POST SUBTITLE : begin -->
									<h6 class="post__subtitle"><?php lsvr_pressville_the_person_role( get_the_ID() ); ?></h6>
									<!-- POST SUBTITLE : end -->
									<?php endif; ?>

								</header>
								<!-- POST HEADER : end -->

								<?php if ( has_excerpt( get_the_ID() ) ) : ?>
								<!-- POST CONTENT : begin -->
								<div class="post__content">

									<?php the_excerpt(); ?>

								</div>
								<!-- POST CONTENT : end -->
								<?php endif; ?>

								<?php // Social links
								lsvr_pressville_the_person_social_links( get_the_ID() ); ?>

							</div>
						</article>
						<!-- POST : end -->

					</div>

				<?php endwhile; ?>

			</div>
		</div>
		<!-- POST ARCHIVE GRID : end -->

	<?php else : ?>

		<?php lsvr_pressville_the_alert_message( esc_html__( 'There are no person posts', 'pressville' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->