<?php

/**
 * Calls the class on the post edit screen.
 */
function copper_call_metaboxClass() {
    new copper_metaboxClass();
}

if ( is_admin() ) {
    add_action( 'load-post.php', 'copper_call_metaboxClass' );
    add_action( 'load-post-new.php', 'copper_call_metaboxClass' );
}

/** 
 * The Class.
 */
class copper_metaboxClass {

	/**
	 * Hook into the appropriate actions when the class is constructed.
	 */
	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	/**
	 * Adds the meta box container.
	 */
	public function add_meta_box( $post_type ) {
            $post_types = array('page');     //limit meta box to certain post types
            if ( in_array( $post_type, $post_types )) {
		add_meta_box(
			'some_meta_box_name'
			,__( 'Copper Metabox Options', 'copper' )
			,array( $this, 'render_meta_box_content' )
			,$post_type
			,'advanced'
			,'high'
		);
            }
	}

	/**
	 * Save the meta when the post is saved.
	 *
	 * @param int $post_id The ID of the post being saved.
	 */
	public function save( $post_id ) {
	
		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times.
		 */

		// Check if our nonce is set.
		if ( ! isset( $_POST['copper_inner_custom_box_nonce'] ) )
			return $post_id;

		$nonce = $_POST['copper_inner_custom_box_nonce'];

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'copper_inner_custom_box' ) )
			return $post_id;

		// If this is an autosave, our form has not been submitted,
                //     so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
			return $post_id;

		// Check the user's permissions.
		if ( 'page' == $_POST['post_type'] ) {

			if ( ! current_user_can( 'edit_page', $post_id ) )
				return $post_id;
	
		} else {

			if ( ! current_user_can( 'edit_post', $post_id ) )
				return $post_id;
		}

		/* OK, its safe for us to save the data now. */

		// Sanitize the user input.
		
		$show_breadcrumb  = sanitize_text_field( $_POST['copper_show_breadcrumb'] );
		$show_title       = sanitize_text_field( $_POST['copper_show_title'] );
		$sidebar          = sanitize_text_field( $_POST['copper_layout'] );
        
	    $options = array(
						 "show_breadcrumb" => $show_breadcrumb,
						 "show_title"   => $show_title,
						 "layout"          => $sidebar
						 );
		
       $optionsJson = json_encode($options);
		// Update the meta field.

		update_post_meta( $post_id, '_copper_metabox_options', $optionsJson );
	
	}


	/**
	 * Render Meta Box content.
	 *
	 * @param WP_Post $post The post object.
	 */
	public function render_meta_box_content( $post ) {
	global $post_type;

		// Add an nonce field so we can check for it later.
		wp_nonce_field( 'copper_inner_custom_box', 'copper_inner_custom_box_nonce' );

		// Use get_post_meta to retrieve an existing value from the database.
	    $metabox_options     = get_post_meta( $post->ID, '_copper_metabox_options', true );
		
		$show_title  = "";
		$show_breadcrumb = "";
		$layout = "";
		if( $metabox_options ){
		$metaboxArray    = json_decode($metabox_options ,true);
		extract($metaboxArray );
		}
		$return = "";
	   
	// Display the form, using the current value.
		$return  = '<p class="meta-options"><label for="copper_show_title"  style="display: inline-block;width: 150px;">';
		$return .= __( 'Show Title :', 'copper' );
		$return .= '</label> ';
		$return .= '<select name="copper_show_title" id="copper_show_title"><option '.selected("on",$show_title,false).' value="on">'.__("Yes","copper").'</option><option '.selected("off",$show_title,false).' value="off">'.__("No","copper").'</option></select></p>';
		
		// Display the form, using the current value.
		$return .= '<p class="meta-options"><label for="copper_show_breadcrumb"  style="display: inline-block;width: 150px;">';
		$return .= __( 'Show Breadcrumb :', 'copper' );
		$return .= '</label> ';
		$return .= '<select name="copper_show_breadcrumb" id="copper_show_breadcrumb"><option '.selected("on",$show_breadcrumb,false).' value="on">'.__("Yes","copper").'</option><option '.selected("off",$show_breadcrumb,false).' value="off">'.__("No","copper").'</option></select></p>';

	   
		$return .= '<p class="meta-options"><label for="copper_layout"  style="display: inline-block;width: 150px;">';
		$return .=__( 'Choose Sidebar Layout :', 'copper' );
		$return .= '</label> ';
		$return .= '<select name="copper_layout" id="copper_layout">
		<option  value="right-sidebar" '.selected("right-sidebar",$layout,false).'>'.__("right sidebar","copper").'</option>
		<option  value="left-sidebar" '.selected("left-sidebar",$layout,false).'>'.__("left sidebar","copper").'</option>
		<option  value="dual-sidebar" '.selected("dual-sidebar",$layout,false).'>'.__("dual sidebar","copper").'</option>
		<option  value="full-width" '.selected("full-width",$layout,false).'>'.__("full width","copper").'</option>
		</select></p>';
		
		echo $return ;
		
	}
}