<?php


function copper_setup(){
	global $content_width;
	$lang = get_template_directory(). '/languages';
	load_theme_textdomain('copper', $lang);
	add_theme_support( 'post-thumbnails' ); 
	$background_args = array();
	$header_args     = array( 
	    'default-image'          => '',
		 'default-repeat' => 'repeat',
        'default-text-color'     => '888888',
        'width'                  => 1170,
        'height'                 => 120,
        'flex-height'            => true
     );
	add_theme_support( 'custom-background', $background_args );
	add_theme_support( 'custom-header', $header_args );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support('nav_menus');
	register_nav_menus( array('primary' => __( 'Primary Menu', 'copper' )));
	add_editor_style("editor-style.css");
	add_image_size( 'portfolio-thumb', 300, 200, true ); //(cropped)
    add_image_size( 'news-thumb', 220, 160, true ); //(cropped)
	add_image_size( 'blog-thumb', 410, 308, true ); //(cropped)
	add_image_size( 'blog-wide-thumb', 728, 546, true ); //(cropped)
	if ( ! isset( $content_width ) ) $content_width = 1170;
}

add_action( 'after_setup_theme', 'copper_setup' );


 function copper_custom_scripts(){

	global $wp_styles,$is_IE;
	wp_enqueue_style('copper-font-awesome', get_template_directory_uri() .'/css/font-awesome.min.css', false, '4.0.3', false);
    wp_enqueue_style('copper-flexslider', get_template_directory_uri() .'/css/flexslider.css', false, '2.2', false);
	wp_enqueue_style('copper-bootstrap', get_template_directory_uri() .'/css/bootstrap.css', false, '3.0.3', false);
	wp_enqueue_style( 'copper-main', get_stylesheet_uri(), array(), '1.0.0' );
	wp_enqueue_style('copper-prettyPhoto',  get_template_directory_uri() .'/css/prettyPhoto.css', false, '', false);
	wp_enqueue_style( 'Yanone-Kaffeesatz', esc_url('//fonts.googleapis.com/css?family=Yanone+Kaffeesatz'), false, '', false );
	wp_enqueue_style( 'Open-Sans', esc_url('//fonts.googleapis.com/css?family=Open+Sans'), false, '', false );
	
	$custom_style = "";
		//// header background
	$header_image = get_header_image();
	if (isset($header_image) && ! empty( $header_image )) {
	$custom_style .= "header#header{background:url(".$header_image. ") ;}\n";
	}
    if ( 'blank' == get_header_textcolor() || '' == get_header_textcolor() )
     $blog_title_style = ' display:none;';
        else
     $blog_title_style = ' color:#' . get_header_textcolor() . ';';
	
	$custom_style  .=  "#header .site-name,#header .tagline{".$blog_title_style."}\n";	
	
	//// footer widget background
	
	$footer_widget_background = copper_options_array('footer_widget_background');

	if ($footer_widget_background) {
	if (isset($footer_widget_background['image']) && $footer_widget_background['image']!="") {
	$custom_style  .=  "body #footer,#footer .widgettitle{background-image:url(".$footer_widget_background['image']. ") ;background-repeat: ".$footer_widget_background['repeat'].";background-position: ".$footer_widget_background['position'].";background-attachment: ".$footer_widget_background['attachment']."}\n";
	}
	
	if(isset($footer_widget_background['color']) && $footer_widget_background['color'] !=""){
	$custom_style  .=  "body #footer,#footer .widgettitle{ background-color:".$footer_widget_background['color'].";}\n";
	}
	}
		//// footer copyright background
	
	$footer_copyright_background = copper_options_array('footer_copyright_background');
	if ($footer_copyright_background) {
	if (isset($footer_copyright_background['image']) && $footer_copyright_background['image']!="") {
	$custom_style  .=  "body #copyright{background-image:url(".$footer_copyright_background['image']. ")  ;background-repeat:".$footer_copyright_background['repeat'].";background-position ".$footer_copyright_background['position']."background-attachment: ".$footer_copyright_background['attachment']."}\n";
	}

	if(isset($footer_copyright_background['color']) && $footer_copyright_background['color'] !=""){
	$custom_style  .=  "body #copyright{ background-color:".$footer_copyright_background['color'].";}\n";
	}
	}
	
    $custom_style  .=  copper_options_array("custom_css");
    wp_add_inline_style( 'copper-main', $custom_style );
	
	wp_enqueue_script( 'copper-jquery-ui', get_template_directory_uri().'/js/jquery-ui.min.js', array( 'jquery' ), '', false );
 	wp_enqueue_script( 'copper-bootstrap', get_template_directory_uri().'/js/bootstrap.min.js', array( 'jquery' ), '', false );
	wp_enqueue_script( 'copper-prettyPhoto', get_template_directory_uri().'/js/jquery.prettyPhoto.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'copper-owl-carousel', get_template_directory_uri().'/js/owl.carousel.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'copper-flexslider', get_template_directory_uri().'/js/jquery.flexslider-min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'copper-respond', get_template_directory_uri().'/js/respond.min.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'copper-main', get_template_directory_uri().'/js/copper.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'copper-modernizr', get_template_directory_uri().'/js/modernizr.custom.js', array( 'jquery' ), '', true );
	if( $is_IE ) {
	wp_enqueue_script( 'copper-html5', get_template_directory_uri().'/js/html5.js', array( 'jquery' ), '', false );
	}
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ){wp_enqueue_script( 'comment-reply' );}
	
	wp_localize_script( 'copper-main', 'copper_params',  array(
			'ajaxurl'        => admin_url('admin-ajax.php'),
			'themeurl' => get_template_directory_uri(),
		)  );
	}
		

   if (!is_admin()) {
  add_action( 'wp_enqueue_scripts', 'copper_custom_scripts' );
  }





function copper_of_get_options($default = false) {
	
	$optionsframework_settings = get_option(COPPER_OPTIONS_PREFIXED.'optionsframework');
	
	// Gets the unique option id
	$option_name = $optionsframework_settings['id'];
	
	if ( get_option($option_name) ) {
		$options = get_option($option_name);
	}
		
	if ( isset($options) ) {
		return $options;
	} else {
		return $default;
	}
}

global $copper_options;
$copper_options = copper_of_get_options();

function copper_options_array($name){
	global $copper_options;
	if(isset($copper_options[$name]))
	return $copper_options[$name];
	else
	return "";
}
// set default options
function copper_on_switch_theme(){
	
global $copper_options;
 $optionsframework_settings = get_option( COPPER_OPTIONS_PREFIXED.'optionsframework' );
 if(!get_option($optionsframework_settings['id'])){
 $config = array();
 $output = array();
 $location = apply_filters( 'options_framework_location', array('admin-options.php') );

	        if ( $optionsfile = locate_template( $location ) ) {
	            $maybe_options = require_once $optionsfile;
	            if ( is_array( $maybe_options ) ) {
					$options = $maybe_options;
	            } else if ( function_exists( 'optionsframework_options' ) ) {
					$options = optionsframework_options();
				}
	        }
		if(isset($options)){
	    $options = apply_filters( 'of_options', $options );
		$config  =  $options;
		foreach ( (array) $config as $option ) {
			if ( ! isset( $option['id'] ) ) {
				continue;
			}
			if ( ! isset( $option['std'] ) ) {
				continue;
			}
			if ( ! isset( $option['type'] ) ) {
				continue;
			}
				$output[$option['id']] = apply_filters( 'of_sanitize_' . $option['type'], $option['std'], $option );
		}
		}
		add_option($optionsframework_settings['id'],$output);
		
}

//default home page widget areas
	 if(!get_option( '_copper_home_widget_area' )){
		 
		$default_sections_json = '{"section-widget-area-name":["Home Area One","Home Area Two","Home Area Three","Home Area Four","Home Area Five"],"list-item-color":["","","","",""],"list-item-image":["","","","",""],"list-item-repeat":["","","","no-repeat",""],"list-item-position":["","","","",""],"list-item-attachment":["","","","",""],"widget-area-layout":["boxed","full","boxed","boxed","boxed"],"widget-area-padding":["0","0","0","0","0"],"widget-area-column":["1","1","1","2","2"],"widget-area-column-item":{"home-area-one":["3","3","3","3"],"home-area-two":["12"],"home-area-three":["12"],"home-area-four":["6","6"],"home-area-five":["6","6"]}}';
			
		add_option('_copper_home_widget_area' ,$default_sections_json);
			 
			 }
			 
$copper_options = copper_of_get_options();
}
add_action( 'after_setup_theme', 'copper_on_switch_theme' );
add_action('after_switch_theme', 'copper_on_switch_theme');

/* 
 * This is an example of how to add custom scripts to the options panel.
 * This one shows/hides the an option when a checkbox is clicked.
 */

add_action('optionsframework_custom_scripts', 'copper_optionsframework_custom_scripts');

function copper_optionsframework_custom_scripts() { 

}

add_filter('options_framework_location','copper_options_framework_location_override');

function copper_options_framework_location_override() {
	return array('includes/admin-options.php');
}

function copper_optionscheck_options_menu_params( $menu ) {
	
	$menu['page_title'] = __( 'Theme Options', 'copper');
	$menu['menu_title'] = __( 'Theme Options', 'copper');
	$menu['menu_slug'] = 'copper-options';
	return $menu;
}

add_filter( 'optionsframework_menu', 'copper_optionscheck_options_menu_params' );

function copper_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 )
		$title = "$title $sep " . sprintf( __( ' Page %s ', 'copper' ), max( $paged, $page ) );

	return $title;
}
add_filter( 'wp_title', 'copper_wp_title', 10, 2 );


function copper_title( $title ) {
if ( $title == '' ) {
return 'Untitled';
} else {
return $title;
}
}
add_filter( 'the_title', 'copper_title' );

if(isset($_POST['widget-area']) && is_array($_POST['widget-area'])){
	$copper_list_item = json_encode($_POST['widget-area']);
	update_option("_copper_home_widget_area",$copper_list_item );
	}
	
	if ( isset( $_POST['reset'] ) ) {
	 $output = array();
 $location = apply_filters( 'options_framework_location', array('admin-options.php') );

	        if ( $optionsfile = locate_template( $location ) ) {
	            $maybe_options = require_once $optionsfile;
	            if ( is_array( $maybe_options ) ) {
					$options = $maybe_options;
	            } else if ( function_exists( 'optionsframework_options' ) ) {
					$options = optionsframework_options();
				}
	        }
			
		if(isset($options)){
			$config  =  $options;
			foreach ( (array) $config as $option ) {
			
				if(isset($option['id']) && $option['id']=='home_page_sections'){
					update_option("_copper_home_widget_area",$option['std'] );
					}
				}
			
		}

		}
	add_action( 'wp_head', 'copper_favicon' );

	function copper_favicon()
	{
	    $url =  copper_options_array('favicon');
	
		$icon_link = "";
		if($url)
		{
			$type = "image/x-icon";
			if(strpos($url,'.png' )) $type = "image/png";
			if(strpos($url,'.gif' )) $type = "image/gif";
		
			$icon_link = '<link rel="icon" href="'.esc_url($url).'" type="'.$type.'">';
		}
		
		echo $icon_link;
	}
