<?php

#########################################
function copper_widgets_init() {
		register_sidebar(array(
			'name' => 'Default Widget',
			'id' 					=> 'default_widget',
		    'description'   	=> __( 'Default widget.', 'cooper' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));

		
				//sidebar
		register_sidebar(array(
			'name' => 'Post Left Sidebar',
			'id'   => 'post_left_sidebar',
			'before_widget' => '<div id="%1$s" class="widget widget-box %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<h2 class="widgettitle">', 
			'after_title' => '</h2>' 
			));
		register_sidebar(array(
			'name' => 'Post Right Sidebar',
			'id'   => 'post_right_sidebar',
			'before_widget' => '<div id="%1$s" class="widget widget-box %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<h2 class="widgettitle">', 
			'after_title' => '</h2>' 
			));
		register_sidebar(array(
			'name' => 'Page Left Sidebar',
			'id'   => 'page_left_sidebar',
			'before_widget' => '<div id="%1$s" class="widget widget-box %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<h2 class="widgettitle">', 
			'after_title' => '</h2>' 
			));
		register_sidebar(array(
			'name' => 'Page Right Sidebar',
			'id'   => 'page_right_sidebar',
			'before_widget' => '<div id="%1$s" class="widget widget-box %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<h2 class="widgettitle">', 
			'after_title' => '</h2>' 
			));
		
		register_sidebar(array(
			'name' => 'Category Sidebar',
			'id'   => 'category_sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		register_sidebar(array(
			'name' => 'Blog Sidebar',
			'id'   => 'blog_sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		
		register_sidebar(array(
			'name' => 'Search Page Sidebar',
			'id'   => 'search_sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		
			register_sidebar(array(
			'name' => 'Archive Page Sidebar',
			'id'   => 'archive_sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		//footer
		register_sidebar(array(
			'name' => 'Footer Area One',
			'id' 					=> 'footer_area_one',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		register_sidebar(array(
			'name' => 'Footer Area Two',
			'id' 					=> 'footer_area_two',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		register_sidebar(array(
			'name' => 'Footer Area Three',
			'id' 					=> 'footer_area_three',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		register_sidebar(array(
			'name' => 'Footer Area Four',
			'id' 					=> 'footer_area_four',
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<div class="heading"><h3 class="widgettitle">', 
			'after_title' => '</h3></div>', 
			));
		
			
	$home_widget_areas = get_option('_copper_home_widget_area');
    if($home_widget_areas !=""){
    $home_sections_array = json_decode($home_widget_areas, true);
    if(isset($home_sections_array['section-widget-area-name']) && is_array($home_sections_array['section-widget-area-name']) ){
	$num = count($home_sections_array['section-widget-area-name']);
	for($i=0; $i<$num; $i++ ){
	$areaname          = isset($home_sections_array['section-widget-area-name'][$i])?$home_sections_array['section-widget-area-name'][$i]:"";
	$sanitize_areaname = sanitize_title($areaname);
	$columns           = isset($home_sections_array['widget-area-column-item'][$sanitize_areaname ])?$home_sections_array['widget-area-column-item'][$sanitize_areaname ]:array("12");
	$j                = 1;
	$column_num       = count($columns);
		 foreach($columns as $widget){
			 if($column_num > 1){
				 $widget_name = $areaname." (".$columns[$j-1]."/12)";
				 }else{
				 $widget_name = $areaname;
				 }
			
			register_sidebar(array(
			'name' => $widget_name,
			'id'   => sanitize_title($areaname."-column-".$j),
			'before_widget' => '<div id="%1$s" class="widget %2$s">', 
			'after_widget' => '<span class="seperator extralight-border"></span></div>', 
			'before_title' => '<h3 class="widgettitle">', 
			'after_title' => '</h3>'
			));
			
			$j++;
		  
		   }
		 
	   }
	  }
	}
		
		register_widget( "copper_service_widget" );
		register_widget( "copper_carousel_widget" );
		register_widget( "copper_testimonial_widget" );
		register_widget( "copper_news_widget" );
		register_widget( "copper_call_to_action_widget" );
		register_widget( "copper_divider_widget" );
		register_widget( "copper_recent_posts" );
		register_widget( "copper_popular_posts" );
		register_widget( "copper_contact" );
				
}

add_action( 'widgets_init', 'copper_widgets_init' );


/**
 *  service widget.
 */
class copper_service_widget extends WP_Widget {
 	function copper_service_widget() {
 		$widget_ops = array( 'classname' => 'widget_service_block', 'description' => __( 'Display services. Best for home page area one.', 'copper' ) );
		$control_ops = array( 'width' => 200, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Services', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'text' =>'', 'link'=>'','icon'=>'fa fa-edit' ) );
		$title   = strip_tags($instance['title']);
		$link    = esc_url($instance['link']);
		$text    = esc_textarea($instance['text']);
		$icon    = strip_tags($instance['icon']);
		
		?>
        
  
       
       <p><label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e( 'Icon(Icon url or Font Awesome icon name):', 'copper' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="text" value="<?php echo esc_attr($icon); ?>" /></p>
        
       <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
        
         <p><label for="<?php echo $this->get_field_id('link'); ?>"><?php _e( 'Link:', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo esc_attr($link); ?>" /></p>
        
        
        <?php _e( 'Description:','copper' ); ?>
		<textarea class="widefat" style="margin-bottom:10px;" rows="10" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>
        
        <?php }

	function update( $new_instance, $old_instance ) {
		 //save the widget
        $instance = $old_instance;
        $instance['title']  = strip_tags($new_instance['title']);
		$instance['link']   = esc_url($new_instance['link']);
        $instance['text']   = esc_textarea($new_instance['text']); 
		$instance['icon']   = strip_tags($new_instance['icon']); 
		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 		extract( $instance );

		echo $before_widget;
		
 $result =  '<div class="service-box">';
  if($icon != ""){
	   
  if(strstr($icon,"http")){
  $result .= '<img src="'.$icon.'" alt="'.$title.'" />';
  }else{
  
  
  $result .=	   '<div class="service-icon font-icon">';
  $result .=  '<i class="'.$icon.'"></i>';
  $result .= '</div>';
  }
  
  }
				   
 $result .= '<h2 class="service-title">'. $instance['title'].'</h2>
                <p>'. $instance['text'].'</p>';
				
 if($instance['link'] != ""){		
 $result .= '<div class="read-more"><i class="fa fa-angle-double-right"></i> <a href="'. $instance['link'].'">'.__('Read More','copper').'</a></div>';
 }
 $result .= '</div>';
 echo $result;
				
       echo $after_widget;
 	}
 }
/****************************************************************************************/

/**
 *  pages carousel widget.
 */
class copper_carousel_widget extends WP_Widget {
 	function copper_carousel_widget() {
 		$widget_ops = array( 'classname' => 'widget_carousel_block', 'description' => __( 'Display some pages as carousel. Best for home page area two.', 'copper' ) );
		$control_ops = array( 'width' => 200, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Carousel', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
		 $defaults = array(
            'carousel-postid' => 0,'title' => '','icon'=>'fa fa-hand-o-right'
        );
	
        $instance = wp_parse_args((array) $instance, $defaults);
	    $carousel_postids = array();
		$title            = strip_tags($instance['title']);
		$icon             = strip_tags($instance['icon']);
        $carousel_postids = explode(",",$instance['carousel-postid']);


        // display all title of posts with a checkbox
        $args = array(
        'post_type' => 'page',
        'posts_per_page'=>-1
        );
        $the_query = new WP_Query($args);
    ?>

         <p><label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e( 'Title Icon( Font Awesome icon name):', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="text" value="<?php echo esc_attr($icon); ?>" /></p>
        
       <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
         <p><label><?php _e( 'Select Pages:', 'copper' ); ?></label>
        <?php
        $content = '<ul>';
		$i       = 1;
        if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {

                $the_query->the_post();
				$checked = "" ;
				if(is_array($carousel_postids) && in_array(get_the_ID(),$carousel_postids))
				{$checked = 'checked="checked"' ;}
                $content = $content.'<li><input type="checkbox" id="'.$this->get_field_id( 'carousel-postid' )."-" .get_the_ID().'" name="'.$this->get_field_name( 'carousel-postid' ) .'[]" value="'.get_the_ID().'" '.$checked.' >&nbsp;&nbsp;'.get_the_title().'</li>';
$i++;
            }
        } else {
            _e( "No pages were found", 'copper' ); 
        }

        $content = $content.'</ul>';
		wp_reset_postdata();
        echo $content;
		
		 }

	function update( $new_instance, $old_instance ) {
		 //save the widget
        $instance = $old_instance;
		$new_instance['carousel-postid'] = implode(",",$new_instance['carousel-postid']);
        $instance['carousel-postid'] = strip_tags($new_instance['carousel-postid']);
		$instance['title']  = strip_tags($new_instance['title']);
		$instance['icon']   = strip_tags($new_instance['icon']); 
        return $instance;
		
	}

	function widget( $args, $instance ) { 
	    extract($args);
        $tags = get_tags();
        echo $before_widget;
        $icon = "";
		$title_icon =  '';
		$carousel_postids = array();
		if(isset($instance['icon']) && $instance['icon'] != "")
		{
	   	
		$title_icon =  '<i class="'.$icon.'"></i>';
		
		}
		$carousel_postids = explode(",",$instance['carousel-postid']);
     ?>
				
				<div id="latest_works">
            
            <h3 class="section-title"><?php echo $title_icon; echo $instance['title'];?></h3>
            
            <div id="carousel_nav">
                
                <a href="javascript:;" class="arrow-left"><div class="arrow-icon font-icon"><i class="fa fa-angle-left"></i></div></a>
                <a href="javascript:;" class="arrow-right"><div class="arrow-icon font-icon"><i class="fa fa-angle-right"></i></div></a>
            
            </div>
        
            <div id="carousel_wrapper">
            
                <div id="latest-works-list">
                <?php if(is_array($carousel_postids) && !empty($carousel_postids)){  

		               foreach($carousel_postids as $carousel_postid){
						   if(is_numeric($carousel_postid)){
	
						// $carousel_item = get_post($carousel_postid); 
                       //  $title = $carousel_item->post_title;
						 $link  = get_permalink($carousel_postid);
                        
						if (has_post_thumbnail( $carousel_postid) ): 
						$thumb = get_the_post_thumbnail( $carousel_postid , "portfolio-thumb" ); 
						$image = wp_get_attachment_image_src( get_post_thumbnail_id( $carousel_postid ), 'full' );
						

		?>
                    <div class="item">
                    <div class="portfolio-img-box">
                        <?php echo $thumb;?>
                     <div class="portfolio-info">
                                            <div class="portfolio-link-box">
                                                <a href="<?php echo $image[0];?>" rel="portfolio-image"><div class="portfolio-link"><i class="fa fa-search"></i></div></a>
                                                <a href="<?php  echo $link;?>"><div class="portfolio-link"><i class="fa fa-link"></i></div></a>
                                            </div>
                                        </div>
                                        </div>
                    </div>
                   <?php endif; } }}?>
                    
                </div>
            
            </div> <!-- END #carousel_wrapper -->
        
        </div>
<?php 
        echo $after_widget;
		}
 }

/****************************************************************************************/

/**
 *  testimonial widget.
 */
class copper_testimonial_widget extends WP_Widget {
 	function copper_testimonial_widget() {
 		$widget_ops = array( 'classname' => 'widget_testimonial_block', 'description' => __( 'Display testimonials.', 'copper' ) );
		$control_ops = array( 'width' => 200, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Testimonials', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => 'TESTIMONIALS', 'text' =>'<div class="testimonial-item">
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas ut nulla sapien, at aliquam erat. Sed vitae massa tellus. Aliquam commodo
                aliquam metus, sed iaculis nibh tempus id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum ante ipsum primis in faucibus orci
                luctus et ultrices posuere cubilia Curae; Etiam nec nisi in nisl euismod fringilla.
                <br />
                <br />
                <span class="testimonial-name">John Travis, CEO, DomainName.com</span></p>
        </div>

            <div class="testimonial-item">
                <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas ut nulla sapien, at aliquam erat. Sed vitae massa tellus. Aliquam commodo
                aliquam metus, sed iaculis nibh tempus id. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum ante ipsum primis in faucibus orci
                luctus et ultrices posuere cubilia Curae; Etiam nec nisi in nisl euismod fringilla.
                <br />
                <br />
                <span class="testimonial-name">John Travis, CEO, DomainName.com</span></p>
        </div>
		','icon'=>'fa fa-comments-o' ) );
		$title   = strip_tags($instance['title']);
		$text    = esc_textarea($instance['text']);
		$icon    = strip_tags($instance['icon']);
		
		?>
        
       
       
       <p><label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e( 'Title Icon( Font Awesome icon name):', 'copper' ); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="text" value="<?php echo esc_attr($icon); ?>" /></p>
        
       <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
  
        <?php _e( 'Testimonial Description:','copper' ); ?>
		<textarea class="widefat" style="margin-bottom:10px;" rows="10" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>
        
        <?php }

	function update( $new_instance, $old_instance ) {
		 //save the widget
        $instance = $old_instance;
        $instance['title']  = strip_tags($new_instance['title']);
		$instance['icon']   = strip_tags($new_instance['icon']); 
		if ( current_user_can('unfiltered_html') )
			$instance['text'] =  $new_instance['text'];
		else
			$instance['text'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text']) ) ); // wp_filter_post_kses() expects slashed
		$instance['filter'] = isset($new_instance['filter']);
		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 		extract( $instance );

		echo $before_widget;
 $result = '<div id="testimonials">';
 $title_icon = "";
  if($icon != ""){
	   
  if(strstr($icon,"http")){
  $result .= '<img src="'.esc_url($icon).'" alt="'.$title.'" />';
  }else{
  
  $title_icon =  '<i class="'.$icon.'"></i>';
  }
  
  }
 $result .= '<h3 class="section-title">'.$title_icon . $instance['title'].'</h3>
            <div class="testimonials">
			'. $instance['text'].'
			</div></div>';
			
 echo $result;
				
       echo $after_widget;
 	}
 }
 
 /****************************************************************************************/

/**
 *  latest news widget.
 */
class copper_news_widget extends WP_Widget {
 	function copper_news_widget() {
 		$widget_ops = array( 'classname' => 'widget_news_block', 'description' => __( 'Display some latest posts as carousel.', 'copper' ) );
		$control_ops = array( 'width' => 200, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Posts Carousel', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
		 $defaults = array('title' => 'Latest News','list-num' => '6'  ,'icon' => 'fa fa-file');
        $instance = wp_parse_args((array) $instance, $defaults);
		$title            = strip_tags($instance['title']);
		$icon             = strip_tags($instance['icon']);
		$list_num         = absint($instance['list-num']);

    ?>

         <p><label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e( 'Title Icon( Font Awesome icon name):', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="text" value="<?php echo esc_attr($icon); ?>" /></p>
        
       <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e( 'Title:', 'copper' ); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
         
         
         <p>
			<label for="<?php echo $this->get_field_id( 'list-num' ); ?>"><?php _e('List Num :', 'copper'); ?></label>		
			<select name="<?php echo $this->get_field_name( 'list-num' ); ?>" id="<?php echo $this->get_field_id( 'list-num' ); ?>">
				
			<?php 	
			for($i = 1;$i<=10 ;$i++ ){
			?>
				<option value="<?php echo $i; ?>" <?php if (  $list_num == $i ) echo ' selected="selected"'; ?>><?php echo $i; ?></option>				
			<?php }?>	
			</select> 
		</p>
        <?php
 
		
		 }

	function update( $new_instance, $old_instance ) {
		 //save the widget
        $instance = $old_instance;
		$instance['list-num']  = absint($new_instance['list-num']);
		$instance['title']     = strip_tags($new_instance['title']);
		$instance['icon']      = strip_tags($new_instance['icon']); 
        return $instance;
		
	}

	function widget( $args, $instance ) { 
	    extract($args);
        $tags = get_tags();
        echo $before_widget;
        $icon = "";
		$title_icon = "";
		if(isset($instance['icon']) && $instance['icon'] != "")
		{
        
		$title_icon = '<i class="'.$instance['icon'].'"></i>';
		}
        $list_num  = absint($instance['list-num']);

     // display all title of posts with a checkbox
        $args = array(
        'post_type' => 'post',
        'posts_per_page'=>$list_num
        );
		

		 $result = '<div id="latest-posts"><h3 class="section-title">'.$title_icon.$instance['title'].'</h3></div>';
		 $result .= ' <div id="carousel_nav">
                
                <a href="javascript:;" class="news-arrow-left"><div class="arrow-icon font-icon"><i class="fa fa-angle-left"></i></div></a>
                <a href="javascript:;" class="news-arrow-right"><div class="arrow-icon font-icon"><i class="fa fa-angle-right"></i></div></a></div>';
			
		$result .= '<div class="latest-post-list">';
        $the_query = new WP_Query($args);
		 if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {
                $the_query->the_post();
				$thumb = get_the_post_thumbnail( get_the_ID() , "news-thumb" ); 
				$result .= '<div class="item">
       <div class="news-thumb">
       <a href="'.get_permalink().'">'.$thumb.'</a>
       </div>
	    <a href="'.get_permalink().'"> <h2>'.get_the_title().'</h2></a>
       <p>'.get_the_excerpt().'</p>
       </div>';
	   
			}
		 }
		$result .= '</div>';
		echo $result;
		wp_reset_postdata();
        echo $after_widget;
		}
 }
 
 

/**
 * Home page call to action widget.
 */
class copper_call_to_action_widget extends WP_Widget {
 	function copper_call_to_action_widget() {
 		$widget_ops = array( 'classname' => 'widget_call_to_action_block', 'description' => __( 'Use this widget to show the call to action section.', 'copper' ) );
		$control_ops = array( 'width' => 200, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Call To Action Widget', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
 		 $defaults   = array( 'text' => '','button_text'=>'Checkout','button_url'=>'','icon'=>'fa fa-shopping-cart');
 		$instance    = wp_parse_args( (array) $instance, $defaults );
		$text        = esc_textarea( $instance[ 'text' ] );
		$button_text = esc_attr( $instance[ 'button_text' ] );
		$button_url  = esc_url( $instance[ 'button_url' ] );
		$icon        = esc_attr( $instance[ 'icon' ] );
		
		?>
	
		<p><?php _e( 'Call to Action Text','copper' ); ?></p>
		<textarea class="widefat" rows="3" cols="20" id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>"><?php echo $text; ?></textarea>
		
        <p>
			<label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e( 'Button Icon:', 'copper' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="text" value="<?php echo $icon; ?>" />
		</p>
        
		<p>
			<label for="<?php echo $this->get_field_id('button_text'); ?>"><?php _e( 'Button Text:', 'copper' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id('button_text'); ?>" name="<?php echo $this->get_field_name('button_text'); ?>" type="text" value="<?php echo $button_text; ?>" />
		</p>
        
		<p>
			<label for="<?php echo $this->get_field_id('button_url'); ?>"><?php _e( 'Button Redirect Link:', 'copper' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id('button_url'); ?>" name="<?php echo $this->get_field_name('button_url'); ?>" type="text" value="<?php echo $button_url; ?>" />
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		
		if ( current_user_can('unfiltered_html') )
			$instance['text'] =  $new_instance['text'];
		else
			$instance['text'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['text']) ) ); // wp_filter_post_kses() expects slashed

        $instance[ 'icon' ]  = strip_tags( $new_instance[ 'icon' ] );
		$instance[ 'button_text' ] = strip_tags( $new_instance[ 'button_text' ] );
		$instance[ 'button_url' ] = esc_url( $new_instance[ 'button_url' ] );

		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 		extract( $instance );

 		global $post;
 		$text = empty( $instance['text'] ) ? '' : $instance['text'];
 		$button_text = isset( $instance[ 'button_text' ] ) ? $instance[ 'button_text' ] : ''; 		
 		$button_url = isset( $instance[ 'button_url' ] ) ? $instance[ 'button_url' ] : '#';
		$icon    = isset( $instance[ 'icon' ] ) ? $instance[ 'icon' ] : '';
        
		echo $before_widget;
		$button_icon = '';
		if($icon !=""){
		$button_icon = '<i class="'.$icon.' icon-large"></i>';
		}
	
		$result =	'<div class="row">
		<div class="download-section">
        <div class="column col-md-9">
            <p>'.$text.'</p>
            </div>
            <div class="column col-md-3">
			<a href="'.$button_url.'" class="btn btn-large btn-success"> '.$button_icon.$button_text.'</a></div>
        </div><div class="clear"></div></div>';
        echo $result;
	
		echo $after_widget;
 	}
 }



/**
 * divider widget
 */
 class copper_divider_widget extends WP_Widget {
 	function copper_divider_widget() {
 		$widget_ops = array( 'classname' => 'widget_divider', 'description' => __( 'Divider for each row.', 'copper' ) );
		$control_ops = array( 'width' => 350, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Divider', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
	
 	$defaults = array('height' => '10'); 		
	$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		
            <p>
               <label for="<?php echo $this->get_field_id( 'height'  ); ?>">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php _e('Height', 'copper'); ?>:</label>
			<input id="<?php echo $this->get_field_id( 'height'  ); ?>" name="<?php echo $this->get_field_name( 'height'  ); ?>" value="<?php echo $instance['height']; ?>" class="" placeholder="Divider height"/> px
            </p>
            
<?php
	}

 function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
        $instance[ 'height']  = absint( $new_instance['height' ] );

		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 		extract( $instance );
		
		echo $before_widget;
		echo '<div class="divider" style="height:'.$height.'px"></div>';
		echo $after_widget;
 	}
 }
 
 
 /**
 * Popular Posts
 */
 
 class copper_popular_posts extends WP_Widget {
 	function copper_popular_posts() {
 		$widget_ops = array( 'classname' => 'widget_popular_posts', 'description' => '' );
		$control_ops = array( 'width' => 300, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Popular Posts', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
 	    $defaults = array("list_num"=>"4","title"=>"Popular Posts");
 		$instance = wp_parse_args( (array) $instance, $defaults );
 	
	?>
     <p>
               <label for="<?php echo $this->get_field_id( 'title'  ); ?>"><?php _e('Title', 'copper'); ?>:</label><br />
			<input id="<?php echo $this->get_field_id( 'title'  ); ?>" name="<?php echo $this->get_field_name( 'title'  ); ?>" value="<?php echo $instance['title']; ?>" class="" /> 
            </p>
            
		 <p>
               <label for="<?php echo $this->get_field_id( 'list_num'  ); ?>"><?php _e('Popular Posts List Num', 'copper'); ?>:</label><br />
			<input id="<?php echo $this->get_field_id( 'list_num'  ); ?>" name="<?php echo $this->get_field_name( 'list_num'  ); ?>" value="<?php echo $instance['list_num']; ?>" class="" /> 
            </p>
            
		<?php

	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		
			$instance['list_num']  = absint($new_instance['list_num'])  ;
			$instance['title']     = strip_tags($new_instance['title'])  ;

		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 	    $title = apply_filters('Popular Posts', $instance['title'] );
		echo $before_widget;
		if($title)
		echo $before_title . $title . $after_title;
		?>
        <ul>
        <?php 
	query_posts( 'showposts='.$instance['list_num'].'&ignore_sticky_posts=1&orderby=comment_count');
	while ( have_posts() ) : the_post();
?>
   <li>
<?php 
   if ( has_post_thumbnail() ) {
         $featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'blog-thumb');
		 $source = get_site_url();
		 if($featured_image[0] !=""){
			$thumb = $featured_image[0]; 
			echo '<a href="'.get_permalink().'" class="widget-img"><img src="'.$thumb.'" alt="" /></a>';
			 }
												} 
			?>
										
   <a href="<?php the_permalink();?>"><?php the_title();?></a><br />
										<?php echo get_the_date("M D, Y");?>
									</li>
                                    <?php endwhile;wp_reset_postdata();?>	
                                    </ul>
		<?php 
		echo $after_widget;
 	}
 }
 
 /**
 * Recent Posts
 */
 
 class copper_recent_posts extends WP_Widget {
 	function copper_recent_posts() {
 		$widget_ops = array( 'classname' => 'widget_recent_posts', 'description' => '' );
		$control_ops = array( 'width' => 300, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Recent Posts', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
 	    $defaults = array("list_num"=>"4","title"=>"Recent Posts");
 		$instance = wp_parse_args( (array) $instance, $defaults );
 	
	?>
     <p>
               <label for="<?php echo $this->get_field_id( 'title'  ); ?>"><?php _e('Title', 'copper'); ?>:</label><br />
			<input id="<?php echo $this->get_field_id( 'title'  ); ?>" name="<?php echo $this->get_field_name( 'title'  ); ?>" value="<?php echo $instance['title']; ?>" class="" /> 
            </p>
            
		 <p>
               <label for="<?php echo $this->get_field_id( 'list_num'  ); ?>"><?php _e('Recent Posts List Num', 'copper'); ?>:</label><br />
			<input id="<?php echo $this->get_field_id( 'list_num'  ); ?>" name="<?php echo $this->get_field_name( 'list_num'  ); ?>" value="<?php echo $instance['list_num']; ?>" class="" /> 
            </p>
            
		<?php

	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		
			$instance['list_num']  = absint($new_instance['list_num'])  ;
			$instance['title']     = strip_tags($new_instance['title'])  ;

		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 	    $title = apply_filters('Recent Posts', $instance['title'] );
		echo $before_widget;
		if($title)
		echo $before_title . $title . $after_title;
		?>
        <ul>
        <?php 
	query_posts( 'showposts='.$instance['list_num'].'&ignore_sticky_posts=1');
	while ( have_posts() ) : the_post();
?>
   <li>
<?php 
   if ( has_post_thumbnail() ) {
         $featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'blog-thumb');
		 $source = get_site_url();
		 if($featured_image[0] !=""){
			$thumb = $featured_image[0]; 
			echo '<a href="'.get_permalink().'" class="widget-img"><img src="'.$thumb.'" alt="" /></a>';
			 }
												} 
			?>
										
   <a href="<?php the_permalink();?>"><?php the_title();?></a><br />
										<?php echo get_the_date("M D, Y");?>
									</li>
                                    <?php endwhile;wp_reset_postdata();?>	
                                    </ul>
		<?php 
		echo $after_widget;
 	}
 }
 
 /**
 * Contact form
 */
 class copper_contact extends WP_Widget {
 	function copper_contact() {
 		$widget_ops = array( 'classname' => 'widget_contact', 'description' => __( 'Contact form', 'copper' ) );
		$control_ops = array( 'width' => 350, 'height' =>250 ); 
		parent::WP_Widget( false, $name = __( 'Copper: Contact Form', 'copper' ), $widget_ops, $control_ops);
 	}

 	function form( $instance ) {
	$admin_email = get_option( 'admin_email' );
 	$defaults = array('contact_email' => $admin_email,'title'=>'Contact Us'); 		
	$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
         	
		  <p>
               <label for="<?php echo $this->get_field_id( 'title'  ); ?>">&nbsp;&nbsp;<?php _e('Title', 'copper'); ?>:</label>
			<input id="<?php echo $this->get_field_id( 'title'  ); ?>" name="<?php echo $this->get_field_name( 'title'  ); ?>" value="<?php echo $instance['title']; ?>" class="" /> 
            </p>
           
            <p>
            <label for="<?php echo $this->get_field_id( 'contact_email'  ); ?>"><?php _e('Email', 'copper'); ?>:</label>
			<input id="<?php echo $this->get_field_id( 'contact_email'  ); ?>" name="<?php echo $this->get_field_name( 'contact_email'  ); ?>" value="<?php echo $instance['contact_email']; ?>" class="" />
            
            
            </p>
            <p><?php _e("Your email address which use to receive email.","copper");?></p>

		<?php

	}

 function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
        $instance[ 'contact_email']  =  $new_instance['contact_email'] ;
	    $instance['title']           = strip_tags($new_instance['title'])  ;
	

		return $instance;
	}

	function widget( $args, $instance ) {
 		extract( $args );
 		extract( $instance );
		
		 $title = apply_filters('Contact Us', $title );
		echo $before_widget;
		if($title)
		echo $before_title . $title . $after_title;
		
		echo '<div class="contact">
									
									<form action="'.esc_url(home_url('/')).'" class="contact-form" method="post">
			                        	<fieldset>
											<section>
												<label for="contact-name" class="sr-only">'.__("Name","copper").'</label>
												<input type="text" name="contact-name" id="contact-name" placeholder="'.__("YOUR NAME","copper").'*" tabindex="1" required="" aria-required="true">
											</section>
											<section>
												<label for="contact-email" class="sr-only">'.__("Email","copper").'</label>
												<input type="email" name="contact-email" id="contact-email" placeholder="'.__("YOUR E-MAIL","copper").'*" tabindex="2" required="" aria-required="true">
											</section>
											<section>
												<label for="contact-msg" class="sr-only">'.__("Message","copper").'</label>
												<textarea name="contact-msg" id="contact-msg" cols="39" rows="5" tabindex="3" placeholder="'.__("YOUR MESSAGE","copper").'*"></textarea>
											</section>
										</fieldset>
										<section>
											<span><div id="loading" class="noticefailed"></div></span><input type="submit" class="btn-normal contact-submit" value="'.__("SEND","copper").'">
										</section>
									</form>
								</div>';
		echo $after_widget;
 	}
 }