<?php if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings = array(
	'menu_title'      => __( 'Settings', 'logo-carousel-pro' ),
	'menu_parent'     => 'edit.php?post_type=sp_logo_carousel',
	'menu_type'       => 'submenu', // menu, submenu, options, theme, etc.
	'menu_slug'       => 'lcpro_settings',
	'ajax_save'       => true,
	'show_reset_all'  => false,
	'framework_title' => __( 'Logo Carousel Pro', 'logo-carousel-pro' ),
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options = array();

// ----------------------------------------
// a option section for options overview  -
// ----------------------------------------
$options[] = array(
	'name'   => 'advanced_settings',
	'title'  => __( 'Advanced Settings', 'logo-carousel-pro' ),
	'icon'   => 'fa fa-cogs',

	// begin: fields
	'fields' => array(
		array(
			'id'      => 'lcpro_google_fonts',
			'type'    => 'switcher',
			'title'   => __( 'Google Fonts?', 'logo-carousel-pro' ),
			'desc'    => __( 'Enqueue/Dequeue google fonts.', 'logo-carousel-pro' ),
			'default' => true,
		),
		array(
			'id'         => 'lcpro_enqueue_css_heading',
			'type'       => 'subheading',
			'content'    => __( 'CSS Enqueue/Dequeue', 'logo-carousel-pro' ),
		),
		array(
			'id'         => 'lcpro_fontawesome_css',
			'type'       => 'switcher',
			'title'      => __( 'FontAwesome CSS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue FontAwesome CSS for front-end.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_slick_css',
			'type'       => 'switcher',
			'title'      => __( 'Slick CSS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue slick CSS.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_bxslider_css',
			'type'       => 'switcher',
			'title'      => __( 'BXSlider CSS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue bxslider CSS.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_tooltipster_css',
			'type'       => 'switcher',
			'title'      => __( 'Tooltipster CSS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue tooltipster CSS.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_enqueue_js_heading',
			'type'       => 'subheading',
			'content'    => __( 'JS Enqueue/Dequeue', 'logo-carousel-pro' ),
		),
		array(
			'id'         => 'lcpro_remodal_js',
			'type'       => 'switcher',
			'title'      => __( 'Remodal JS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue remodal js.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_bxslider_js',
			'type'       => 'switcher',
			'title'      => __( 'BXSlider JS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue bxslider js.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_slick_js',
			'type'       => 'switcher',
			'title'      => __( 'Slick JS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue slick js.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_tooltipster_js',
			'type'       => 'switcher',
			'title'      => __( 'Tooltipster JS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue tooltipster js.', 'logo-carousel-pro' ),
			'default'    => true,
		),
		array(
			'id'         => 'lcpro_isotope_js',
			'type'       => 'switcher',
			'title'      => __( 'Isotope JS', 'logo-carousel-pro' ),
			'desc'       => __( 'Enqueue/Dequeue isotope js.', 'logo-carousel-pro' ),
			'default'    => true,
		),

	), // end: fields
);




// ------------------------------
// Custom CSS                   -
// ------------------------------
$options[] = array(
	'name'   => 'custom_css_section',
	'title'  => __( 'Custom CSS', 'logo-carousel-pro' ),
	'icon'   => 'fa fa-css3',
	'fields' => array(

		array(
			'id'    => 'lcpro_custom_css',
			'type'  => 'textarea',
			'title' => __( 'Custom CSS', 'logo-carousel-pro' ),
			'desc'  => __( 'Type your custom css.', 'logo-carousel-pro' ),
		),
	)
);


SP_LCPRO_Framework::instance( $settings, $options );
