<?php if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options = array();

// -----------------------------------------
// Shortcode Generator Options.
// -----------------------------------------
$options[] = array(
	'id'        => 'sp_lcp_shortcode_options',
	'title'     => __( 'Shortcode Options', 'logo-carousel-pro' ),
	'post_type' => 'sp_lcp_shortcodes',
	'context'   => 'normal',
	'priority'  => 'default',
	'sections'  => array(

		// Begin a section.
		array(
			'name'   => 'lcp_shortcode_option_1',
			'title'  => __( 'General Settings', 'logo-carousel-pro' ),
			'icon'   => 'fa fa-wrench',

			// Begin fields.
			'fields' => array(

				// Begin a field.
				array(
					'id'      => 'lcp_layout',
					'type'    => 'select',
					'title'   => __( 'Layout', 'logo-carousel-pro' ),
					'desc'    => __( 'Select which layout you want to display', 'logo-carousel-pro' ),
					'options' => array(
						'carousel' => __( 'Carousel', 'logo-carousel-pro' ),
						'grid'     => __( 'Grid', 'logo-carousel-pro' ),
						'filter'   => __( 'Filter', 'logo-carousel-pro' ),
						'list'     => __( 'List', 'logo-carousel-pro' ),
						'inline'   => __( 'Inline', 'logo-carousel-pro' ),
					),
					'default' => 'carousel',
				),
				array(
					'id'         => 'lcp_filter_style',
					'type'       => 'button_set',
					'title'      => __( 'Filter Style', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the filter style.', 'logo-carousel-pro' ),
					'radio'   => true,
					'options'    => array(
						'normal' => __( 'Normal', 'logo-carousel-pro' ),
						'opacity'   => __( 'Opacity', 'logo-carousel-pro' ),
					),
					'default'    => 'normal',
					'attributes' => array(
						'data-depend-id' => 'lcp_filter_style',
					),
					'dependency' => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'         => 'lcp_layout_mode',
					'type'       => 'radio',
					'title'      => __( 'Layout Mode', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the layout mode.', 'logo-carousel-pro' ),
					'options'    => array(
						'masonry' => __( 'Masonry', 'logo-carousel-pro' ),
						'fitRows'    => __( 'Even', 'logo-carousel-pro' ),
					),
					'default'    => 'masonry',
					'dependency' => array( 'lcp_layout|lcp_filter_style', '==|==', 'filter|normal' ),
				),
				array(
					'id'         => 'lcp_logo_carousel_mode',
					'type'       => 'button_set',
					'title'      => __( 'Carousel Mode', 'logo-carousel-pro' ),
					'desc'       => __( 'Select a carousel mode.', 'logo-carousel-pro' ),
					'radio'   => true,
					'options'    => array(
						'standard' => __( 'Standard', 'logo-carousel-pro' ),
						'ticker'   => __( 'Ticker', 'logo-carousel-pro' ),
						'center'   => __( 'Center', 'logo-carousel-pro' ),
					),
					'attributes' => array(
						'data-depend-id' => 'lcp_logo_carousel_mode',
					),
					'default'    => 'standard',
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'type'       => 'notice',
					'class'      => 'info',
					'content'    => 'In the filter layout, the logos must have category.',
					'dependency' => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'         => 'lcp_list_style',
					'type'       => 'select',
					'title'      => __( 'List Style', 'logo-carousel-pro' ),
					'desc'       => __( 'Used as the style of list', 'logo-carousel-pro' ),
					'options'    => array(
						'left'   => __( 'Left', 'logo-carousel-pro' ),
						'center' => __( 'Center', 'logo-carousel-pro' ),
						'right'  => __( 'Right', 'logo-carousel-pro' ),
					),
					'default'    => 'left',
					'dependency' => array( 'lcp_layout', '==', 'list' ),
				),
				array(
					'id'      => 'lcp_display_logos_from',
					'type'    => 'select',
					'title'   => __( 'Display Logos from', 'logo-carousel-pro' ),
					'desc'    => __( 'Select an option to display the logos.', 'logo-carousel-pro' ),
					'options' => array(
						'latest'         => __( 'Latest', 'logo-carousel-pro' ),
						'category'       => __( 'Category', 'logo-carousel-pro' ),
						'specific_logos' => __( 'Specific Logos', 'logo-carousel-pro' ),
					),
					'default' => 'latest',
				),
				array(
					'id'         => 'lcp_logos_from_category',
					'type'       => 'select',
					'title'      => __( 'Choose Categories', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the categories to show the logos from', 'logo-carousel-pro' ),
					'options'    => 'categories',
					'query_args' => array(
						'type'     => 'sp_logo_carousel',
						'taxonomy' => 'sp_logo_carousel_cat',
					),
					'attributes' => array(
						'multiple'    => 'multiple',
						'placeholder' => __( 'Select Categories', 'logo-carousel-pro' ),
						'style'       => 'width: 280px;',
					),
					'class'      => 'chosen',
					'dependency' => array( 'lcp_display_logos_from', '==', 'category' ),
				),
				array(
					'id'         => 'lcp_category_operator',
					'type'       => 'select',
					'title'      => __( 'Operator', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the operator.', 'logo-carousel-pro' ),
					'options'    => array(
						'IN'     => __( 'IN - Show logos which associate with one or more terms', 'logo-carousel-pro' ),
						'AND'    => __( 'AND - Show logos which match all terms', 'logo-carousel-pro' ),
						'NOT IN' => __( 'NOT IN - Show logos which don\'t match the terms', 'logo-carousel-pro' ),
					),
					'default'    => 'IN',
					'dependency' => array(
						'lcp_display_logos_from',
						'==',
						'category',
					),
				),
				array(
					'id'         => 'lcp_specific_logos',
					'type'       => 'select',
					'title'      => __( 'Select Logos', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the logos to display.', 'logo-carousel-pro' ),
					'options'    => 'posts',
					'query_args' => array(
						'post_type'      => 'sp_logo_carousel',
						'post_status'    => 'publish',
						'posts_per_page' => -1,
					),
					'class'      => 'chosen',
					'attributes' => array(
						'multiple'    => 'multiple',
						'placeholder' => __( 'Choose Logos', 'logo-carousel-pro' ),
						'style'       => 'width: 280px;',
					),
					'dependency' => array(
						'lcp_display_logos_from',
						'==',
						'specific_logos',
					),
				),
				array(
					'id'      => 'lcp_number_of_total_items',
					'type'    => 'number',
					'title'   => __( 'Total Logos', 'logo-carousel-pro' ),
					'desc'    => __( 'Number of total logos to display.', 'logo-carousel-pro' ),
					'default' => '15',
					'attributes' => array(
						'min' => -1,
					),
				),
				array(
					'id'      => 'lcp_number_of_columns',
					'type'    => 'column',
					'title'   => __( 'Logo Columns', 'logo-carousel-pro' ),
					'desc'    => __( 'Set Logo column on devices.', 'logo-carousel-pro' ),
					'default' => array(
						'column1' => '5',
						'title1' => 'Large Desktop',
						'help1' => 'Set number of column(s) for the screen larger than 1280px.',
						'column2' => '4',
						'title2' => 'Desktop',
						'help2' => 'Set number of column on desktop for the screen smaller than 1280px.',
						'column3' => '3',
						'title3' => 'Small Desktop',
						'help3' => 'Set number of column on small desktop for the screen smaller than 980px.',
						'column4' => '2',
						'title4' => 'Tablet',
						'help4' => 'Set number of column on tablet for the screen smaller than 736px.',
						'column5' => '1',
						'title5' => 'Mobile',
						'help5' => 'Set number of column on mobile for the screen smaller than 480px.',
					),
					'column1' => true,
					'column2' => true,
					'column3' => true,
					'column4' => true,
					'column5' => true,
					'dependency' => array( 'lcp_logo_carousel_mode', '!=', 'ticker' ),
				),
				array(
					'id'      => 'lcp_number_of_columns_ticker',
					'type'    => 'column',
					'title'   => __( 'Logo Columns', 'logo-carousel-pro' ),
					'desc'    => __( 'Set Logo column number on ticker carousel.', 'logo-carousel-pro' ),
					'default' => array(
						'column1' => '5',
						'title1'  => 'Maximum',
						'help1'   => 'Used as the Number of Maximum Slides for the ticker carousel mode.',
						'column2' => '1',
						'title2'  => 'Minimum',
						'help2'   => 'Used as the Number of Minimum Slides for the ticker carousel mode.',
					),
					'column1' => true,
					'column2' => true,
					'dependency' => array( 'lcp_logo_carousel_mode', '==', 'ticker' ),
				),
				array(
					'id'      => 'lcp_logo_link_show',
					'type'    => 'switcher',
					'title'   => __( 'Logo Link', 'logo-carousel-pro' ),
					'desc'    => __( 'On/Off to enable or disable the logo link.', 'logo-carousel-pro' ),
					'default' => true,
				),
				array(
					'id'         => 'lcp_link_type',
					'type'       => 'radio',
					'title'      => __( 'Logo Detail Link Type', 'logo-carousel-pro' ),
					'desc'       => __( 'Set logo detail link type.', 'logo-carousel-pro' ),
					'options'    => array(
						'external_link' => __( 'External Link', 'logo-carousel-pro' ),
						'popup'   => __( 'Popup', 'logo-carousel-pro' )
					),
					'default'    => 'external_link',
					'attributes' => array(
						'data-depend-id' => 'lcp_link_type',
					),
					'dependency' => array( 'lcp_logo_link_show', '==', 'true' ),
				),
				array(
					'id'         => 'lcp_link_open_target',
					'type'       => 'select',
					'title'      => __( 'Link Target', 'logo-carousel-pro' ),
					'desc'       => __( 'Set logo link target.', 'logo-carousel-pro' ),
					'options'    => array(
						'_blank' => __( 'Open a new tab', 'logo-carousel-pro' ),
						'_top'   => __( 'Open in the same window', 'logo-carousel-pro' )
					),
					'default'    => '_blank',
					'dependency' => array( 'lcp_logo_link_show|lcp_link_type', '==|==', 'true|external_link' ),
				),
				array(
					'id'      => 'lcp_item_order_by',
					'type'    => 'select',
					'title'   => __( 'Order by', 'logo-carousel-pro' ),
					'desc'    => __( 'Set a order by option.', 'logo-carousel-pro' ),
					'options' => array(
						'menu_order' => __( 'Drag & Drop', 'logo-carousel-pro' ),
						'date'       => __( 'Date', 'logo-carousel-pro' ),
						'rand'       => __( 'Random', 'logo-carousel-pro' ),
						'title'      => __( 'Title', 'logo-carousel-pro' ),
					),
					'default' => 'menu_order',
				),
				array(
					'id'      => 'lcp_item_order',
					'type'    => 'select',
					'title'   => __( 'Order', 'logo-carousel-pro' ),
					'desc'    => __( 'Set logo order', 'logo-carousel-pro' ),
					'options' => array(
						'ASC'  => __( 'Ascending', 'logo-carousel-pro' ),
						'DESC' => __( 'Descending', 'logo-carousel-pro' ),
					),
					'default' => 'ASC',
				),

			), // end fields.
		), // end General section.


		// begin Carousel section.
		array(
			'name'   => 'lcp_shortcode_option_2',
			'title'  => __( 'Carousel Settings', 'logo-carousel-pro' ),
			'icon'   => 'fa fa-sliders',
			'fields' => array(
				array(
					'type'       => 'notice',
					'class'      => 'info',
					'content'    => __( 'To see the carousel setting fields, select Carousel layout.', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout', 'any', 'filter,grid,list,inline' ),
				),
				array(
					'id'         => 'lcp_logo_carousel_center_padding',
					'type'       => 'text',
					'title'      => __( 'Center Padding', 'logo-carousel-pro' ),
					'desc'       => __( 'Set center padding for the centered item e.g. 30%', 'logo-carousel-pro' ),
					'attributes' => array(
						'placeholder' => '50px',
					),
					'default'    => '60px',
					'after'      => __( 'px or %', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|==', 'carousel|center' ),
				),
				array(
					'id'         => 'lcp_logo_carousel_side_opacity',
					'type'       => 'slider',
					'title'      => __( 'Logo Opacity', 'logo-carousel-pro' ),
					'desc'       => __( 'Set opacity for the side logos.', 'logo-carousel-pro' ),
					'options'    => array(
						'step' => 0.01,
						'min'  => 0.01,
						'max'  => 1,
					),
					'default'    => 0.5,
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|==', 'carousel|center' ),
				),
				array(
					'id'         => 'lcp_vertical_horizontal',
					'type'       => 'button_set',
					'title'      => __( 'Carousel Direction', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose carousel direction', 'logo-carousel-pro' ),
					'radio'   => true,
					'options'    => array(
						'horizontal' => __( 'Horizontal', 'logo-carousel-pro' ),
						'vertical'   => __( 'Vertical', 'logo-carousel-pro' ),
					),
					'default'    => 'horizontal',
					'attributes' => array(
						'data-depend-id' => 'lcp_vertical_horizontal',
					),
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'id'         => 'lcp_carousel_auto_play',
					'type'       => 'switcher',
					'title'      => __( 'AutoPlay', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off auto play.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_carousel_auto_play_speed',
					'type'       => 'number',
					'title'      => __( 'AutoPlay Speed', 'logo-carousel-pro' ),
					'desc'       => __( 'Set auto play speed.', 'logo-carousel-pro' ),
					'after'      => __( '(millisecond)', 'logo-carousel-pro' ),
					'default'    => '3000',
					'dependency' => array(
						'lcp_carousel_auto_play|lcp_layout|lcp_logo_carousel_mode','==|==|any', 'true|carousel|standard,center'
					),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'         => 'lcp_max_width_of_slide',
					'type'       => 'number',
					'title'      => __( 'Maximum Width of slide', 'logo-carousel-pro' ),
					'desc'       => __( 'Set maximum width of each logo. Carousel width depends on it', 'logo-carousel-pro' ),
					'after'      => __( '(px)', 'logo-carousel-pro' ),
					'default'    => '180',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|==', 'carousel|ticker' ),
				),
				array(
					'id'         => 'lcp_carousel_scroll_speed',
					'type'       => 'number',
					'title'      => __( 'Carousel Speed', 'logo-carousel-pro' ),
					'desc'       => __( 'Set carousel scroll speed.', 'logo-carousel-pro' ),
					'after'      => __( '(millisecond)', 'logo-carousel-pro' ),
					'default'    => '600',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_carousel_scroll_speed_ticker',
					'type'       => 'number',
					'title'      => __( 'Carousel Speed', 'logo-carousel-pro' ),
					'desc'       => __( 'Set carousel scroll speed.', 'logo-carousel-pro' ),
					'after'      => __( '(millisecond)', 'logo-carousel-pro' ),
					'default'    => '10000',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|==', 'carousel|ticker' ),
				),
				array(
					'id'         => 'lcp_number_of_slides_to_scroll',
					'type'       => 'number',
					'title'      => __( 'Slide to Scroll', 'logo-carousel-pro' ),
					'desc'       => __( 'Number of logo(s) to scroll at a time.', 'logo-carousel-pro' ),
					'default'    => '1',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_number_of_slides_to_scroll_mobile',
					'type'       => 'number',
					'title'      => __( 'Slide to Scroll on Mobile', 'logo-carousel-pro' ),
					'desc'       => __( 'Number of logo(s) to scroll at a time on mobile view.', 'logo-carousel-pro' ),
					'default'    => '1',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_row',
					'type'       => 'number',
					'title'      => __( 'Row', 'logo-carousel-pro' ),
					'desc'       => __( 'Set number of row.', 'logo-carousel-pro' ),
					'default'    => '1',
					'attributes' => array(
						'min' => 1,
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard' ),
				),
				array(
					'id'         => 'lcp_carousel_pause_on_hover',
					'type'       => 'switcher',
					'title'      => __( 'Pause on Hover', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off pause on hover.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'id'         => 'lcp_carousel_adaptive_height',
					'type'       => 'switcher',
					'title'      => __( 'Adaptive Height', 'logo-carousel-pro' ),
					'desc'       => __( 'Off adaptive height to set fixed height for the carousel.', 'logo-carousel-pro' ),
					'default'    => false,
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_carousel_infinite',
					'type'       => 'switcher',
					'title'      => __( 'Infinite Loop', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off infinite looping for the carousel.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'id'         => 'lcp_section_title_heading',
					'type'       => 'subheading',
					'content'    => __( 'Navigation Settings', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_nav_show',
					'type'       => 'button_set',
					'title'      => __( 'Navigation', 'logo-carousel-pro' ),
					'desc'       => __( 'Show or hide pagination dots.', 'logo-carousel-pro' ),
					'radio'   => true,
					'options' => array(
						'show'            => __( 'Show', 'logo-carousel-pro' ),
						'hide'            => __( 'Hide', 'logo-carousel-pro' ),
						'hide_on_mobile'  => __( 'Hide on Mobile', 'logo-carousel-pro' ),
					),
					'default' => 'show',
					'attributes' => array(
						'data-depend-id' => 'lcp_nav_show',
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_nav_position',
					'type'       => 'select',
					'title'      => __( 'Navigation Position', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose a position of the navigation arrows.', 'logo-carousel-pro' ),
					'options'    => array(
						'top_right'                   => __( 'Top right', 'logo-carousel-pro' ),
						'top_center'                  => __( 'Top center', 'logo-carousel-pro' ),
						'top_left'                    => __( 'Top left', 'logo-carousel-pro' ),
						'bottom_left'                 => __( 'Bottom left', 'logo-carousel-pro' ),
						'bottom_center'               => __( 'Bottom center', 'logo-carousel-pro' ),
						'bottom_right'                => __( 'Bottom right', 'logo-carousel-pro' ),
						'vertical_center'             => __( 'Vertically center', 'logo-carousel-pro' ),
						'vertical_center_inner'       => __( 'Vertically center inner', 'logo-carousel-pro' ),
						'vertical_center_inner_hover' => __( 'Vertically center inner on hover', 'logo-carousel-pro' ),
					),
					'default'    => 'top_right',
					'dependency' => array(
						'lcp_nav_show|lcp_layout|lcp_logo_carousel_mode', '!=|==|any', 'hide|carousel|standard,center'
					),
				),

				array(
					'id'         => 'lcp_nav_type',
					'type'       => 'select',
					'title'      => __( 'Navigation Type', 'logo-carousel-pro' ),
					'desc'       => __( 'Select the carousel navigation type.', 'logo-carousel-pro' ),
					'options'    => array(
						'nav_arrow' => __( 'Arrow', 'logo-carousel-pro' ),
						'nav_text'  => __( 'Text', 'logo-carousel-pro' ),
					),
					'default'    => 'nav_arrow',
					'dependency' => array(
						'lcp_nav_show|lcp_layout|lcp_logo_carousel_mode',
						'!=|==|any',
						'hide|carousel|standard,center'
					),
				),
				array(
					'id'         => 'lcp_nav_arrow_type_horizontal',
					'type'       => 'image_select',
					'title'      => __( 'Navigation Arrow Icon', 'logo-carousel-pro' ),
					'desc'       => __( 'Select a nav arrow icon for the carousel.', 'logo-carousel-pro' ),
					'options'    => array(
						'angle_arrow_horizon'   => SP_URI . '/assets/images/angle-arrow.png',
						'chevron_arrow_horizon' => SP_URI . '/assets/images/chevron-arrow.png',
						'double_arrow_horizon'  => SP_URI . '/assets/images/double-arrow.png',
						'bold_arrow_horizon'    => SP_URI . '/assets/images/bold-arrow.png',
						'long_arrow_horizon'    => SP_URI . '/assets/images/long-arrow.png',
						'caret_arrow_horizon'   => SP_URI . '/assets/images/caret-arrow.png',
					),
					'default'    => 'angle_arrow_horizon',
					'radio'      => true,
					'dependency' => array(
						'lcp_nav_show|lcp_layout|lcp_nav_type|lcp_logo_carousel_mode',
						'!=|==|==|any',
						'hide|carousel|nav_arrow|standard,center'
					),
				),
				array(
					'id'         => 'lcp_nav_border_radius',
					'type'       => 'number',
					'title'      => __( 'Navigation Border Radius', 'logo-carousel-pro' ),
					'desc'       => __( 'Set navigation border radius in %.', 'logo-carousel-pro' ),
					'after'      => __( '%', 'logo-carousel-pro' ),
					'default'    => '0',
					'dependency' => array(
						'lcp_nav_show|lcp_layout|lcp_logo_carousel_mode',
						'!=|==|any',
						'hide|carousel|standard,center'
					),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'         => 'lcp_nav_color',
					'type'       => 'color_set',
					'title'      => __( 'Navigation Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Navigation color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'Color',
						'color1'  => '#afafaf',
						'title2'  => 'Hover Color',
						'color2'  => '#ffffff',
						'title3'  => 'Background',
						'color3'  => '#f0f0f0',
						'title4'  => 'Hover Background',
						'color4'  => '#16a08b',
						'title5'  => 'Border Color',
						'color5'  => '#f0f0f0',
						'title6'  => 'Border Hover Color',
						'color6'  => '#f0f0f0',
					),
					'color1'     => true,
					'color2'     => true,
					'color3'     => true,
					'color4'     => true,
					'color5'     => true,
					'color6'     => true,
					'dependency' => array(
						'lcp_nav_show|lcp_layout|lcp_logo_carousel_mode',
						'!=|==|any',
						'hide|carousel|standard,center'
					),
				),
				array(
					'id'         => 'lcp_section_pagination_settings',
					'type'       => 'subheading',
					'content'    => __( 'Pagination Settings', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_carousel_dots',
					'type'       => 'button_set',
					'title'      => __( 'Dots', 'logo-carousel-pro' ),
					'desc'       => __( 'Show or hide pagination dots.', 'logo-carousel-pro' ),
					'radio'   => true,
					'options' => array(
						'show'            => __( 'Show', 'logo-carousel-pro' ),
						'hide'            => __( 'Hide', 'logo-carousel-pro' ),
						'hide_on_mobile'  => __( 'Hide on Mobile', 'logo-carousel-pro' ),
					),
					'default' => 'show',
					'attributes' => array(
						'data-depend-id' => 'lcp_carousel_dots',
					),
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|any', 'carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_carousel_dots_color',
					'type'       => 'color_set',
					'title'      => __( 'Dots Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Set pagination dots color.', 'logo-carousel-pro' ),
					'default'    => array(
						'color1'  => '#dddddd',
						'title1'  => 'Color',
						'color2'  => '#16a08b',
						'title2'  => 'Active Color',
					),
					'color1'   => true,
					'color2'   => true,
					'dependency' => array( 'lcp_carousel_dots|lcp_layout|lcp_logo_carousel_mode', '!=|==|any', 'hide|carousel|standard,center' ),
				),
				array(
					'id'         => 'lcp_section_carousel_misc',
					'type'       => 'subheading',
					'content'    => __( 'Misc. Settings', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'id'         => 'lcp_logo_lazy_load',
					'type'       => 'switcher',
					'title'      => __( 'Lazy Load', 'logo-carousel-pro' ),
					'desc'       => __( 'Activate lazy load for logos.', 'logo-carousel-pro' ),
					'default'    => false,
					'dependency' => array( 'lcp_layout|lcp_logo_carousel_mode', '==|!=', 'carousel|ticker'),
				),
				array(
					'id'         => 'lcp_carousel_swipe',
					'type'       => 'switcher',
					'title'      => __( 'Touch Swipe', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off touch swipe mode.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'id'         => 'lcp_carousel_draggable',
					'type'       => 'switcher',
					'title'      => __( 'Mouse Draggable', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off mouse draggable mode.', 'logo-carousel-pro' ),
					'after'      => __( 'Dependent on touch swipe.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_layout|lcp_carousel_swipe', '==|==', 'carousel|true' ),
				),
				array(
					'id'         => 'lcp_rtl_mode',
					'type'       => 'switcher',
					'title'      => __( 'RTL', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off RTL(Right to Left) mode.', 'logo-carousel-pro' ),
					'default'    => false,
					'dependency' => array( 'lcp_layout', '==', 'carousel' ),
				),
				array(
					'type'       => 'notice',
					'class'      => 'danger',
					'content'    => __( 'To make the RTL Mode work, please select a rtl language in the dashboard e.g. Arabic, Hebrew.', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_rtl_mode', '==', 'true' ),
				),

			), // End Fields.
		), // end a section.

		// Begin Style Settings section.
		array(
			'name'   => 'lcp_shortcode_option_3',
			'title'  => __( 'Style Settings', 'logo-carousel-pro' ),
			'icon'   => 'fa fa-paint-brush',
			'fields' => array(

				array(
					'id'      => 'lcp_section_title',
					'type'    => 'switcher',
					'title'   => __( 'Section Title', 'logo-carousel-pro' ),
					'desc'    => __( 'Display logo section title.', 'logo-carousel-pro' ),
					'default' => false,
				),
				array(
					'id'         => 'lcp_section_title_margin',
					'type'       => 'number',
					'title'      => __( 'Section Title Margin Bottom', 'logo-carousel-pro' ),
					'desc'       => __( 'Set margin bottom for the section title.', 'logo-carousel-pro' ),
					'default'    => '45',
					'after'      => 'px',
					'dependency' => array( 'lcp_section_title', '==', 'true' ),
				),
				array(
					'id'         => 'lcp_section_filter_cat',
					'type'       => 'subheading',
					'content'    => __( 'Filter Category', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'         => 'lcp_filter_cat_color',
					'type'       => 'color_set',
					'title'      => __( 'Filter Category Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Set filter category color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'Color',
						'color1'  => '#444444',
						'title2'  => 'Hover Color',
						'color2'  => '#ffffff',
						'title3'  => 'Background',
						'color3'  => '#e2e2e2',
						'title4'  => 'Hover Background',
						'color4'  => '#16a08b',
					),
					'color1'  => true,
					'color2'  => true,
					'color3'  => true,
					'color4'  => true,
					'dependency' => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'      => 'lcp_logo_margin',
					'type'    => 'number',
					'title'   => __( 'Margin', 'logo-carousel-pro' ),
					'desc'    => __( 'Set margin between the logos.', 'logo-carousel-pro' ),
					'after'   => __( '(px)', 'logo-carousel-pro' ),
					'default' => '8',
					'dependency' => array( 'lcp_layout', '!=', 'inline' ),
				),
				array(
					'id'      => 'lcp_logo_inner_padding',
					'type'    => 'number',
					'title'   => __( 'Inner padding', 'logo-carousel-pro' ),
					'after'   => __( '(px)', 'logo-carousel-pro' ),
					'desc'    => __( 'Padding between border and logo image.', 'logo-carousel-pro' ),
					'default' => '0',
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'      => 'lcp_section_logo_title',
					'type'    => 'subheading',
					'content' => __( 'Title', 'logo-carousel-pro' ),
				),
				array(
					'id'      => 'lcp_logo_title',
					'type'    => 'switcher',
					'title'   => __( 'Logo Title', 'logo-carousel-pro' ),
					'desc'    => __( 'On/Off to show or hide the title.', 'logo-carousel-pro' ),
					'default' => false,
				),
				array(
					'id'         => 'lcp_logo_title_position',
					'type'       => 'select',
					'title'      => __( 'Title Position', 'logo-carousel-pro' ),
					'desc'       => __( 'Select the title position.', 'logo-carousel-pro' ),
					'options'    => array(
						'top'          => __( 'Top', 'logo-carousel-pro' ),
						'bottom'       => __( 'Bottom', 'logo-carousel-pro' ),
						'middle'       => __( 'Middle', 'logo-carousel-pro' ),
						'hover_full'   => __( 'Title on Hover (Full)', 'logo-carousel-pro' ),
						'hover_bottom' => __( 'Title on Hover (Lower)', 'logo-carousel-pro' ),
					),
					'default'    => 'bottom',
					'dependency' => array( 'lcp_logo_title|lcp_layout', '==|any', 'true|carousel,grid,filter,inline' ),
				),
				array(
					'id'         => 'lcp_logo_title_hover_bg',
					'type'       => 'color_picker',
					'title'      => __( 'Title Hover Background', 'logo-carousel-pro' ),
					'desc'       => __( 'Used as the title background color.', 'logo-carousel-pro' ),
					'default'    => '#16a08b',
					'dependency' => array(
						'lcp_logo_title|lcp_logo_title_position', '==|any', 'true|hover_full,hover_bottom'
					),
				),
				array(
					'id'      => 'lcp_section_logo_description',
					'type'    => 'subheading',
					'content' => __( 'Description', 'logo-carousel-pro' ),
				),
				array(
					'id'      => 'lcp_logo_description',
					'type'    => 'switcher',
					'title'   => __( 'Description Show/Hide', 'logo-carousel-pro' ),
					'desc'    => __( 'On/Off to show or hide the logo description.', 'logo-carousel-pro' ),
					'default' => false,
				),
				array(
					'id'         => 'lcp_logo_description_position',
					'type'       => 'select',
					'title'      => __( 'Description Position', 'logo-carousel-pro' ),
					'desc'       => __( 'Set logo description position.', 'logo-carousel-pro' ),
					'options'    => array(
						'bottom' => __( 'Bottom', 'logo-carousel-pro' ),
						'middle' => __( 'Middle', 'logo-carousel-pro' ),
					),
					'default'    => 'bottom',
					'dependency' => array( 'lcp_logo_description|lcp_layout', '==|!=', 'true|list' ),
				),
				array(
					'id'         => 'lcp_description_type',
					'type'       => 'button_set',
					'title'      => __( 'Description Type', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose the description type.', 'logo-carousel-pro' ),
					'radio'   => true,
					'options'     => array(
						'description'  => __( 'Description', 'logo-carousel-pro' ),
						'description_limit' => __( 'Description with Limit', 'logo-carousel-pro' ),
					),
					'attributes' => array(
						'data-depend-id' => 'lcp_description_type',
					),
					'default'    => 'description',
					'dependency' => array( 'lcp_logo_description', '==', 'true' ),
				),
				array(
					'id'         => 'lcp_description_words_limit',
					'type'       => 'number',
					'title'      => __( 'Description Words Limit', 'logo-carousel-pro' ),
					'desc'       => __( 'Set description words limit.', 'logo-carousel-pro' ),
					'default'    => 30,
					'dependency' => array( 'lcp_logo_description|lcp_description_type', '==|==', 'true|description_limit' ),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'         => 'lcp_description_read_more',
					'type'       => 'switcher',
					'title'      => __( 'Description Read More', 'logo-carousel-pro' ),
					'desc'       => __( 'Show/Hide description read more button.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_logo_description|lcp_description_type|lcp_logo_link_show', '==|==|==', 'true|description_limit|true' ),
				),
				array(
					'id'         => 'lcp_description_read_more_text',
					'type'       => 'text',
					'title'      => __( 'Read More Text', 'logo-carousel-pro' ),
					'desc'       => __( 'Set description read more button text.', 'logo-carousel-pro' ),
					'default'    => 'Learn More',
					'dependency' => array( 'lcp_logo_description|lcp_description_type|lcp_description_read_more|lcp_logo_link_show', '==|==|==|==', 'true|description_limit|true|true' ),
				),
				array(
					'id'         => 'lcp_read_more_color',
					'type'       => 'color_set',
					'title'      => __( 'Description Read More Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Description read more button color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'Color',
						'color1'  => '#05b3c6',
						'title2'  => 'Hover Color',
						'color2'  => '#ffffff',
						'title3'  => 'Background',
						'color3'  => 'transparent',
						'title4'  => 'Hover Background',
						'color4'  => '#05b3c6',
						'title5'  => 'Border Color',
						'color5'  => '#05b3c6',
						'title6'  => 'Border Hover Color',
						'color6'  => '#05b3c6',
					),
					'color1'     => true,
					'color2'     => true,
					'color3'     => true,
					'color4'     => true,
					'color5'     => true,
					'color6'     => true,
					'dependency' => array( 'lcp_logo_description|lcp_description_type|lcp_description_read_more|lcp_logo_link_show', '==|==|==|==', 'true|description_limit|true|true' ),
				),

				array(
					'id'      => 'lcp_section_logo_tooltip',
					'type'    => 'subheading',
					'content' => __( 'Tooltip', 'logo-carousel-pro' ),
				),
				array(
					'id'      => 'lcp_logo_tooltip',
					'type'    => 'switcher',
					'title'   => __( 'Tooltip', 'logo-carousel-pro' ),
					'desc'    => __( 'On/Off logo tooltip.', 'logo-carousel-pro' ),
					'default' => true,
				),
				array(
					'id'         => 'lcp_logo_tooltip_position',
					'type'       => 'select',
					'title'      => __( 'Tooltip Position', 'logo-carousel-pro' ),
					'desc'       => __( 'Select the tooltip position.', 'logo-carousel-pro' ),
					'options'    => array(
						'top'    => __( 'Top', 'logo-carousel-pro' ),
						'bottom' => __( 'Bottom', 'logo-carousel-pro' ),
						'left'   => __( 'Left', 'logo-carousel-pro' ),
						'right'  => __( 'Right', 'logo-carousel-pro' ),
					),
					'default'    => '#000',
					'dependency' => array( 'lcp_logo_tooltip', '==', 'true' ),
				),
				array(
					'id'         => 'lcp_logo_tooltip_width',
					'type'       => 'number',
					'title'      => __( 'Tooltip Width', 'logo-carousel-pro' ),
					'desc'       => __( 'Maximum width of the tooltip.', 'logo-carousel-pro' ),
					'default'    => '220',
					'after'    => '(px)',
					'dependency' => array( 'lcp_logo_tooltip', '==', 'true' ),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'         => 'lcp_logo_tooltip_effect',
					'type'       => 'select',
					'title'      => __( 'Tooltip Effect', 'logo-carousel-pro' ),
					'desc'       => __( 'Choose a effect for the tooltip.', 'logo-carousel-pro' ),
					'options'    => array(
						'grow'  => __( 'Grow', 'logo-carousel-pro' ),
						'fade'  => __( 'Fade', 'logo-carousel-pro' ),
						'swing' => __( 'Swing', 'logo-carousel-pro' ),
						'slide' => __( 'Slide', 'logo-carousel-pro' ),
						'fall'  => __( 'Fall', 'logo-carousel-pro' ),
					),
					'default'    => 'grow',
					'dependency' => array( 'lcp_logo_tooltip', '==', 'true' ),
				),
				array(
					'id'         => 'lcp_logo_tooltip_color',
					'type'       => 'color_set',
					'title'      => __( 'Tooltip Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Set tooltip color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1' => 'Color',
						'color1' => '#ffffff',
						'title2' => 'Background',
						'color2' => '#000000',
					),
					'color1'	=> true,
					'color2'	=> true,
					'dependency' => array( 'lcp_logo_tooltip', '==', 'true' ),
				),
				array(
					'id'      => 'lcp_section_logo_border',
					'type'    => 'subheading',
					'content' => __( 'Background, Border and BoxShadow', 'logo-carousel-pro' ),
				),
				array(
					'id'         => 'lcp_logo_color',
					'type'       => 'color_set',
					'title'      => __( 'Logo Background Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Set the logo background color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'Background',
						'color1'  => 'transparent',
						'title2'  => 'Hover Background',
						'color2'  => 'transparent',
					),
					'color1'  => true,
					'color2'  => true,
				),
				array(
					'id'         => 'lcp_logo_border',
					'type'       => 'border',
					'title'      => __( 'Logo Border', 'logo-carousel-pro' ),
					'desc'       => __( 'Set border for logo image.', 'logo-carousel-pro' ),
					'default'    => array(
						'width'        => '1',
						'style'        => 'solid',
						'color'        => '#dddddd',
						'hover_color'  => '#dddddd',
					),
					'hover_color'  => true,
				),
				array(
					'id'      => 'lcp_logo_outer_border',
					'type'    => 'switcher',
					'title'   => __( 'Outer Border', 'logo-carousel-pro' ),
					'desc'    => __( 'Show/Hide logo outer border.', 'logo-carousel-pro' ),
					'default' => true,
					'dependency' => array( 'lcp_layout', '==', 'inline' ),
				),
				array(
					'id'      => 'lcp_border_radius',
					'type'    => 'text',
					'title'   => __( 'Border Radius', 'logo-carousel-pro' ),
					'desc'    => __( 'Type logo border radius in pixel or percentage e.g. 50%.', 'logo-carousel-pro' ),
					'after'   => __( 'px or %', 'logo-carousel-pro' ),
					'class'   => 'lcp-border-radius',
					'default' => '0px',
					'dependency' => array( 'lcp_layout', '!=', 'inline' ),
				),
				array(
					'id'      => 'lcp_logo_shadow_type',
					'type'    => 'select',
					'title'   => __( 'BoxShadow', 'logo-carousel-pro' ),
					'desc'    => __( 'Enable or disable logo boxshadow.', 'logo-carousel-pro' ),
					'options' => array(
						'off'           => __( 'Off', 'logo-carousel-pro' ),
						'shadow_inset'  => __( 'Inset', 'logo-carousel-pro' ),
						'shadow_outset' => __( 'Outset', 'logo-carousel-pro' ),
					),
					'default' => 'off',
				),
				array(
					'id'         => 'lcp_logo_shadow_color',
					'type'       => 'color_set',
					'title'      => __( 'BoxShadow Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Set boxshadow color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'BoxShadow Color',
						'color1'  => '#dddddd',
						'title2'  => 'BoxShadow Hover Color',
						'color2'  => '#cccccc',
					),
					'color1'  => true,
					'color2'  => true,
					'dependency' => array( 'lcp_logo_shadow_type', 'any', 'shadow_inset,shadow_outset' ),
				),
				array(
					'id'         => 'lcp_section_pagination_style',
					'type'       => 'subheading',
					'content'    => __( 'Pagination Stylization', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_layout', 'any', 'list,inline,grid' ),
				),
				array(
					'id'         => 'lcp_pagination_margin',
					'type'       => 'margin',
					'title'      => __( 'Pagination Margin', 'logo-carousel-pro' ),
					'desc'       => __( 'Set pagination margin.', 'logo-carousel-pro' ),
					'default'    => array(
						'top'  => '20',
						'bottom'  => '0',
					),
					'top'  => true,
					'bottom'  => true,
					'dependency' => array( 'lcp_layout', 'any', 'list,inline,grid' ),
				),
				array(
					'id'         => 'lcp_pagination_color',
					'type'       => 'color_set',
					'title'      => __( 'Pagination Color', 'logo-carousel-pro' ),
					'desc'       => __( 'Used as the pagination color.', 'logo-carousel-pro' ),
					'default'    => array(
						'title1'  => 'Text Color',
						'color1'  => '#afafaf',
						'title2'  => 'Text Hover Color',
						'color2'  => '#ffffff',
						'title3'  => 'Background',
						'color3'  => '#f0f0f0',
						'title4'  => 'Hover Background',
						'color4'  => '#16a08b',
					),
					'color1'  => true,
					'color2'  => true,
					'color3'  => true,
					'color4'  => true,
					'dependency' => array( 'lcp_layout', 'any', 'list,inline,grid' ),
				),
				array(
					'id'      => 'lcp_section_logo_effects',
					'type'    => 'subheading',
					'content' => __( 'Logo Effect on Hover', 'logo-carousel-pro' ),
				),
				array(
					'id'         => 'lcp_logo_zoom_effect_types',
					'type'       => 'select',
					'title'      => __( 'Zoom', 'logo-carousel-pro' ),
					'desc'       => __( 'Enable or disable zoom effect for the logo.', 'logo-carousel-pro' ),
					'options'    => array(
						'off'      => __( 'Off', 'logo-carousel-pro' ),
						'zoom_in'  => __( 'Zoom In', 'logo-carousel-pro' ),
						'zoom_out' => __( 'Zoom Out', 'logo-carousel-pro' ),
					),
					'default'    => 'off',
					'dependency' => array( 'lcp_logo_carousel_mode', 'any', 'standard,ticker' ),
				),
				array(
					'id'      => 'lcp_logo_blur_effect',
					'type'    => 'switcher',
					'title'   => __( 'Blur', 'logo-carousel-pro' ),
					'desc'    => __( 'On/Off image blur effect.', 'logo-carousel-pro' ),
					'default' => false,
				),
				array(
					'id'         => 'lcp_logo_opacity',
					'type'       => 'slider',
					'title'      => __( 'Opacity', 'logo-carousel-pro' ),
					'desc'       => __( 'Set opacity for the logos.', 'logo-carousel-pro' ),
					'options'    => array(
						'step' => 0.01,
						'min'  => 0.01,
						'max'  => 1,
					),
					'default'    => 1,
				),
				array(
					'id'      => 'lcp_logo_gray_scale',
					'type'    => 'select',
					'title'   => __( 'GrayScale', 'logo-carousel-pro' ),
					'desc'    => __( 'Grayscale effect works on all modern browsers.', 'logo-carousel-pro' ),
					'options' => array(
						'off'              => __( 'Off', 'logo-carousel-pro' ),
						'gray_with_normal' => __( 'Gray with normal on hover', 'logo-carousel-pro' ),
						'gray_on_hover'    => __( 'Gray on hover', 'logo-carousel-pro' ),
						'always_gray'      => __( 'Always Gray', 'logo-carousel-pro' ),
					),
					'default' => 'off',
				),
				array(
					'id'         => 'lcp_mobile_tablet_gray_off',
					'type'       => 'switcher',
					'title'      => __( 'GrayScale on Tablet & Mobile', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off grayscale effect on table and mobile screen. Screen smaller than 736px.', 'logo-carousel-pro' ),
					'default'    => false,
					'dependency' => array( 'lcp_logo_gray_scale', '==', 'gray_with_normal' ),
				),
				array(
					'id'      => 'lcp_section_logo_image_setting',
					'type'    => 'subheading',
					'content' => __( 'Logo Image Settings', 'logo-carousel-pro' ),
				),
				array(
					'id'    => 'lcp_image_width',
					'type'  => 'number',
					'title' => __( 'Width', 'logo-carousel-pro' ),
					'desc'  => __( 'Maximum width of the logo image.', 'logo-carousel-pro' ),
					'after' => __( '(px)', 'logo-carousel-pro' ),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'    => 'lcp_image_height',
					'type'  => 'number',
					'title' => __( 'Height', 'logo-carousel-pro' ),
					'desc'  => __( 'Maximum height of the logo image.', 'logo-carousel-pro' ),
					'after' => __( '(px)', 'logo-carousel-pro' ),
					'attributes' => array(
						'min' => 0,
					),
				),
				array(
					'id'      => 'lcp_image_crop',
					'type'    => 'switcher',
					'title'   => __( 'Crop', 'logo-carousel-pro' ),
					'desc'    => __( 'Hard cropping all the images equally.', 'logo-carousel-pro' ),
					'default' => false,
				),
				array(
					'id'      => 'lcp_grid_inline_vertical_alignment',
					'type'    => 'select',
					'title'   => __( 'Vertical Alignment', 'logo-carousel-pro' ),
					'desc'    => __( 'Select vertical alignment type.', 'logo-carousel-pro' ),
					'options' => array(
						'middle' => __( 'Middle', 'logo-carousel-pro' ),
						'bottom' => __( 'Bottom', 'logo-carousel-pro' ),
						'top'    => __( 'Top', 'logo-carousel-pro' ),
					),
					'default' => 'middle',
				),
				array(
					'type'       => 'notice',
					'class'      => 'info',
					'content'    => __( 'Upload the images equal or larger than your desired crop size.', 'logo-carousel-pro' ),
					'dependency' => array( 'lcp_image_crop', '==', true ),
				),


			), // End Fields.
		),
		// begin: Typography section.
		array(
			'name'   => 'lcp_shortcode_option_4',
			'title'  => __( 'Typography', 'logo-carousel-pro' ),
			'icon'   => 'fa fa-font',
			'fields' => array(// end: a section

				array(
					'id'         => 'lcp_section_title_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Section Title Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the section title.', 'logo-carousel-pro' ),
					'default'    => true,
				),
				array(
					'id'           => 'lcp_section_title_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Section Title Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set section title font properties.', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '24',
						'height'    => '32',
						'alignment' => 'left',
						'transform' => 'none',
						'spacing'   => 'normal',
						'color'     => '#222',
					),
					'color'        => true, // Enable or disable preview box.
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'The Section Title', // Replace preview text with any text you like.
				),
				array(
					'id'         => 'lcp_filter_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Filter Category Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the filter category.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency'    => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'           => 'lcp_filter_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Filter Category Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set filter category font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => '500',
						'font'      => 'google',
						'size'      => '14',
						'height'    => '20',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
					),
					'preview'       => true, // Enable or disable preview box.
					'preview_text'  => 'Category', // Replace preview text with any text you like.
					'dependency'    => array( 'lcp_layout', '==', 'filter' ),
				),
				array(
					'id'         => 'lcp_logo_title_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Logo Title Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the logo title.', 'logo-carousel-pro' ),
					'default'    => true,
				),
				array(
					'id'           => 'lcp_logo_title_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Logo Title Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set logo title font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '14',
						'height'    => '21',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
						'color'     => '#2f2f2f',
					),
					'color'        => true, // Enable or disable preview box.
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'The Logo Title', // Replace preview text with any text you like.
				),
				array(
					'id'         => 'lcp_logo_description_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Logo Body/Description Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the logo body/description.', 'logo-carousel-pro' ),
					'default'    => true,
				),
				array(
					'id'           => 'lcp_logo_description_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Logo Body/Description Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set logo description font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '14',
						'height'    => '21',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
						'color'     => '#555',
					),
					'color'        => true, // Enable or disable color field.
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
					//Replace preview text with any text you like.
				),
				array(
					'id'         => 'lcp_read_more_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Read More Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the read more.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_description_type|lcp_description_read_more|lcp_logo_description', '==|==|==', 'description_limit|true|true' ),
				),
				array(
					'id'           => 'lcp_read_more_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Read More Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set description read more font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '14',
						'height'    => '20',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
					),
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'Learn More', // Replace preview text with any text you like.
					'dependency' => array( 'lcp_description_type|lcp_description_read_more|lcp_logo_description', '==|==|==', 'description_limit|true|true' ),
				),
				array(
					'id'         => 'lcp_logo_popup_title_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Popup Title Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the popup title.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_description_type|lcp_logo_description', '==|==', 'description_limit|true' ),
				),
				array(
					'id'           => 'lcp_logo_popup_title_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Popup Title Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set logo popup title font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '22',
						'height'    => '24',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
						'color'     => '#2f2f2f',
					),
					'color'        => true, // Enable or disable preview box.
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'The Logo Title', // Replace preview text with any text you like.
					'dependency' => array( 'lcp_description_type|lcp_logo_description', '==|==', 'description_limit|true' ),
				),
				array(
					'id'         => 'lcp_logo_popup_description_font_load',
					'type'       => 'switcher',
					'title'      => __( 'Load Popup Description Font', 'logo-carousel-pro' ),
					'desc'       => __( 'On/Off google font for the logo popup description.', 'logo-carousel-pro' ),
					'default'    => true,
					'dependency' => array( 'lcp_description_type|lcp_logo_description', '==|==', 'description_limit|true' ),
				),
				array(
					'id'           => 'lcp_logo_popup_description_typography',
					'type'         => 'typography_advanced',
					'title'        => __( 'Popup Description Font', 'logo-carousel-pro' ),
					'desc'         => __( 'Set logo popup description font properties', 'logo-carousel-pro' ),
					'default'      => array(
						'family'    => 'Ubuntu',
						'variant'   => 'regular',
						'font'      => 'google',
						'size'      => '14',
						'height'    => '23',
						'alignment' => 'center',
						'transform' => 'none',
						'spacing'   => 'normal',
						'color'     => '#555',
					),
					'color'        => true, // Enable or disable color field.
					'preview'      => true, // Enable or disable preview box.
					'preview_text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
					//Replace preview text with any text you like.
					'dependency' => array( 'lcp_description_type|lcp_logo_description', '==|==', 'description_limit|true' ),
				),
			),
		), // End: Section.

	),
);

// -----------------------------------------
// Logo Link Metabox Options               -
// -----------------------------------------
$options[] = array(
	'id'        => 'sp_lcp_logo_link_option',
	'title'     => __( 'Logo Link URL', 'logo-carousel-pro' ),
	'post_type' => 'sp_logo_carousel',
	'context'   => 'normal',
	'priority'  => 'default',
	'sections'  => array(

		array(
			'name'   => 'lcp_logo_link_section',
			'fields' => array(

				array(
					'id'         => 'lcp_logo_link',
					'wrap_class' => 'lcp-logo-link-field',
					'type'       => 'link',
					'title'      => __( 'Custom URL', 'logo-carousel-pro' ),
					'desc'       => __( 'Type logo link url.', 'logo-carousel-pro' ),
					'attributes' => array(
						'placeholder' => 'http://example.com',
					),
				),

			),
		),

	),
);

SP_LCPRO_Framework_Metabox::instance( $options );
