jQuery(document).ready(function ($) {
    // ----------------------------------------------
    //  Isotope Filter
    // ----------------------------------------------
    $('.sp-logo-carousel-pro-area.lcp-filter-normal').each(function (index) {

        var filter_id = $(this).attr('id');
        var splcp_conf = $.parseJSON($(this).closest('.sp-logo-carousel-pro-section').find('.sp-lcp-conf').text());

        var winDow = $(window);
        var $container = $('#' + filter_id + ' .sp-isotope-logo-items');
        var $filter = $('#' + filter_id + ' .sp-logo-filter');
        try {
            $container.imagesLoaded(function () {
                $container.show();
                $container.isotope({
                    filter: '*',
                    layoutMode: splcp_conf.layout_mode,
                    animationOptions: {
                        duration: 750,
                        easing: 'linear'
                    }
                });
            });
        } catch (err) {
        }

        winDow.bind('resize', function () {
            var selector = $filter.find('button.active').attr('data-filter');

            try {
                $container.isotope({
                    filter: selector,
                    animationOptions: {
                        duration: 750,
                        easing: 'linear',
                        queue: false,
                    }
                });
            } catch (err) {
            }
            return false;
        });

        $filter.find('button').click(function () {
            var selector = $(this).attr('data-filter');
            try {
                $container.isotope({
                    filter: selector,
                    animationOptions: {
                        duration: 750,
                        easing: 'linear',
                        queue: false
                    }
                });
            } catch (err) {

            }
            return false;
        });

        var filterItemA = $('#' + filter_id + ' .sp-logo-filter button');
        filterItemA.on('click', function () {
            var $this = $(this);
            if (!$this.hasClass('active')) {
                filterItemA.removeClass('active');
                $this.addClass('active');
            }
        });

    });
});
