<?php
/**
 * LSVR Pressville Galleries Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Pressville_Galleries' ) ) {
    class Lsvr_Shortcode_Pressville_Galleries {

        public static function shortcode( $atts = array(), $content = null, $tag ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'id' => '',
                    'title' => '',
                    'subtitle' => '',
                    'icon' => '',
                    'category' => 0,
                    'layout' => 'title-top',
                    'limit' => 8,
                    'columns_count' => 4,
                    'enable_dark_bg' => '',
                    'enable_slider' => '',
                    'more_label' => '',
                ),
                $atts
            );

            // Prepare grid and cols classes
            $grid_class = 'lsvr-grid lsvr-grid--' . $args['columns_count'] . '-cols';
            $grid_class .= (int) $args['columns_count'] > 1 ? ' lsvr-grid--md-2-cols lsvr-grid--sm-2-cols' : '';
            $col_class = 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( 12 / (int) $args['columns_count'] );
            $col_class .= (int) $args['columns_count'] > 1 ? ' lsvr-grid__col--md-span-6 lsvr-grid__col--sm-span-6' : '';

            // Check if dark BG
            $enable_dark_bg = '1' === $args['enable_dark_bg'] || 'true' === $args['enable_dark_bg'] ? true : false;

            // Check if is slider
            $enable_slider = '1' === $args['enable_slider'] || 'true' === $args['enable_slider'] ? true : false;

            // Determine thumb size
            $thumb_size = (int) $args['columns_count'] < 4 ? 'large' : 'medium';

            // Element class
            $class_arr = array( 'lsvr-pressville-post-grid' );
            array_push( $class_arr, 'lsvr-pressville-post-grid--layout-' . $args['layout'] );
            if ( true === $enable_slider ) {
                array_push( $class_arr, 'lsvr-pressville-post-grid--has-slider' );
            }
            if ( true === $enable_dark_bg ) {
                array_push( $class_arr, 'lsvr-pressville-post-grid--dark-bg' );
            } else {
                array_push( $class_arr, 'lsvr-pressville-post-grid--no-bg' );
            }

            // Prepare query
            $limit = 0 === (int) $args['limit'] ? 1000 : (int) $args['limit'];
            $query_args = array(
                'posts_per_page' => $limit,
                'post_type' => 'lsvr_gallery',
            );

            // Get category
            if ( ! empty( $args['category'] ) && is_numeric( $args['category'] ) && (int) $args['category'] > 0 ) {
                $category_id = (int) $args['category'];
            } else if ( ! empty( $args['category'] ) ) {
                $category_id = get_term_by( 'slug', $args['category'], 'lsvr_gallery_cat', ARRAY_A );
                $category_id = ! empty( $category_id['term_taxonomy_id'] ) ? $category_id['term_taxonomy_id'] : false;
            } else {
                $category_id = false;
            }

            // Set category
            if ( ! empty( $category_id ) ) {
                $query_args['tax_query'] = array(
                    array(
                        'taxonomy' => 'lsvr_gallery_cat',
                        'field' => 'ID',
                        'terms' => array( $category_id ),
                        'operator' => 'IN',
                    ),
                );
            }

            // Get posts
            $posts = get_posts( $query_args );

            ob_start(); ?>

            <section class="<?php echo esc_attr( implode( ' ', $class_arr ) ); ?>"
                <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-pressville-post-grid__inner">
                    <div class="lsvr-container">
                        <div class="lsvr-pressville-post-grid__content">

                            <?php if ( ! empty( $args['title'] ) || ! empty( $args['subtitle'] ) ) : ?>
                                <header class="lsvr-pressville-post-grid__header">

                                    <?php if ( ! empty( $args['title'] ) ) : ?>
                                        <h2 class="lsvr-pressville-post-grid__title"><?php echo esc_html( $args['title'] ); ?></h2>
                                    <?php endif; ?>

                                    <?php if ( ! empty( $args['subtitle'] ) ) : ?>
                                        <p class="lsvr-pressville-post-grid__subtitle"><?php echo esc_html( $args['subtitle'] ); ?></p>
                                    <?php endif; ?>

                                    <?php if ( ! empty( $args[ 'more_label' ] ) && 'title-left' === $args['layout'] ) : ?>
                                        <p class="lsvr-pressville-post-grid__more lsvr-pressville-post-grid__more--top">
                                            <?php if ( ! empty( $category_id ) ) : ?>
                                                <a href="<?php echo esc_url( get_term_link( $category_id, 'lsvr_gallery_cat' ) ); ?>" class="c-button lsvr-pressville-post-grid__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>
                                            <?php else : ?>
                                                <a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_gallery' ) ); ?>" class="c-button lsvr-pressville-post-grid__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>
                                            <?php endif; ?>
                                        </p>
                                    <?php endif; ?>

                                    <?php if ( ! empty( $args['icon'] ) ) : ?>
                                        <i class="<?php echo esc_attr( $args['icon'] ); ?> lsvr-pressville-post-grid__icon"></i>
                                    <?php endif; ?>

                                </header>
                            <?php endif; ?>

                            <?php if ( ! empty( $posts ) ) : ?>

                                <div class="lsvr-pressville-post-grid__list-wrapper">
                                    <div class="<?php echo esc_attr( $grid_class ); ?> lsvr-pressville-post-grid__list lsvr-pressville-post-grid__list--<?php echo esc_attr( count( $posts ) ); ?>-items<?php if ( true === $enable_slider ) { echo ' lsvr-pressville-post-grid--slider lsvr-pressville-post-grid__list--loading'; } ?>"
                                        data-columns-count="<?php echo esc_attr( $args['columns_count'] ); ?>">

                                        <?php foreach ( $posts as $post ) : ?>

                                            <div class="<?php echo esc_attr( $col_class ); ?> lsvr-pressville-post-grid__item">

                                                <article <?php post_class( 'lsvr-pressville-post-grid__post', $post->ID ); ?>
                                                    <?php if ( has_post_thumbnail( $post->ID ) ) { echo ' style="background-image: url( ' . esc_url( get_the_post_thumbnail_url( $post->ID, $thumb_size ) ) . ' );"'; } ?>>
                                                    <div class="lsvr-pressville-post-grid__post-inner">
                                                        <div class="lsvr-pressville-post-grid__post-bg">

                                                            <div class="lsvr-pressville-post-grid__post-content">

                                                                <h3 class="lsvr-pressville-post-grid__post-title">
                                                                    <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-pressville-post-grid__post-title-link" rel="bookmark"><?php echo esc_html( $post->post_title ); ?></a>
                                                                </h3>

                                                            </div>

                                                            <p class="lsvr-pressville-post-grid__post-meta">
                                                                <time class="lsvr-pressville-post-grid__post-meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date( get_option( 'date_format' ), $post->ID ); ?></time>
                                                                <?php if ( lsvr_pressville_toolkit_has_post_terms( $post->ID, 'lsvr_gallery_cat' ) ) : ?>
                                                                    <span class="lsvr-pressville-post-grid__post-meta-categories"><?php lsvr_pressville_toolkit_the_post_categories( $post->ID, 'lsvr_gallery_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
                                                                <?php endif; ?>
                                                                <span class="lsvr-pressville-post-grid__post-meta-images-count"><?php echo esc_html( sprintf( _n( '%d image', '%d images', lsvr_pressville_toolkit_get_gallery_images_count( $post->ID ), 'lsvr-pressville-toolkit' ), lsvr_pressville_toolkit_get_gallery_images_count( $post->ID ) ) ); ?></span>
                                                            </p>

                                                            <a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="lsvr-pressville-post-grid__post-overlay-link">
                                                                <span class="screen-reader-text"><?php esc_html_e( 'More', 'lsvr-pressville-toolkit' ); ?></span>
                                                            </a>

                                                        </div>
                                                    </div>
                                                </article>

                                            </div>

                                        <?php endforeach; wp_reset_postdata(); ?>

                                    </div>
                                </div>

                            <?php else : ?>

                                <p class="c-alert-message"><?php esc_html_e( 'There are no posts', 'lsvr-pressville-toolkit' ); ?></p>

                            <?php endif; ?>

                            <?php if ( ! empty( $args[ 'more_label' ] ) ) : ?>
                                <footer class="lsvr-pressville-post-grid__footer">
                                    <p class="lsvr-pressville-post-grid__more lsvr-pressville-post-grid__more--bottom">
                                        <?php if ( ! empty( $category_id ) ) : ?>
                                            <a href="<?php echo esc_url( get_term_link( $category_id, 'lsvr_gallery_cat' ) ); ?>" class="c-button lsvr-pressville-post-grid__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>
                                        <?php else : ?>
                                            <a href="<?php echo esc_url( get_post_type_archive_link( 'lsvr_gallery' ) ); ?>" class="c-button lsvr-pressville-post-grid__more-link"><?php echo esc_html( $args[ 'more_label' ] ); ?></a>
                                        <?php endif; ?>
                                    </p>
                                </footer>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </section>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Title
                array(
                    'name' => 'title',
                    'type' => 'text',
                    'label' => esc_html__( 'Title', 'lsvr-pressville-toolkit' ),
                    'priority' => 10,
                ),

                // Subtitle
                array(
                    'name' => 'subtitle',
                    'type' => 'text',
                    'label' => esc_html__( 'Subtitle', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ),

                // Icon
                array(
                    'name' => 'icon',
                    'type' => 'text',
                    'label' => esc_html__( 'Icon Class', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Class of the icon which will be displayed in element title. Check out the documentation to learn more about icons. Leave blank to hide.', 'lsvr-pressville-toolkit' ),
                    'priority' => 30,
                ),

                // Category
                array(
                    'name' => 'category',
                    'type' => 'taxonomy',
                    'tax' => 'lsvr_gallery_cat',
                    'label' => esc_html__( 'Category', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Display galleries from a specific category.', 'lsvr-pressville-toolkit' ),
                    'priority' => 40,
                ),

                // More label
                array(
                    'name' => 'more_label',
                    'type' => 'text',
                    'label' => esc_html__( 'More Button Label', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Link to gallery archive. Leave blank to hide.', 'lsvr-pressville-toolkit' ),
                    'priority' => 50,
                ),

                // Layout
                array(
                    'name' => 'layout',
                    'type' => 'select',
                    'label' => esc_html__( 'Layout', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose the layout of this element. Please note that the "Title in the Background" layout doesn\'t display the subtitle and icon on desktops and all layouts are displayed as "Title on the Top" on small devices.', 'lsvr-pressville-toolkit' ),
                    'choices' => array(
                        'title-top' => esc_html__( 'Title on the Top', 'lsvr-pressville-toolkit' ),
                        'title-left' => esc_html__( 'Title on the Left', 'lsvr-pressville-toolkit' ),
                        'title-bg' => esc_html__( 'Title in the Background', 'lsvr-pressville-toolkit' ),
                    ),
                    'priority' => 60,
                ),

                // Limit
                array(
                    'name' => 'limit',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Galleries', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many galleries should be displayed. Set to 0 to display all.', 'lsvr-pressville-toolkit' ),
                    'choices' => range( 0, 50, 1 ),
                    'default' => 8,
                    'priority' => 70,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display galleries.', 'lsvr-pressville-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 4,
                    'priority' => 80,
                ),

                // Enable dark BG
                array(
                    'name' => 'enable_dark_bg',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Darken Background', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Darken the background color of this element.', 'lsvr-pressville-toolkit' ),
                    'priority' => 90,
                ),

                // Enable slider
                array(
                    'name' => 'enable_slider',
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Enable Slider', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Display galleries as a slider.', 'lsvr-pressville-toolkit' ),
                    'priority' => 100,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 110,
                ),

            ), apply_filters( 'lsvr_pressville_galleries_shortcode_atts', array() ) );
        }

    }
}
?>