<?php
/**
 * LSVR Pressville Sitemap Shortcode
 */
if ( ! class_exists( 'Lsvr_Shortcode_Pressville_Sitemap' ) ) {
    class Lsvr_Shortcode_Pressville_Sitemap {

        public static function shortcode( $atts = array(), $content = null, $tag ) {

            // Merge default atts and received atts
            $args = shortcode_atts(
                array(
                    'id' => '',
                    'bg_image' => '',
                    'menu_id' => '',
                    'columns_count' => 4,
                ),
                $atts
            );

            // Prepare bg image
            if ( ! empty( $args['bg_image'] ) && is_numeric( $args['bg_image'] ) ) {
                $bg_image_url = wp_get_attachment_image_src( $args['bg_image'], 'full' );
                $bg_image_url = ! empty( $bg_image_url[0] ) ? $bg_image_url[0] : false;
            }
            else if ( ! empty( $args['bg_image'] ) ) {
                $bg_image_url = $args['bg_image'];
            }

            ob_start(); ?>

            <section class="lsvr-pressville-sitemap<?php if ( ! empty( $bg_image_url ) ) { echo ' lsvr-pressville-sitemap--has-bg'; } ?>" <?php echo ! empty( $args['id'] ) ? ' id="' . esc_attr( $args['id'] ) . '"' : ''; ?>>
                <div class="lsvr-pressville-sitemap__inner">
                    <div class="lsvr-container">
                        <div class="lsvr-pressville-sitemap__content">

                            <nav class="lsvr-pressville-sitemap__nav--<?php echo ! empty( $args['columns_count'] ) ? esc_attr( $args['columns_count'] ) : 4; ?>-cols">
                                <?php $menu_id = ! empty( $args['menu_id'] ) ? $args['menu_id'] : '';
                                wp_nav_menu(array(
                                    'menu' => $menu_id,
                                    'container' => '',
                                    'menu_class' => 'lsvr-pressville-sitemap__list',
                                    'fallback_cb' => '',
                                    'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                    'walker' => new Lsvr_Pressville_Sitemap_Walker,
                                )); ?>
                            </nav>

                        </div>
                    </div>
                    <?php if ( ! empty( $bg_image_url ) ) : ?>
                        <div class="lsvr-pressville-sitemap__bg" style="background-image: url('<?php echo esc_url( $bg_image_url ); ?>');"></div>
                    <?php endif; ?>
                </div>
            </section>

            <?php return ob_get_clean();

        }

        // Shortcode params
        public static function lsvr_shortcode_atts() {
            return array_merge( array(

                // Menu ID
                array(
                    'name' => 'menu_id',
                    'type' => 'menu',
                    'label' => esc_html__( 'Menu', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Choose which menu will be used to create the sitemap. You can manage menus under Appearance / Menus.', 'lsvr-pressville-toolkit' ),
                    'priority' => 10,
                ),

                // Background image
                array(
                    'name' => 'bg_image',
                    'type' => 'image',
                    'label' => esc_html__( 'Background Image', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'Optimal resolution is about 2000x1600px or more.', 'lsvr-pressville-toolkit' ),
                    'priority' => 20,
                ),

                // Columns count
                array(
                    'name' => 'columns_count',
                    'type' => 'select',
                    'label' => esc_html__( 'Number of Columns', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'How many columns should be used to display the sitemap.', 'lsvr-pressville-toolkit' ),
                    'choices' => array( 1 => 1, 2 => 2, 3 => 3, 4 => 4 ),
                    'default' => 4,
                    'priority' => 30,
                ),

                // ID
                array(
                    'name' => 'id',
                    'type' => 'text',
                    'label' => esc_html__( 'Unique ID', 'lsvr-pressville-toolkit' ),
                    'description' => esc_html__( 'You can use this ID to style this specific element with custom CSS, for example.', 'lsvr-pressville-toolkit' ),
                    'priority' => 40,
                ),

            ), apply_filters( 'lsvr_pressville_sitemap_shortcode_atts', array() ) );
        }

    }
}
?>