<?php
/**
 * LSVR Posts widget
 *
 * Display list of posts
 */
if ( ! class_exists( 'Lsvr_Widget_Pressville_Post_List' ) && class_exists( 'Lsvr_Widget' ) ) {
class Lsvr_Widget_Pressville_Post_List extends Lsvr_Widget {

    public function __construct() {

    	// Init widget
		parent::__construct(array(
			'id' => 'lsvr_pressville_post_list',
			'classname' => 'lsvr-pressville-post-list-widget',
			'title' => esc_html__( 'Pressville Posts', 'lsvr-pressville-toolkit' ),
			'description' => esc_html__( 'List of Posts', 'lsvr-pressville-toolkit' ),
			'fields' => array(
				'title' => array(
					'label' => esc_html__( 'Title:', 'lsvr-pressville-toolkit' ),
					'type' => 'text',
					'default' => esc_html__( 'News', 'lsvr-pressville-toolkit' ),
				),
				'category' => array(
					'label' => esc_html__( 'Category:', 'lsvr-pressville-toolkit' ),
					'description' => esc_html__( 'Display posts only from certain category', 'lsvr-pressville-toolkit' ),
					'type' => 'taxonomy',
					'taxonomy' => 'category',
					'default_label' => esc_html__( 'None', 'lsvr-pressville-toolkit' ),
				),
				'limit' => array(
					'label' => esc_html__( 'Limit:', 'lsvr-pressville-toolkit' ),
					'description' => esc_html__( 'Number of posts to display. Set to "0" to display all', 'lsvr-pressville-toolkit' ),
					'type' => 'select',
					'choices' => array( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ),
					'default' => 4,
				),
				'show_date' => array(
					'label' => esc_html__( 'Display Date', 'lsvr-pressville-toolkit' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'show_category' => array(
					'label' => esc_html__( 'Display Category', 'lsvr-pressville-toolkit' ),
					'type' => 'checkbox',
					'default' => 'true',
				),
				'more_label' => array(
					'label' => esc_html__( 'More Button Label:', 'lsvr-pressville-toolkit' ),
					'description' => esc_html__( 'Link to post archive. Leave blank to hide', 'lsvr-pressville-toolkit' ),
					'type' => 'text',
					'default' => esc_html__( 'More Posts', 'lsvr-pressville-toolkit' ),
				),
			),
		));

    }

    function widget( $args, $instance ) {

		// Set posts limit
		$limit = array_key_exists( 'limit', $instance ) && (int) $instance[ 'limit' ] > 0 ? $instance[ 'limit' ] : 1000;

    	// Get posts
    	$query_args = array(
    		'post_type' => 'post',
    		'posts_per_page' => $limit,
    		'suppress_filters' => false,
		);
		if ( ! empty( $instance['category'] ) && 'none' !== $instance['category'] ) {
			$query_args['tax_query'] = array(
				array(
					'taxonomy' => 'category',
					'field' => 'term_id',
					'terms' => $instance['category'],
				),
			);
		}
    	$posts = get_posts( $query_args );
        ?>

        <?php // Before widget content
        parent::before_widget_content( $args, $instance ); ?>

        <div class="widget__content">

        	<?php if ( ! empty( $posts ) ) : ?>

        		<ul class="lsvr-pressville-post-list-widget__list">
	        		<?php foreach ( $posts as $post ) : ?>

	        			<li class="lsvr-pressville-post-list-widget__item<?php if ( has_post_thumbnail( $post->ID ) ) { echo ' lsvr-pressville-post-list-widget__item--has-thumb'; } ?>">

		        			<?php // Thumbnail
		        			if ( has_post_thumbnail( $post->ID ) ) : ?>
		        				<p class="lsvr-pressville-post-list-widget__item-thumb">
		        					<a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" class="lsvr-pressville-post-list-widget__item-thumb-link">
		        						<?php echo get_the_post_thumbnail( $post->ID, 'thumbnail' ); ?>
		        					</a>
		        				</p>
		        			<?php endif; ?>

		        			<h4 class="lsvr-pressville-post-list-widget__item-title">
		        				<a href="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" class="lsvr-pressville-post-list-widget__item-title-link">
		        					<?php echo get_the_title( $post->ID ); ?>
		        				</a>
		        			</h4>

							<?php // Date
							if ( ! empty( $instance['show_date'] ) && 'true' === $instance['show_date'] ) : ?>
								<p class="lsvr-pressville-post-list-widget__item-date">
									<time datetime="<?php echo esc_attr( date( 'c', strtotime( $post->post_date ) ) ); ?>">
										<?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ) ); ?>
									</time>
								</p>
							<?php endif; ?>

							<?php // Category
							$terms = wp_get_post_terms( $post->ID, 'category' );
							$category_html = '';
							if ( ! empty( $terms ) ) {
								foreach ( $terms as $term ) {
									$category_html .= '<a href="' . esc_url( get_term_link( $term->term_id, 'category' ) ) . '" class="lsvr-pressville-post-list-widget__item-category-link">' . $term->name . '</a>';
									$category_html .= $term !== end( $terms ) ? ', ' : '';
								}
							}
							if ( ! empty( $instance['show_category'] ) && 'true' === $instance['show_category'] && ! empty( $category_html ) ) : ?>
								<p class="lsvr-pressville-post-list-widget__item-category">
									<?php echo sprintf( esc_html__( 'in %s', 'lsvr-pressville-toolkit' ), $category_html ); ?>
								</p>
							<?php endif; ?>

	        			</li>

	        		<?php endforeach; ?>
        		</ul>

				<?php if ( ! empty( $instance[ 'more_label' ] ) ) : ?>
				<p class="widget__more">
					<?php if ( ! empty( $instance['category'] ) && is_numeric( $instance['category'] ) ) : ?>
						<a href="<?php echo esc_url( get_term_link( (int) $instance['category'], 'category' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
					<?php else : ?>
						<a href="<?php echo esc_url( get_post_type_archive_link( 'category' ) ); ?>" class="widget__more-link"><?php echo esc_html( $instance[ 'more_label' ] ); ?></a>
					<?php endif; ?>
				</p>
				<?php endif; ?>

        	<?php else : ?>
        		<p class="widget__no-results"><?php esc_html_e( 'There are no posts', 'lsvr-pressville-toolkit' ); ?></p>
        	<?php endif; ?>

        </div>

        <?php // After widget content
        parent::after_widget_content( $args, $instance ); ?>

        <?php

    }

}}

?>