/**
 * Table of contents
 *
 * 1. Init components & shortcodes
 * 2. Header
 * 3. Core
 * 4. Other
 * 5. Shortcodes
 * 6. Plugins
 */

(function($){ "use strict";
$(document).on( 'ready', function() {

/* -----------------------------------------------------------------------------

	1. INIT COMPONENTS & SHORTCODES

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		GOOGLE MAP
	-------------------------------------------------------------------------- */

	if ( $.fn.lsvrPressvilleGoogleMap ) {
		$( '.c-gmap' ).each(function() {
			$(this).lsvrPressvilleGoogleMap();
		});
	}

	/* -------------------------------------------------------------------------
		LSVR PRESSVILLE POST GRID SHORTCODE
	-------------------------------------------------------------------------- */

	if ( $.fn.lsvrPressvillePostGridShortcode ) {

		// Default init
		$( '.lsvr-pressville-post-grid--has-slider' ).each(function() {
			$(this).addClass( 'lsvr-pressville-post-grid--init' );
			$(this).lsvrPressvillePostGridShortcode();
		});

		// Init in Tailor
		if ( typeof window.Tailor !== 'undefined' && typeof window.Tailor.Api !== 'undefined' ) {
			( function( ElementAPI ) {
				ElementAPI.onRender( 'lsvr_pressville_directory', function( atts, model ) {
					$( '.lsvr-pressville-post-grid--has-slider:not( .lsvr-pressville-post-grid--init )' ).each(function() {
						$(this).addClass( 'lsvr-pressville-post-grid--init' );
						$(this).lsvrPressvillePostGridShortcode();
					});
				});
				ElementAPI.onRender( 'lsvr_pressville_events', function( atts, model ) {
					$( '.lsvr-pressville-post-grid--has-slider:not( .lsvr-pressville-post-grid--init )' ).each(function() {
						$(this).addClass( 'lsvr-pressville-post-grid--init' );
						$(this).lsvrPressvillePostGridShortcode();
					});
				});
				ElementAPI.onRender( 'lsvr_pressville_galleries', function( atts, model ) {
					$( '.lsvr-pressville-post-grid--has-slider:not( .lsvr-pressville-post-grid--init )' ).each(function() {
						$(this).addClass( 'lsvr-pressville-post-grid--init' );
						$(this).lsvrPressvillePostGridShortcode();
					});
				});
				ElementAPI.onRender( 'lsvr_pressville_posts', function( atts, model ) {
					$( '.lsvr-pressville-post-grid--has-slider:not( .lsvr-pressville-post-grid--init )' ).each(function() {
						$(this).addClass( 'lsvr-pressville-post-grid--init' );
						$(this).lsvrPressvillePostGridShortcode();
					});
				});
			})( window.Tailor.Api.Element );
		}

	}

	/* -------------------------------------------------------------------------
		LSVR PRESSVILLE SITEMAP SHORTCODE
	-------------------------------------------------------------------------- */

	if ( $.fn.lsvrPressvilleSitemapShortcode ) {

		// Default init
		$( '.lsvr-pressville-sitemap' ).each(function() {
			$(this).addClass( 'lsvr-pressville-sitemap--init' );
			$(this).lsvrPressvilleSitemapShortcode();
		});

		// Init in Tailor
		if ( typeof window.Tailor !== 'undefined' && typeof window.Tailor.Api !== 'undefined' ) {
			( function( ElementAPI ) {
				ElementAPI.onRender( 'lsvr_pressville_sitemap', function( atts, model ) {
					$( '.lsvr-pressville-sitemap:not( .lsvr-pressville-sitemap--init )' ).each(function() {
						$(this).addClass( 'lsvr-pressville-sitemap--init' );
						$(this).lsvrPressvilleSitemapShortcode();
					});
				});
			})( window.Tailor.Api.Element );
		}

	}


/* -----------------------------------------------------------------------------

	2. HEADER

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		BACKGROUND SLIDESHOW
	-------------------------------------------------------------------------- */

	$( '.header-titlebar__background--slideshow, .header-titlebar__background--slideshow-home' ).each(function() {

		var $this = $(this),
			$images = $this.find( '.header-titlebar__background-image' ),
			slideshowSpeed = $this.data( 'slideshow-speed' ) ? parseInt( $this.data( 'slideshow-speed' ) ) * 1000 : 10,
			animationSpeed = 2000;

		// Continue if there are at least two images
		if ( $images.length > 1 ) {

			// Set default active image
			$images.filter( '.header-titlebar__background-image--default' ).addClass( 'header-titlebar__background-image--active' );
			var $active = $images.filter( '.header-titlebar__background-image--active' ),
				$next;

			// Change image to next one
			var changeImage = function() {

				// Determine next image
				if ( $active.next().length > 0 ) {
					$next = $active.next();
				}
				else {
					$next = $images.first();
				}

				// Hide active
				$active.fadeOut( animationSpeed, function() {
					$(this).removeClass( 'header-titlebar__background-image--active'  );
				});

				// Show next
				$next.fadeIn( animationSpeed, function() {
					$(this).addClass( 'header-titlebar__background-image--active' );
					$active = $(this);
				});

				// Repeat
				setTimeout( function() {
					changeImage();
				}, slideshowSpeed );

			};

			// Init
			if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 1199 ) {
				setTimeout( function() {
					changeImage();
				}, slideshowSpeed );
			}

		}

	});

	/* -------------------------------------------------------------------------
		STICKY NAVBAR
	-------------------------------------------------------------------------- */

	$( '.header-navbar--is-sticky' ).each(function(){

		if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {

			var $navbar = $(this),
				$titlebar = $( '.header-titlebar' ),
				navbarHeight = $navbar.outerHeight(),
				titlebarHeight = $titlebar.outerHeight();

			// Insert navbar placeholder element
			$navbar.after( '<div class="header-navbar__placeholder"></div>' );
			var $placeholder = $( '.header-navbar__placeholder' );
			$placeholder.css( 'height', navbarHeight );

			$(window).scroll(function() {

	    		if ( $(window).scrollTop() > titlebarHeight ) {
	    			$placeholder.addClass( 'header-navbar__placeholder--active' );
	    			$navbar.addClass( 'header-navbar--sticky' );
	    		} else {
	    			$placeholder.removeClass( 'header-navbar__placeholder--active' );
	    			$navbar.removeClass( 'header-navbar--sticky' );
	    		}

			});

		}

	});

	/* -------------------------------------------------------------------------
		PRIMARY MENU
	------------------------------------------------------------------------- */

	// Dropdown menu
	$( '.header-menu-primary__dropdown' ).each(function() {

		var $dropdown = $(this),
			$parent = $dropdown.parent();

		// Check if this dropdown has any children
		if ( $dropdown.find( '.header-menu-primary__submenu' ).length > 0 ) {

			// Arrow indicator
			$parent.find( '.header-menu-primary__item-link--level-0' ).append( '<span class="header-menu-primary__item-indicator header-menu-primary__item-indicator--dropdown"></span>' );

			// Submenu indicator
			$dropdown.find( '.header-menu-primary__submenu--level-1' ).each(function() {
				$(this).parent().addClass( 'header-menu-primary__item--has-submenu' );
			});

			// Dropdown hover
			$parent.hover(function() {
				if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
					$dropdown.stop( true );
					$dropdown.fadeIn( 150 );
					$parent.addClass( 'header-menu-primary__item--is-hover' );
				}
			}, function() {
				if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
					$dropdown.fadeOut( 150 );
					$parent.removeClass( 'header-menu-primary__item--is-hover' );
				}
			});

			// Dropdown touch
			$parent.on( 'click', function(){
				if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 && ! $parent.hasClass( 'header-menu-primary__item--is-hover' ) ) {

					// Hide other menus
					$( '.header-menu-primary__item--is-hover' ).removeClass( 'header-menu-primary__item--is-hover' );
					$( '.header-menu-primary__megamenu' ).hide();
					$( '.header-menu-primary__dropdown' ).hide();
					$( '.header-menu-primary__dropdown .header-menu-primary__submenu--level-1' ).hide();

					// Show touched one
					$dropdown.fadeIn( 150 );
					$parent.addClass( 'header-menu-primary__item--is-hover' );

					// Hide on click outside
					$(document).on( 'touchstart', function(e) {
						if ( ! $( e.target ).closest( $parent ).length && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
							$parent.removeClass( 'header-menu-primary__item--is-hover' );
							$dropdown.hide();
						}
					});

					$parent.on( 'touchstart' ,function(e) {
						e.stopPropagation();
					});

					return false;

				}
			});

			// Submenu hover
			$dropdown.find( '.header-menu-primary__item--level-1.header-menu-primary__item--has-submenu' ).each(function() {

				$(this).hover(function() {
					if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
						$(this).find( '> .header-menu-primary__submenu' ).stop( true );
						$(this).find( '> .header-menu-primary__submenu' ).fadeIn( 150 );
						$(this).addClass( 'header-menu-primary__item--is-hover' );
					}
				}, function() {
					if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
						$(this).find( '> .header-menu-primary__submenu' ).fadeOut( 150 );
						$(this).removeClass( 'header-menu-primary__item--is-hover' );
					}
				});

				// Submenu touch
				$(this).on( 'click', function(){
					if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 && ! $(this).hasClass( 'header-menu-primary__item--is-hover' ) ) {

						var $this = $(this);

						// Hide other menus
						$( '.header-menu-primary__megamenu' ).hide();
						$( '.header-menu-primary__dropdown .header-menu-primary__submenu--level-1' ).hide();

						// Show touched one
						$this.find( '> .header-menu-primary__submenu' ).fadeIn( 150 );

						// Hide on click outside
						$(document).on( 'touchstart', function(e) {
							if ( ! $( e.target ).closest( $dropdown ).length && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
								$( '.header-menu-primary__dropdown .header-menu-primary__submenu--level-1' ).hide();
							}
						});

						$this.on( 'touchstart' ,function(e) {
							e.stopPropagation();
						});

						return false;

					}
				});

			});

		} else {
			$dropdown.remove();
		}

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$dropdown.removeAttr( 'style' );
			$dropdown.find( '.header-menu-primary__item--level-1.header-menu-primary__item--has-submenu' ).each(function() {
				$(this).removeAttr( 'style' );
			});
		});

	});

	// Megamenu
	$( '.header-menu-primary__megamenu' ).each(function() {

		var $megamenu = $(this),
			$parent = $megamenu.parent();

		// Check if this megamenu has any children
		if ( $megamenu.find( '.header-menu-primary__submenu' ).length > 0 ) {

			// Arrow indicator
			$parent.find( '.header-menu-primary__item-link--level-0' ).append( '<span class="header-menu-primary__item-indicator header-menu-primary__item-indicator--megamenu"></span>' );

			$parent.hover(function() {
				if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
					$megamenu.stop( true );
					$megamenu.fadeIn( 150 );
					$parent.addClass( 'header-menu-primary__item--is-hover' );
				}
			}, function() {
				if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
					$megamenu.fadeOut( 150 );
					$parent.removeClass( 'header-menu-primary__item--is-hover' );
				}
			});

		} else {
			$megamenu.remove();
		}

		// Megamenu touch
		$parent.on( 'click', function(){
			if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 && ! $parent.hasClass( 'header-menu-primary__item--is-hover' ) ) {

				// Hide other menus
				$( '.header-menu-primary__item--is-hover' ).removeClass( 'header-menu-primary__item--is-hover' );
				$( '.header-menu-primary__megamenu' ).hide();
				$( '.header-menu-primary__dropdown' ).hide();

				// Show touched one
				$megamenu.fadeIn( 150 );
				$parent.addClass( 'header-menu-primary__item--is-hover' );

				// Hide on click outside
				$(document).on( 'touchstart', function(e) {
					if ( ! $( e.target ).closest( $parent ).length && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
						$parent.removeClass( 'header-menu-primary__item--is-hover' );
						$megamenu.hide();
					}
				});

				$parent.on( 'touchstart' ,function(e) {
					e.stopPropagation();
				});

				return false;

			}
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$parent.removeClass( 'header-menu-primary__item--is-hover' );
			$megamenu.removeAttr( 'style' );
		});

	});

	// Mobile menu
	$( '.header-menu-primary__submenu' ).each(function() {

		var $this = $(this),
			$parent = $this.closest( '.header-menu-primary__item' );

		$parent.append( '<button type="button" class="header-menu-primary__submenu-toggle"><i class="header-menu-primary__submenu-toggle-icon"></i></button>' );
		var $toggle = $parent.find( '> .header-menu-primary__submenu-toggle' );
		$toggle.on( 'click', function() {
			$this.slideToggle( 150 );
			$parent.toggleClass( 'header-menu-primary__item--open' );
			$(this).toggleClass( 'header-menu-primary__submenu-toggle--active' );
			$(this).find( '.header-menu-primary__submenu-toggle-icon' ).toggleClass( 'header-menu-primary__submenu-toggle-icon--active' );
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$this.removeAttr( 'style' );
			$parent.removeClass( 'header-menu-primary__item--open' );
			$toggle.removeClass( 'header-menu-primary__submenu-toggle--active' );
			$toggle.find( '.header-menu-primary__submenu-toggle-icon' ).removeClass( 'header-menu-primary__submenu-toggle-icon--active' );
		});

	});

	/* -------------------------------------------------------------------------
		HEADER SEARCH
	------------------------------------------------------------------------- */

	$( '.header-search' ).each(function() {

		var $this = $(this),
			$form = $this.find( '.header-search__form' ),
			$input = $form.find( '.header-search__input' ),
			$filter = $form.find( '.header-search__filter' );

		// Toggle search
		$( '.header-search__toggle' ).on( 'click', function() {
			$this.slideToggle( 100, function() {
				if ( $this.is( ':visible' ) ) {
					$input.focus();
				}
			});
			$(this).toggleClass( 'header-search__toggle--active' );
		});
		$(document).on( 'click', function(e) {
			if ( ! $( e.target ).closest( '.header-search__wrapper' ).length && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) {
				$this.slideUp( 150 );
			}
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$this.removeAttr( 'style' );
		});

		// Search filter
		var refreshSearchFilter = function( checkbox ) {

			if ( true === checkbox.prop( 'checked' ) || 'checked' === checkbox.prop( 'checked' ) ) {

				checkbox.parent().addClass( 'header-search__filter-label--active' );

				// Filter all
				if ( checkbox.attr( 'id' ).indexOf( 'header-search-filter-type-any' ) >= 0 ) {
					$filter.find( 'input:not( [id^=header-search-filter-type-any] )' ).prop( 'checked', false ).change();
				}

				// Filter others
				else {
					$filter.find( 'input[id^=header-search-filter-type-any]' ).prop( 'checked', false ).change();
				}

			} else {

				checkbox.parent().removeClass( 'header-search__filter-label--active' );

				// Filter All if there is no other filter active
				if ( $filter.find( 'input:checked' ).length < 1 ) {
					$filter.find( 'input[id^=header-search-filter-type-any]' ).prop( 'checked', true ).change();
				}

			}

		};
		$filter.find( 'input' ).each(function() {
			refreshSearchFilter( $(this) );
			$(this).on( 'change', function() {
				refreshSearchFilter( $(this) );
			});
		});

	});

	/* -------------------------------------------------------------------------
		HEADER LANGUAGES MOBILE
	------------------------------------------------------------------------- */

	$( '.header-languages-mobile' ).each(function() {

		var $this = $(this),
			$container = $this.find( '.header-languages-mobile__inner' ),
			$toggle = $this.find( '.header-languages-mobile__toggle' );

		$toggle.on( 'click', function() {
			$(this).toggleClass( 'header-languages-mobile__toggle--active' );
			$container.slideToggle( 100 );
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$container.removeAttr( 'style' );
			$toggle.removeClass( 'header-languages-mobile__toggle--active' );
		});

	});

	/* -------------------------------------------------------------------------
		HEADER MOBILE TOGGLE
	------------------------------------------------------------------------- */

	$( '.header-mobile-toggle' ).each(function() {

		var $this = $(this),
			$icon = $this.find( '.header-mobile-toggle__icon' ),
			$navgroup = $( '.header__navgroup' );

		$this.on( 'click', function() {
			$icon.toggleClass( 'header-mobile-toggle__icon--active' );
			$navgroup.slideToggle( 100 );
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrPressvilleScreenTransition', function() {
			$icon.removeClass( 'header-mobile-toggle__icon--active' );
			$navgroup.removeAttr( 'style' );
		});

	});


/* -----------------------------------------------------------------------------

	3. CORE

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		POST COMPONENTS
	------------------------------------------------------------------------- */

	// Post filter
	$( '.post-archive-filter' ).each(function() {

		var $this = $(this),
			$form = $this.find( '.post-archive-filter__form' ),
			$resetButton = $this.find( '.post-archive-filter__reset-button' );

		// Datepicker
		if ( $.fn.datepicker ) {

			$this.find( '.post-archive-filter__input--datepicker' ).each(function() {

				var $datepicker = $(this);

				$datepicker.datepicker({
					dateFormat: 'yy-mm-dd',
					beforeShow: function() {
						$( '#ui-datepicker-div' ).addClass( 'lsvr-datepicker' );
					},
				});

				$datepicker.parent().on( 'click', function() {
					$datepicker.datepicker( 'show' );
				});

			});
		}

		// Reset
		$resetButton.on( 'click', function() {
			$this.find( '.post-archive-filter__input--datepicker' ).each(function() {
				$(this).val( '' );
			});
			$form.submit();
		});

	});

	/* -------------------------------------------------------------------------
		DIRECTORY
	------------------------------------------------------------------------- */

	// Listing masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr_listing-post-archive .lsvr-grid--masonry' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	// Listing gallery carousel
	if ( $.fn.slick ) {
		$( '.lsvr_listing-post-gallery' ).each(function() {

			var $this = $(this),
				$list = $this.find( '.lsvr_listing-post-gallery__list' ),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			$list.on( 'init', function() {

				$this.removeClass( 'lsvr_listing-post-gallery--loading' );

				// Init lightbox
				if ( $.fn.magnificPopup ) {

					$this.find( '.lsvr_listing-post-gallery__link' ).magnificPopup({
						type: 'image',
						removalDelay: 300,
						mainClass: 'mfp-fade',
						gallery: {
							enabled: true,
							tCounter: '' // Disable images count, because carousel contains image duplicates to create seamless loop
						}
					});

				}

			});

			// Init Slick
			$list.slick({
  				infinite: false,
  				rtl: isRTL,
  				prevArrow: false,
  				nextArrow: false,
  				slidesToShow: 5,
  				slidesToScroll: 3,
				responsive: [
					{
				  		breakpoint: 2000,
				  		settings: {
			    			slidesToShow: 4,
				    		slidesToScroll: 2,
				  		}
					},
					{
				  		breakpoint: 1600,
				  		settings: {
				    		slidesToShow: 3,
				    		slidesToScroll: 1
			  			}
					},
					{
				  		breakpoint: 1000,
				  		settings: {
				    		slidesToShow: 2,
				    		slidesToScroll: 1
				  		}
					},
					{
				  		breakpoint: 500,
				  		settings: {
				    		slidesToShow: 1,
				    		slidesToScroll: 1
				  		}
					}
				],
			});

			// Prev
			$( '.lsvr_listing-post-gallery__button--prev' ).on( 'click', function() {
				$list.slick( 'slickPrev' );
			});

			// Next
			$( '.lsvr_listing-post-gallery__button--next' ).on( 'click', function() {
				$list.slick( 'slickNext' );
			});

		});

	}

	/* -------------------------------------------------------------------------
		EVENTS
	------------------------------------------------------------------------- */

	// Events masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr_event-post-archive .lsvr-grid--masonry' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	// Upcoming dates
	$( '.lsvr_event-post-single .post__dates' ).each(function() {

		var $this = $(this),
			$title = $this.find( '.post__dates-title' ),
			$listWrapper = $this.find( '.post__dates-list-wrapper' );

		$title.on( 'click', function() {
			$title.toggleClass( 'post__dates-title--active' );
			$listWrapper.slideToggle( 150 );
		});

	});

	/* -------------------------------------------------------------------------
		GALLERIES
	------------------------------------------------------------------------- */

	// Gallery masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr_gallery-post-archive .lsvr-grid--masonry, .lsvr_gallery-post-single .post__image-list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		DOCUMENTS
	------------------------------------------------------------------------- */

	// Categorized attachments
	$( '.lsvr_document-post-archive--categorized-attachments .post-tree__folder' ).each(function() {

		var $this = $(this),
			$holder = $this.find( '> .post-tree__folder-link-holder' ),
			$children = $this.find( '> .post-tree__children' );

		// Add toggle
		if ( $children.length > 0 ) {
			$holder.append( '<button type="button" class="post-tree__folder-toggle"></button>' );
		}
		var $toggle = $holder.find( '> .post-tree__folder-toggle' );

		// Toggle click
		$toggle.on( 'click', function() {
			$(this).toggleClass( 'post-tree__folder-toggle--active' );
			$children.slideToggle( 150 );
		});

	});


/* -----------------------------------------------------------------------------

	4. OTHER

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		BACK TO TOP
	------------------------------------------------------------------------- */

	$( '.back-to-top' ).each(function() {

		var $this = $(this),
			$link = $this.find( '.back-to-top__link' ),
			threshold = $this.attr( 'data-threshold' ) ? parseInt( $this.data( 'threshold' ) ) : 100;

		// Show link after scrolled down
		if ( threshold > 0 && (
			$this.hasClass( 'back-to-top--type-enable' ) ||
			( $this.hasClass( 'back-to-top--type-desktop' ) && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() > 991 ) ||
			( $this.hasClass( 'back-to-top--type-mobile' ) && $.fn.lsvrPressvilleGetMediaQueryBreakpoint() < 992 ) ) ) {

			$(window).scroll(function() {

	    		if ( $(window).scrollTop() > threshold && $this.is( ':hidden' ) ) {
	    			$this.fadeIn( 300 );
	    		} else if ( $(window).scrollTop() <= threshold && $this.is( ':visible' ) ) {
	    			$this.fadeOut( 300 );
	    		}

			});
		}

		// Click action
		$link.on( 'click', function() {
			$( 'html, body' ).animate({ scrollTop: 0 }, 100 );
			return false;
		});

	});

	/* -------------------------------------------------------------------------
		MAGNIFIC POPUP
	------------------------------------------------------------------------- */

	if ( $.fn.magnificPopup ) {

		// Lightbox config
		if ( 'undefined' !== typeof lsvr_pressville_magnificpopup_config ) {
			var js_strings = lsvr_pressville_magnificpopup_config;
			$.extend( true, $.magnificPopup.defaults, {
				tClose: js_strings.mp_tClose,
				tLoading: js_strings.mp_tLoading,
				gallery: {
					tPrev: js_strings.mp_tPrev,
					tNext: js_strings.mp_tNext,
					tCounter: '%curr% / %total%'
				},
				image: {
					tError: js_strings.mp_image_tError,
				},
				ajax: {
					tError: js_strings.mp_ajax_tError,
				}
			});
		}

		// Init lightbox
		$( '.lsvr-open-in-lightbox, .gallery .gallery-item a' ).magnificPopup({
			type: 'image',
			removalDelay: 300,
			mainClass: 'mfp-fade',
			gallery: {
				enabled: true
			}
		});

	}

});
})(jQuery);

(function($){ "use strict";

/* -----------------------------------------------------------------------------

	5. SHORTCODES

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		PRESSVILLE POST GRID
	-------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrPressvillePostGridShortcode ) {
		$.fn.lsvrPressvillePostGridShortcode = function() {
			if ( $.fn.slick ) {

				var $this = $(this),
					$slider = $this.find( '.lsvr-pressville-post-grid__list' ),
					$wrapper = $this.find( '.lsvr-pressville-post-grid__list-wrapper' ),
					isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false,
					columnsCount = $slider.data( 'columns-count' ),
					columnsCountLg = columnsCount > 3 ? 3 : columnsCount,
					columnsCountMd = columnsCount > 2 ? 2 : columnsCount;

				// Remove loading
				$slider.on( 'init', function() {
					$slider.removeClass( 'lsvr-pressville-post-grid__list--loading' );
				});

				// Add navigation
				$wrapper.append( '<button type="button" class="c-arrow-button lsvr-pressville-post-grid__list-button lsvr-pressville-post-grid__list-button--prev"><i class="c-arrow-button__icon c-arrow-button__icon--left"></i></button>' );
				$wrapper.append( '<button type="button" class="c-arrow-button lsvr-pressville-post-grid__list-button lsvr-pressville-post-grid__list-button--next"><i class="c-arrow-button__icon c-arrow-button__icon--right"></i></button>' );

				// Init Slick
				$slider.slick({
	  				infinite: true,
	  				rtl: isRTL,
	  				prevArrow: false,
	  				nextArrow: false,
	  				slidesToShow: columnsCount,
	  				slidesToScroll: columnsCount,
					responsive: [
						{
					  		breakpoint: 1199,
					  		settings: {
					    		slidesToShow: columnsCountLg,
					    		slidesToScroll: columnsCountLg
					  		}
						},
						{
					  		breakpoint: 991,
					  		settings: {
					    		slidesToShow: columnsCountMd,
					    		slidesToScroll: columnsCountMd
					  		}
						},
						{
					  		breakpoint: 767,
					  		settings: {
					    		slidesToShow: 1,
					    		slidesToScroll: 1
					  		}
						}
					],
				});

				// Prev
				$wrapper.find( '.lsvr-pressville-post-grid__list-button--prev' ).on( 'click', function() {
					$slider.slick( 'slickPrev' );
				});

				// Next
				$wrapper.find( '.lsvr-pressville-post-grid__list-button--next' ).on( 'click', function() {
					$slider.slick( 'slickNext' );
				});

			}
		};
	}

	/* -------------------------------------------------------------------------
		PRESSVILLE SITEMAP
	-------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrPressvilleSitemapShortcode ) {
		$.fn.lsvrPressvilleSitemapShortcode = function() {

			$(this).find( '.lsvr-pressville-sitemap__submenu--level-1' ).each(function() {

				var $this = $(this),
					$parent = $this.parent();

				// Add toggle
				$parent.append( '<button type="button" class="lsvr-pressville-sitemap__toggle"><i class="lsvr-pressville-sitemap__toggle-icon"></i></button>' );
				var $toggle = $parent.find( '.lsvr-pressville-sitemap__toggle' );

				$toggle.on( 'click', function() {
					$this.slideToggle( 200 );
					$toggle.toggleClass( 'lsvr-pressville-sitemap__toggle--active' );
				});

			});

		};
	}


/* -----------------------------------------------------------------------------

	6. PLUGINS

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		MEDIA QUERY BREAKPOINT
	------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrPressvilleGetMediaQueryBreakpoint ) {
		$.fn.lsvrPressvilleGetMediaQueryBreakpoint = function() {

			if ( $( '#lsvr-media-query-breakpoint' ).length < 1 ) {
				$( 'body' ).append( '<span id="lsvr-media-query-breakpoint" style="display: none;"></span>' );
			}
			var value = $( '#lsvr-media-query-breakpoint' ).css( 'font-family' );
			if ( typeof value !== 'undefined' ) {
				value = value.replace( "\"", "" ).replace( "\"", "" ).replace( "\'", "" ).replace( "\'", "" );
			}
			if ( isNaN( value ) ) {
				return $( window ).width();
			}
			else {
				return parseInt( value );
			}

		};
	}

	var lsvrPressvilleMediaQueryBreakpoint;
	if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint ) {
		lsvrPressvilleMediaQueryBreakpoint = $.fn.lsvrPressvilleGetMediaQueryBreakpoint();
		$(window).resize(function(){
			if ( $.fn.lsvrPressvilleGetMediaQueryBreakpoint() !== lsvrPressvilleMediaQueryBreakpoint ) {
				lsvrPressvilleMediaQueryBreakpoint = $.fn.lsvrPressvilleGetMediaQueryBreakpoint();
				$.event.trigger({
					type: 'lsvrPressvilleScreenTransition',
					message: 'Screen transition completed.',
					time: new Date()
				});
			}
		});
	}
	else {
		lsvrPressvilleMediaQueryBreakpoint = $(document).width();
	}

	/* -------------------------------------------------------------------------
		GOOGLE MAP
	-------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrPressvilleGoogleMap ) {
		$.fn.lsvrPressvilleGoogleMap = function() {

			// Prepare params
			var $this = $(this).find( '.c-gmap__canvas' ),
				mapType = $this.data( 'maptype' ) ? $this.data( 'maptype' ) : 'terrain',
				zoom = $this.data( 'zoom' ) ? $this.data( 'zoom' ) : 17,
				enableMouseWheel = $this.data( 'mousewheel' ) && true === String( $this.data( 'mousewheel' ) ) ? true : false,
				elementId = $this.attr( 'id' ),
				address = $this.data( 'address' ) ? $this.data( 'address' ) : false,
				latLong = $this.data( 'latlong' ) ? $this.data( 'latlong' ) : false,
				latitude = false, longitude = false;

			// Parse latitude and longitude
			if ( false !== latLong ) {
				var latLongArr = latLong.split( ',' );
				if ( latLongArr.length == 2 ) {
					latitude = latLongArr[0].trim();
					longitude = latLongArr[1].trim();
				}
			}

			// Load Google Maps API
			if ( $.fn.lsvrPressvilleLoadGoogleMapsApi ) {
				$.fn.lsvrPressvilleLoadGoogleMapsApi();
			}

			// Set basic API settings
			var apiSetup = function() {

				// Get map type
				switch ( mapType ) {
					case 'roadmap':
						mapType = google.maps.MapTypeId.ROADMAP;
						break;
					case 'satellite':
						mapType = google.maps.MapTypeId.SATELLITE;
						break;
					case 'hybrid':
						mapType = google.maps.MapTypeId.HYBRID;
						break;
					default:
						mapType = google.maps.MapTypeId.TERRAIN;
				}

				// Prepare map options
				var mapOptions = {
					'zoom' : zoom,
					'mapTypeId' : mapType,
					'scrollwheel' : enableMouseWheel,
				};

				// Set custom styles
				if ( 'undefined' !== typeof lsvr_pressville_google_maps_style_json ) {
					mapOptions.styles = JSON.parse( lsvr_pressville_google_maps_style_json );
				}
				else if ( 'undefined' !== typeof lsvr_pressville_google_maps_style ) {
					mapOptions.styles = lsvr_pressville_google_maps_style;
				}

				// Init the map object
				var map = new google.maps.Map( document.getElementById( elementId ),
					mapOptions );
				$this.data( 'map', map );

				// If no latitude and longitude were obtained, geocode the address
				if ( ( false === latitude || false === longitude ) && false !== address ) {

					// We will need API key for geocoding
					var apiKey = typeof lsvr_pressville_google_api_key !== 'undefined' ? lsvr_pressville_google_api_key : false;
					if ( false !== apiKey ) {

						var encodedAddress = encodeURI( address );

	        			jQuery.ajax({
	            			type: 'post',
	            			dataType: 'JSON',
	            			url: 'https://maps.googleapis.com/maps/api/geocode/json?address=' + encodedAddress + '&key=' + apiKey,
	            			success: function( response ) {
 								map.setCenter( response.results[0].geometry.location );
			 					var marker = new google.maps.Marker({
			            			position: response.results[0].geometry.location,
			            			map: map
			        			});
 								$this.removeClass( 'c-gmap__canvas--loading' );
	            			}
	            		});

					}

				}

				// If latitude and longitude were obtained, center the map
				else if ( false !== latitude && false !== longitude ) {
					var location = new google.maps.LatLng( latitude, longitude );
 					map.setCenter( location );
 					var marker = new google.maps.Marker({
            			position: location,
            			map: map
        			});
 					$this.removeClass( 'c-gmap__canvas--loading' );
				}

				// Otherwise hide the map
				else {
					$this.hide();
				}

			};

			// Check if API is already loaded, if not, wait for trigger
			if ( 'object' === typeof google && 'object' === typeof google.maps ) {
				apiSetup();
			}
			else {
				$( document ).on( 'lsvrPressvilleGoogleMapsApiLoaded', function() {
					apiSetup();
				});
			}

		};
	}

	/* -------------------------------------------------------------------------
		LOAD GOOGLE MAPS API
	-------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrPressvilleLoadGoogleMapsApi ) {
		$.fn.lsvrPressvilleLoadGoogleMapsApi = function() {

			// Check if Google Maps API isn't already loaded
			if ( ! $( 'body' ).hasClass( 'lsvr-google-maps-api-loaded' ) ) {

				// Check if Google Maps API object doesn't already exists
				if ( 'object' === typeof google && 'object' === typeof google.maps ) {
					$.fn.lsvrPressvilleGoogleMapsApiLoaded();
				}

				// If there is not existing instance of Google Maps API, let's create it
				else if ( ! $( 'body' ).hasClass( 'lsvr-google-maps-api-being-loaded' ) ) {

					$( 'body' ).addClass( 'lsvr-google-maps-api-being-loaded' );

					var script = document.createElement( 'script' ),
						apiKey = typeof lsvr_pressville_google_api_key !== 'undefined' ? lsvr_pressville_google_api_key : false,
						language = $( 'html' ).attr( 'lang' ) ? $( 'html' ).attr( 'lang' ) : 'en';

					// Parse language
					language = language.indexOf( '-' ) > 0 ? language.substring( 0, language.indexOf( '-' ) ) : language;

					// Append the script
					if ( apiKey !== false ) {
						script.type = 'text/javascript';
						script.src = 'https://maps.googleapis.com/maps/api/js?language=' + encodeURIComponent( language ) + '&key=' + encodeURIComponent( apiKey ) + '&callback=jQuery.fn.lsvrPressvilleGoogleMapsApiLoaded';
						document.body.appendChild( script );
					}

				}

			}

		};
	}

	// Trigger event
	if ( ! $.fn.lsvrPressvilleGoogleMapsApiLoaded ) {
		$.fn.lsvrPressvilleGoogleMapsApiLoaded = function() {

			// Make sure that Google Maps API object does exist
			if ( 'object' === typeof google && 'object' === typeof google.maps ) {

				// Trigger the event
				$.event.trigger({
					type: 'lsvrPressvilleGoogleMapsApiLoaded',
					message: 'Google Maps API is ready.',
					time: new Date()
				});

				// Add class to BODY element
				$( 'body' ).removeClass( 'lsvr-google-maps-api-being-loaded' );
				$( 'body' ).addClass( 'lsvr-google-maps-api-loaded' );

			}

		};
	}

})(jQuery);