<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<!-- WRAPPER : begin -->
	<div id="wrapper">

		<?php // Add custom code before Header
		do_action( 'lsvr_pressville_header_before' ); ?>

		<!-- HEADER : begin -->
		<header id="header">
			<div class="header__inner">

				<?php // Header languages mobile
				lsvr_pressville_the_header_languages_mobile(); ?>

				<?php // Header titlebar
				get_template_part( 'template-parts/header/titlebar' ); ?>

				<?php // Header mobile toggle
				lsvr_pressville_the_header_mobile_toggle(); ?>

				<!-- HEADER NAV GROUP : begin -->
				<div class="header__navgroup">

					<?php // Header topbar
					get_template_part( 'template-parts/header/topbar' ); ?>

					<?php // Header navbar
					get_template_part( 'template-parts/header/navbar' ); ?>

				</div>
				<!-- HEADER NAV GROUP : end -->

			</div>
		</header>
		<!-- HEADER : end -->

		<?php // Add custom code after Header
		do_action( 'lsvr_pressville_header_after' ); ?>

		<!-- CORE : begin -->
		<div id="core">
			<div class="core__inner">