<?php

// Load Google Fonts
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_google_fonts_css', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_google_fonts_css' ) ) {
	function lsvr_pressville_load_google_fonts_css() {

		if ( true === get_theme_mod( 'typography_google_fonts_enable', true ) ) {

			// Prepare query params
			$primary_font = get_theme_mod( 'typography_primary_font', 'Source+Sans+Pro' );
			$primary_font_variants = '400,400italic,600,600italic,700,700italic';
			$secondary_font = get_theme_mod( 'typography_secondary_font', 'Lora' );
			$secondary_font_variants = '400,400italic,700,700italic';
			$family_param = $primary_font !== $secondary_font ? $primary_font . ':' . $primary_font_variants . '|' . $secondary_font . ':' . $secondary_font_variants : $primary_font . ':' . $primary_font_variants;
			$subset = get_theme_mod( 'typography_font_subsets' );
			$subset_param = ! empty( $subset ) && is_string( $subset ) ? $subset : '';

			// Create query
			$query_args = array(
				'family' => $family_param,
				'subset' => $subset_param,
			);
			$query_args = array_filter( $query_args );

			// Enqueue fonts
			if ( ! empty( $query_args ) ) {
				wp_enqueue_style( 'lsvr-pressville-google-fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ) );
			}

			// Primary font style
			$primary_font_elements = array( 'body', 'input', 'textarea', 'select', 'button', '#cancel-comment-reply-link', '.lsvr_listing-map__infobox' );
			$primary_font_family = str_replace( '+', ' ', $primary_font );
			$primary_font_css = implode( ', ', $primary_font_elements ) . ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
			wp_add_inline_style( 'lsvr-pressville-main-style', $primary_font_css );
			wp_add_inline_style( 'lsvr-pressville-main-style', 'html, body { font-size: ' . esc_attr( get_theme_mod( 'typography_base_font_size', '16' ) ) . 'px; }' );

			// Secondary font style
			if ( $primary_font !== $secondary_font ) {
				$secondary_font_elements = array( 'h1', 'h2', 'h3', 'h4', 'blockquote', '.is-secondary-font', '.header-menu-primary__megamenu .header-menu-primary__item-link--level-1' );
				$secondary_font_family = str_replace( '+', ' ', $secondary_font );
				$secondary_font_css = implode( ', ', $secondary_font_elements ) . ' { font-family: \'' . esc_attr( $secondary_font_family ) . '\', Arial, sans-serif; }';
				wp_add_inline_style( 'lsvr-pressville-main-style', $secondary_font_css );
			}

		}

	}
}

// Set logo dimensions
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_set_logo_dimensions', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_set_logo_dimensions' ) ) {
	function lsvr_pressville_set_logo_dimensions() {

		$max_width = get_theme_mod( 'header_logo_max_width', 120 );
		if ( ! empty( $max_width )  ) {
			wp_add_inline_style( 'lsvr-pressville-main-style', '@media ( min-width: 1200px ) { .header-titlebar__logo { width: ' . esc_attr( $max_width ) . 'px; } } .header-titlebar__logo { max-width: ' . esc_attr( $max_width ) . 'px; }' );
		}

	}
}

// Load skin CSS
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_skin_css', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_skin_css' ) ) {
	function lsvr_pressville_load_skin_css() {

		$version = wp_get_theme( 'pressville' );
		$version = $version->Version;

		// Load predefined color skin
		if ( 'predefined' === get_theme_mod( 'colors_method', 'predefined' ) || 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
			$skin_file = get_theme_mod( 'colors_predefined_skin', 'red-blue' );
			wp_enqueue_style( 'lsvr-pressville-color-scheme', get_template_directory_uri() . '/assets/css/skins/' . esc_attr( $skin_file ) . '.css', array( 'lsvr-pressville-main-style' ), $version );
		}

		// Generate CSS from custom colors
		if ( 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
			wp_add_inline_style( 'lsvr-pressville-color-scheme', lsvr_pressville_get_custom_colors_css() );
		}

	}
}

// Load Google API key
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_google_api_key', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_google_api_key' ) ) {
	function lsvr_pressville_load_google_api_key() {

		$api_key = get_theme_mod( 'google_api_key' );
		if ( ! empty( $api_key ) ) {
			wp_add_inline_script( 'lsvr-pressville-main-scripts', 'var lsvr_pressville_google_api_key = "' . esc_js( trim( $api_key ) ) . '";' );
		}

	}
}

// Load Google Maps style
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_google_maps_style', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_google_maps_style' ) ) {
	function lsvr_pressville_load_google_maps_style() {

		if ( is_singular( 'lsvr_listing' ) || is_post_type_archive( 'lsvr_listing' ) || is_tax( 'lsvr_listing_cat' ) || is_tax( 'lsvr_listing_tag' ) || is_singular( 'lsvr_event' ) || is_page() ) {

			$custom_map_style = get_theme_mod( 'google_maps_style_custom', '' );

			if ( 'custom' === get_theme_mod( 'google_maps_style', 'default' ) && ! empty( $custom_map_style ) ) {
				wp_add_inline_script( 'lsvr-pressville-main-scripts', 'var lsvr_pressville_google_maps_style_json = ' . json_encode( $custom_map_style ) . ';' );
			}

		}

	}
}

// Load ajax search JS files
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_ajax_search_js', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_ajax_search_js' ) ) {
	function lsvr_pressville_load_ajax_search_js() {

		if ( true === get_theme_mod( 'header_search_enable', true ) && true === get_theme_mod( 'header_search_ajax_enable', true ) ) {

			$version = wp_get_theme( 'pressville' );
			$version = $version->Version;
			$suffix = defined( 'WP_DEBUG' ) && true == WP_DEBUG ? '' : '.min';

			wp_enqueue_script( 'lsvr-pressville-ajax-search', get_template_directory_uri() . '/assets/js/pressville-ajax-search' . $suffix . '.js', array( 'jquery' ), $version, true );
			wp_localize_script( 'lsvr-pressville-ajax-search', 'lsvr_pressville_ajax_search_var', array(
	    		'url' => admin_url( 'admin-ajax.php' ),
	    		'nonce' => wp_create_nonce( 'lsvr-pressville-ajax-search-nonce' )
			));
		}

	}
}

// Load Magnific Popup lightbox
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_lightbox', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_lightbox' ) ) {
	function lsvr_pressville_load_lightbox() {

		if ( true === apply_filters( 'lsvr_pressville_default_lightbox_enable', true ) && ( is_singular( 'lsvr_listing' ) || is_singular( 'lsvr_gallery' ) ) ) {

			// Load magnific popup script
			wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/js/magnific-popup.min.js', array( 'jquery' ), false, true );

			// Generate config JS for Magnific Popup
			$magnific_popup_config = 'var lsvr_pressville_magnificpopup_config = {
				mp_tClose : \'' . esc_html__( 'Close (Esc)', 'pressville' ) . '\',
				mp_tLoading : \'' . esc_html__( 'Loading...', 'pressville' ) . '\',
				mp_tPrev : \'' . esc_html__( 'Previous (Left arrow key)', 'pressville' ) . '\',
				mp_tNext : \'' . esc_html__( 'Next (Right arrow key)', 'pressville' ) . '\',
				mp_image_tError : \'' . esc_html__( 'The image could not be loaded.', 'pressville' ) . '\',
				mp_ajax_tError : \'' . esc_html__( 'The content could not be loaded.', 'pressville' ) . '\',
			};';
			wp_add_inline_script( 'magnific-popup', $magnific_popup_config );

		}

	}
}

// Load Slick
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_load_slick', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_load_slick' ) ) {
	function lsvr_pressville_load_slick() {

		if ( is_page() ) {
			wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array( 'jquery' ), false, true );
		}

	}
}

// Search filter for non-Ajax search
add_action( 'pre_get_posts', 'lsvr_pressville_search_filter' );
if ( ! function_exists( 'lsvr_pressville_search_filter' ) ) {
	function lsvr_pressville_search_filter( $query ) {
		if ( is_search() && $query->is_main_query() &&
			( isset( $_GET['lsvr-search-filter'] ) || isset( $_GET['lsvr-search-filter-serialized'] ) ) ) {

			if ( isset( $_GET['lsvr-search-filter'] ) ) {
				$post_type_arr = array_map( 'sanitize_key', $_GET['lsvr-search-filter'] );
			} else {
				$post_type_arr = explode( ',', sanitize_key( $_GET['lsvr-search-filter-serialized'] ) );
			}

			$query->set( 'post_type', $post_type_arr );
			return $query;

		}
	}
}

// Add blog breadcrumbs meta
add_action( 'lsvr_pressville_breadcrumbs_after', 'lsvr_pressville_add_breadcrumbs_meta', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_add_breadcrumbs_meta' ) ) {
	function lsvr_pressville_add_breadcrumbs_meta() { ?>

		<!-- BREADCRUMBS META DATA : begin -->
		<script type="application/ld+json">
		{
			"@context": "http://schema.org",
			"@type": "BreadcrumbList",
			"itemListElement" : [
				<?php $i = 1; $breadcrumbs = lsvr_pressville_get_breadcrumbs();
				foreach ( $breadcrumbs as $breadcrumb ) : ?>
				{
					"@type": "ListItem",
					"position": <?php echo esc_js( $i ); ?>,
					"item": {
						"@id": "<?php echo esc_url( $breadcrumb['url'] ); ?>",
						"name": "<?php echo esc_js( $breadcrumb['label'] ); ?>"
					}
				}<?php if ( $breadcrumb !== end( $breadcrumbs ) ) { echo ','; } ?>
				<?php $i++; endforeach; ?>
			]
		}
		</script>
		<!-- BREADCRUMBS META DATA : end -->

	<?php }
}

// Add blog post meta data
add_action( 'lsvr_pressville_blog_single_bottom', 'lsvr_pressville_add_blog_single_meta', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_add_blog_single_meta' ) ) {
	function lsvr_pressville_add_blog_single_meta() { ?>

		<script type="application/ld+json">
		{
			"@context" : "http://schema.org",
			"@type" : "NewsArticle",
			"headline": "<?php echo esc_js( get_the_title() ); ?>",
			"url" : "<?php echo esc_url( get_permalink() ); ?>",
			"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
		 	"datePublished": "<?php echo esc_js( get_the_time( 'c' ) ); ?>",
		 	"dateModified": "<?php echo esc_js( get_the_modified_date( 'c' ) ); ?>",
		 	"description": "<?php echo esc_js( get_the_excerpt() ); ?>",
		 	"author": {
		 		"@type" : "person",
		 		"name" : "<?php echo esc_js( get_the_author() ); ?>",
		 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
		 	},
		 	"publisher" : {
		 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
		 	}

		 	<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'post_tag' ) ) : ?>
			,"keywords": "<?php echo esc_js( implode( ',', lsvr_pressville_get_post_term_names( get_the_ID(), 'post_tag' ) ) ); ?>"
		 	<?php endif; ?>

			<?php if ( has_post_thumbnail() ) : ?>
		 	,"image": {
		 		"@type" : "ImageObject",
		 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
		 		"width" : "<?php echo esc_js( lsvr_pressville_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"height" : "<?php echo esc_js( lsvr_pressville_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
		 	}
		 	<?php endif; ?>

		}
		</script>

	<?php }
}

// Add site meta data
add_action( 'wp_footer', 'lsvr_pressville_add_site_meta', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_add_site_meta' ) ) {
	function lsvr_pressville_add_site_meta() { ?>

		<?php // Get URLs of social links and email address
		$social_links = lsvr_pressville_get_social_links();
		if ( ! empty( $social_links->email ) ) {
			$email = ! empty( $social_links->email->url ) ? $social_links->email->url : '';
			unset( $social_links->email );
		} ?>

		<script type="application/ld+json">
		{
			"@context" : "http://schema.org",
			"@type" : "WebSite",
			"name" : "<?php bloginfo( 'name' ); ?>",
			"url" : "<?php echo esc_url( home_url() ); ?>",
			"description" : "<?php bloginfo( 'description' ); ?>",
		 	"publisher" : {

		 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher",
		 		"@type" : "Organization",
		 		"name" : "<?php echo esc_js( get_bloginfo('name') ); ?>",
		 		"url" : "<?php echo esc_url( home_url() ); ?>"

				<?php if ( ! empty( $email ) ) : ?>
				,"contactPoint": {
			 		"@type": "ContactPoint",
			 		"contactType": "customer service",
			 		"url": "<?php echo esc_url( home_url() ); ?>",
			 		"email": "<?php echo esc_js( $email ); ?>"
			 	}
				<?php endif; ?>

		 		<?php if ( has_custom_logo() ) : ?>
		 		,"logo" : {
		 			"@type" : "ImageObject",
		 			"url" : "<?php echo esc_url( lsvr_pressville_get_image_url( get_theme_mod( 'custom_logo' ) ) ); ?>",
					"width" : "<?php echo esc_attr( lsvr_pressville_get_image_width( get_theme_mod( 'custom_logo' ) ) ); ?>",
					"height" : "<?php echo esc_attr( lsvr_pressville_get_image_height( get_theme_mod( 'custom_logo' ) ) ); ?>"
		 		}
		 		<?php endif; ?>

				<?php if ( ! empty( $social_links ) ) : ?>
				,"sameAs" : [
					<?php foreach( $social_links as $social ) : if ( ! empty( $social->url ) ) : ?>
			    		"<?php echo esc_url( $social->url ); ?>"<?php if ( $social !== end( $social_links ) ) { echo ','; } ?>
					<?php endif; endforeach; ?>
			  	]
			  	<?php endif; ?>

		 	},
		 	"potentialAction": {
		    	"@type" : "SearchAction",
		    	"target" : "<?php echo esc_url( home_url() ); ?>/?s={search_term}",
		    	"query-input": "required name=search_term"
		    }
		}
		</script>

	<?php }
}

?>