<?php
// Header menu walker
if ( ! class_exists( 'Lsvr_Pressville_Header_Menu_Walker' ) ) {
    class Lsvr_Pressville_Header_Menu_Walker extends Walker_Nav_Menu {

        function start_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

        	<ul class="header-menu-primary__submenu sub-menu header-menu-primary__submenu--level-<?php echo esc_attr( $depth ); ?>">

            <?php $output .= ob_get_clean();

        }

        function end_lvl( &$output, $depth = 0, $args = [] ) {
            ob_start(); ?>

        	</ul>

            <?php $output .= ob_get_clean();
        }

        function start_el( &$output, $item, $depth = 0, $args = [], $id = 0 ) {
        	ob_start(); ?>

            <?php if ( 0 === $depth && ! empty( $item->classes ) && in_array( 'lsvr-megamenu', $item->classes ) ) {
                $item->classes[] = 'header-menu-primary__item--megamenu';
            } elseif ( 0 === $depth ) {
                $item->classes[] = 'header-menu-primary__item--dropdown';
            } ?>

        	<li class="header-menu-primary__item header-menu-primary__item--level-<?php echo esc_attr( $depth ); ?> <?php echo ! empty( $item->classes ) ? esc_attr( trim( implode( ' ', $item->classes ) ) ) : ''; ?>">

                <a href="<?php echo esc_url( $item->url ); ?>"
                	class="header-menu-primary__item-link header-menu-primary__item-link--level-<?php echo esc_attr( $depth ); ?>"
                	<?php echo ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : ''; ?>><?php echo esc_html( $item->title ); ?></a>

            <?php if ( 0 === $depth && ! empty( $item->classes ) && in_array( 'lsvr-megamenu', $item->classes ) ) : ?>
            	<div class="header-menu-primary__megamenu header-menu-primary__megamenu--4-columns">
            		<div class="lsvr-container">
            <?php elseif ( 0 === $depth ) : ?>
                <div class="header-menu-primary__dropdown">
    		<?php endif; ?>

            <?php $output .= ob_get_clean();
        }

        function end_el( &$output, $item, $depth = 0, $args = [] ) {
            ob_start(); ?>

            <?php if ( 0 === $depth && ! empty( $item->classes ) && in_array( 'lsvr-megamenu', $item->classes ) ) : ?>
            		</div>
            	</div>
            <?php elseif ( 0 === $depth ) : ?>
                </div>
    		<?php endif; ?>

            </li>

            <?php $output .= ob_get_clean();

        }

    }
}