<?php

/**
 * GENERAL
 */

	// Get languages
	if ( ! function_exists( 'lsvr_pressville_get_languages' ) ) {
		function lsvr_pressville_get_languages() {

			$languages = array();

			// WPML Generated
			if ( 'wpml' == get_theme_mod( 'language_switcher', 'disable' ) ) {

				$wpml_languages = apply_filters( 'wpml_active_languages', false, 'skip_missing=0&orderby=id&order=desc' );

				if ( is_array( $wpml_languages ) && count( $wpml_languages ) > 1 ) {
					foreach ( $wpml_languages as $lang ) {

						$language = array();
						$language['label'] = ! empty( $lang['language_code'] ) ? $lang['language_code'] : '';
						$language['url'] = ! empty( $lang['url'] ) ? $lang['url'] : '';
						$language['active'] = isset( $lang['active'] ) && true === (bool) $lang['active'] ? true : false;
						array_push( $languages, $language );

					}
				}

			}

			// Custom links
			elseif ( 'custom' == get_theme_mod( 'language_switcher', 'disable' ) ) {

				for ( $i = 1; $i <=4; $i++) {
					if ( ! empty( get_theme_mod( 'language_custom' . $i . '_label', '' ) ) &&
						! empty( get_theme_mod( 'language_custom' . $i . '_url', '' ) ) ) {

						$language = array();
						$language['label'] = get_theme_mod( 'language_custom' . $i . '_label', '' );
						$language['url'] = get_theme_mod( 'language_custom' . $i . '_url', '' );
						if ( ! empty( get_theme_mod( 'language_custom' . $i . '_code', '' ) ) &&
							get_locale() === get_theme_mod( 'language_custom' . $i . '_code', '' ) ) {

							$language['active'] = true;

						} else {
							$language['active'] = false;
						}

						array_push( $languages, $language );

					}
				}

			}

			return ! empty( $languages ) ? $languages : false;

		}
	}

	// Get active language
	if ( ! function_exists( 'lsvr_pressville_get_active_language' ) ) {
		function lsvr_pressville_get_active_language() {

			$languages = lsvr_pressville_get_languages();
			if ( ! empty( $languages ) ) {
				foreach ( $languages as $language ) {
					if ( ! empty( $language['active'] ) ) {
						$active_language = $language;
					}
				}
				$active_language = empty( $active_language ) ? reset( $languages ) : $active_language;
			}

			return ! empty( $active_language ) ? $active_language : false;

		}
	}

	// Has languages
	if ( ! function_exists( 'lsvr_pressville_has_languages' ) ) {
		function lsvr_pressville_has_languages() {

			$languages = lsvr_pressville_get_languages();
			return ! empty( $languages ) ? true : false;

		}
	}

	// Get breadcrumbs
	if ( ! function_exists( 'lsvr_pressville_get_breadcrumbs' ) ) {
		function lsvr_pressville_get_breadcrumbs() {

			global $wp_query, $post;
			$breadcrumbs = [];

			// Home link
			$breadcrumbs[] = array(
				'url' => esc_url( home_url( '/' ) ),
				'label' => esc_html__( 'Home', 'pressville' ),
			);

			// Blog root for blog pages
			if ( get_option( 'page_for_posts' ) ) {
				$blog_root = array(
					'url' => get_permalink( get_option( 'page_for_posts' ) ),
					'label' => get_the_title( get_option( 'page_for_posts' ) ),
				);
			}
			else {
				$blog_root = array(
					'url' => esc_url( home_url( '/' ) ),
					'label' => esc_html__( 'News', 'pressville' ),
				);
			}

			// Blog
			if ( is_tag() || is_day() || is_month() || is_year() || is_author() || is_singular( 'post' ) ) {
				array_push( $breadcrumbs, $blog_root );
			}

			// Blog category
			else if ( is_category() ) {
				$breadcrumbs[] = $blog_root;
				$current_term = $wp_query->queried_object;
				$current_term_id = $current_term->term_id;
				$parent_ids = lsvr_pressville_get_term_parents( $current_term_id, 'category' );
				if ( ! empty( $parent_ids ) ) {
					foreach( $parent_ids as $parent_id ){
						$parent = get_term( $parent_id, 'category' );
						$breadcrumbs[] = array(
							'url' => get_term_link( $parent, 'category' ),
							'label' => $parent->name,
						);
					}
				}
			}

			// Regular page
			else if ( is_page() ) {
				$parent_id = $post->post_parent;
				$parents_arr = [];
				while ( $parent_id ) {
					$page = get_page( $parent_id );
					$parents_arr[] = array(
						'url' => get_permalink( $page->ID ),
						'label' => get_the_title( $page->ID ),
					);
					$parent_id = $page->post_parent;
				}
				$parents_arr = array_reverse( $parents_arr );
				foreach ( $parents_arr as $parent ) {
					$breadcrumbs[] = $parent;
				}
			}

			// Apply filters
			if ( ! empty( apply_filters( 'lsvr_pressville_add_to_breadcrumbs', array() ) ) ) {
				$breadcrumbs = array_merge( $breadcrumbs, apply_filters( 'lsvr_pressville_add_to_breadcrumbs', array() ) );
			}

			// Taxonomy
			if ( is_tax() ) {

				$taxonomy = get_query_var( 'taxonomy' );
				$term_parents = lsvr_pressville_get_term_parents( get_queried_object_id(), $taxonomy );
				if ( ! empty( $term_parents ) ) {
					foreach( $term_parents as $term_id ) {

						$term = get_term_by( 'id', $term_id, $taxonomy );
						$breadcrumbs[] = array(
							'url' => get_term_link( $term_id, $taxonomy ),
							'label' => $term->name,
						);

					}
				}
			}

			// Return breadcrumbs
			return $breadcrumbs;

		}
	}

	// Get menus
	if ( ! function_exists( 'lsvr_pressville_get_menus' ) ) {
		function lsvr_pressville_get_menus() {

			$return = array();

			$menus = wp_get_nav_menus();
			if ( ! empty( $menus ) ) {
				foreach ( $menus as $menu ) {
					if ( ! empty( $menu->term_id ) && ! empty( $menu->name ) ) {
						$return[ $menu->term_id ] = $menu->name;
					}
				}
			}

			return $return;

		}
	}

	// Get custom sidebars
	if ( ! function_exists( 'lsvr_pressville_get_custom_sidebars' ) ) {
		function lsvr_pressville_get_custom_sidebars() {

			$return = array();

			$custom_sidebars = get_theme_mod( 'custom_sidebars' );
			if ( ! empty( $custom_sidebars ) && '{' === substr( $custom_sidebars, 0, 1 ) ) {

				$custom_sidebars = (array) json_decode( $custom_sidebars );
				if ( ! empty( $custom_sidebars['sidebars'] ) ) {
					$custom_sidebars = $custom_sidebars['sidebars'];
					foreach ( $custom_sidebars as $sidebar ) {
						$sidebar = (array) $sidebar;
						if ( ! empty( $sidebar['id'] ) ) {

							$sidebar_label = ! empty( $sidebar['label'] ) ? $sidebar['label'] : sprintf( esc_html__( 'Custom Sidebar %d', 'pressville' ), (int) $sidebar['id'] );
							$return[ 'lsvr-pressville-custom-sidebar-' . $sidebar['id'] ] = $sidebar_label;

						}
					}
				}

			}

			return $return;

		}
	}

	// Get sidebars
	if ( ! function_exists( 'lsvr_pressville_get_sidebars' ) ) {
		function lsvr_pressville_get_sidebars() {

			$sidebar_list = array( 'lsvr-pressville-default-sidebar' => esc_html__( 'Default Sidebar', 'pressville'  ) );
			$custom_sidebars = lsvr_pressville_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) ) {
				$sidebar_list = array_merge( $sidebar_list, $custom_sidebars );
			}

            return $sidebar_list;

		}
	}

	// Get page sidebar position
	if ( ! function_exists( 'lsvr_pressville_get_page_sidebar_position' ) ) {
		function lsvr_pressville_get_page_sidebar_position() {

			// Is blog single
			if ( is_singular( 'post' ) ) {
				return get_theme_mod( 'blog_single_sidebar_position', 'right' );
			}

			// Is blog archive
			else if ( lsvr_pressville_is_blog() ) {
				return get_theme_mod( 'blog_archive_sidebar_position', 'right' );
			}

			// Filter for other CPT
			else if ( ! empty( apply_filters( 'lsvr_pressville_sidebar_position', 'disable' ) ) ) {
				return apply_filters( 'lsvr_pressville_sidebar_position', 'disable' );
			}

			// Default
			else {
				return 'disable';
			}

		}
	}

	// Get page sidebar ID
	if ( ! function_exists( 'lsvr_pressville_get_page_sidebar_id' ) ) {
		function lsvr_pressville_get_page_sidebar_id( $page_id = false ) {

			// Page
			if ( is_page() ) {
				$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
				$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_pressville_page_sidebar', true ) : false;

				if ( ! empty( $sidebar_id ) ) {
					$sidebar_id = $sidebar_id;
				} else {
					$sidebar_id = 'lsvr-pressville-default-sidebar';
				}
			}

			// Is blog single
			else if ( is_singular( 'post' ) ) {
				$sidebar_id = get_theme_mod( 'blog_single_sidebar_id' );
			}

			// Is blog archive
			else if ( lsvr_pressville_is_blog() ) {
				$sidebar_id = get_theme_mod( 'blog_archive_sidebar_id', 'lsvr-pressville-default-sidebar' );
			}

			// Filter
			else if ( ! empty( apply_filters( 'lsvr_pressville_sidebar_id', 'lsvr-pressville-default-sidebar' ) ) ) {
				$sidebar_id = apply_filters( 'lsvr_pressville_sidebar_id', 'lsvr-pressville-default-sidebar' );
			}

			// Default
			else {
				$sidebar_id = 'lsvr-pressville-default-sidebar';
			}

			$sidebar_id = ! empty( $sidebar_id ) ? $sidebar_id : 'lsvr-pressville-default-sidebar';

			return $sidebar_id;

		}
	}

	// Has page sidebar
	if ( ! function_exists( 'lsvr_pressville_has_page_sidebar' ) ) {
		function lsvr_pressville_has_page_sidebar() {

			$sidebar_position = lsvr_pressville_get_page_sidebar_position();
			return $sidebar_position !== 'disable' ? true : false;

		}
	}

	// Get image URL
	if ( ! function_exists( 'lsvr_pressville_get_image_url' ) ) {
		function lsvr_pressville_get_image_url( $image_id, $size = 'full' ) {

			$image_src = wp_get_attachment_image_src( $image_id, $size );
			return ! empty( $image_src[0] ) ? $image_src[0] : '';

		}
	}

	// Get image width
	if ( ! function_exists( 'lsvr_pressville_get_image_width' ) ) {
		function lsvr_pressville_get_image_width( $image_id, $size = 'full' ) {

			$image_src = wp_get_attachment_image_src( $image_id, $size );
			return ! empty( $image_src[1] ) ? $image_src[1] : '';

		}
	}

	// Get image height
	if ( ! function_exists( 'lsvr_pressville_get_image_height' ) ) {
		function lsvr_pressville_get_image_height( $image_id, $size = 'full' ) {

			$image_src = wp_get_attachment_image_src( $image_id, $size );
			return ! empty( $image_src[2] ) ? $image_src[2] : '';

		}
	}

	// Get image alt
	if ( ! function_exists( 'lsvr_pressville_get_image_alt' ) ) {
		function lsvr_pressville_get_image_alt( $image_id ) {

			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
			return ! empty( $image_alt ) ? $image_alt : '';

		}
	}

	// Get social links
	if ( ! function_exists( 'lsvr_pressville_get_social_links' ) ) {
		function lsvr_pressville_get_social_links() {

			$social_links = array();

			$saved_social_links = ! empty( get_theme_mod( 'social_links', '' ) ) ? (array) @json_decode( get_theme_mod( 'social_links', '' ) ) : '';
			if ( ! empty( $saved_social_links ) ) {
				foreach ( $saved_social_links as $saved_link_id => $saved_link_info ) {
					$social_links[ $saved_link_id ] = (array) $saved_link_info;
				}
			}

			// Get custom links
			$custom_social_links = apply_filters( 'lsvr_pressville_add_custom_social_links', '' );
			if ( ! empty( $custom_social_links ) ) {
				$social_links = array_merge( $social_links, $custom_social_links );
			}

			return $social_links;

		}
	}

	// Get tax term description
	if ( ! function_exists( 'lsvr_pressville_get_tax_term_description' ) ) {
		function lsvr_pressville_get_tax_term_description( $term_id, $taxonomy ) {

			$description = term_description( $term_id, $taxonomy );
			if ( ! empty( $description ) ) {
				return $description;
			}
			else {
				return '';
			}

		}
	}

	// Has tax term description
	if ( ! function_exists( 'lsvr_pressville_has_tax_term_description' ) ) {
		function lsvr_pressville_has_tax_term_description( $term_id, $taxonomy ) {

			$description = lsvr_pressville_get_tax_term_description( $term_id, $taxonomy );
			if ( ! empty( $description ) ) {
				return true;
			}
			else {
				return false;
			}

		}
	}

	// Get parents of taxonomy term
	if ( ! function_exists( 'lsvr_pressville_get_term_parents' ) ) {
		function lsvr_pressville_get_term_parents( $term_id, $taxonomy, $max_limit = 5 ) {

			$term = get_term( $term_id, $taxonomy );
			if ( 0 !== $term->parent ) {

				$parents_arr = [];
				$counter = 0;
				$parent_id = $term->parent;

				while ( 0 !== $parent_id && $counter < $max_limit ) {
					array_unshift( $parents_arr, $parent_id );
					$parent = get_term( $parent_id, $taxonomy );
					$parent_id = $parent->parent;
					$counter++;
				}
				return $parents_arr;

			}
			else {
				return false;
			}

		}
	}

	// Post type icon class
	if ( ! function_exists( 'lsvr_pressville_get_post_type_icon_class' ) ) {
		function lsvr_pressville_get_post_type_icon_class( $post_type ) {

			// Default icons
			$default_post_type_icons = array(
				'post' => 'icon-post-pin',
				'page' => 'icon-file-default',
				'lsvr_notice' => 'icon-post-pin',
				'lsvr_listing' => 'icon-location-pin',
				'lsvr_event' => 'icon-calendar',
				'lsvr_gallery' => 'icon-file-landscape-image',
				'lsvr_document' => 'icon-file-2',
				'lsvr_person' => 'icon-user',
				'forum' => 'icon-forum-comment',
				'topic' => 'icon-forum-comment',
			);

			// Make icons list editable via filters
			$post_type_icons = array_merge( $default_post_type_icons, apply_filters( 'lsvr_pressville_post_type_icons', array() ) );

			// Return icon
			if ( ! empty( $post_type_icons[ $post_type ] ) ) {
				return $post_type_icons[ $post_type ];
			}
			else {
				return apply_filters( 'lsvr_pressville_post_type_icon_default', 'icon-file-default' );
			}

		}
	}

	// Get post terms names
	if ( ! function_exists( 'lsvr_pressville_get_post_term_names' ) ) {
		function lsvr_pressville_get_post_term_names( $post_id, $taxonomy ) {

			$terms = wp_get_post_terms( $post_id, $taxonomy );
			$term_names = array();

			if ( ! empty( $terms ) && is_array( $terms ) ) {
				foreach ( $terms as $tag ) {
					array_push( $term_names, $tag->name );
				}
			}
			return ! empty( $term_names ) ? $term_names : false;

		}
	}

	// Has post terms
	if ( ! function_exists( 'lsvr_pressville_has_post_terms' ) ) {
		function lsvr_pressville_has_post_terms( $post_id, $taxonomy ) {

			$terms = wp_get_post_terms( $post_id, $taxonomy );
			return ! empty( $terms ) ? true : false;

		}
	}

	// Day name
	if ( ! function_exists( 'lsvr_pressville_get_day_name' ) ) {
		function lsvr_pressville_get_day_name( $day, $format = 'l' ) {

			return date_i18n( $format, strtotime( $day ) );

		}
	}

	// Convert hex color to RGB
	if ( ! function_exists( 'lsvr_pressville_hex2rgb' ) ) {
		function lsvr_pressville_hex2rgb( $hex ) {

			$hex = ltrim( $hex, '#' );
			$rgb = array();
			if ( 6 === strlen( $hex ) ) {
				array_push( $rgb, substr( $hex, 0, 2 ) );
				array_push( $rgb, substr( $hex, 2, 2 ) );
				array_push( $rgb, substr( $hex, 4, 2 ) );
				return array_map( 'hexdec', $rgb );
			}

		}
	}

	// Custom colors CSS
	if ( ! function_exists( 'lsvr_pressville_get_custom_colors_css' ) ) {
		function lsvr_pressville_get_custom_colors_css() {

			$custom_colors = array(
				'accent1' => get_theme_mod( 'colors_custom_accent1', '#cd4335' ),
				'accent2' => get_theme_mod( 'colors_custom_accent2', '#2d93c5' ),
				'body-link' => get_theme_mod( 'colors_custom_link', '#2d93c5' ),
				'body-font' => get_theme_mod( 'colors_custom_text', '#545e69' ),
			);

			$theme_version = wp_get_theme( 'pressville' );
			$theme_version = $theme_version->Version;

			// Check if CSS with same colors doesn't exists in DB
			$saved_colors = get_option( 'lsvr_pressville_custom_colors' );
			$saved_css = get_option( 'lsvr_pressville_custom_colors_css' );
			$saved_version = get_option( 'lsvr_pressville_custom_colors_version' );

			if ( ! empty( $saved_colors ) && ! empty( $saved_css ) && $saved_colors === $custom_colors && $theme_version === $saved_version ) {
				return $saved_css;
			}

			// If there is no CSS for selected colors, generate it
			else {

				$css_template = lsvr_pressville_get_custom_colors_template();

				if ( ! empty( $css_template ) ) {

					// Get RGB accents
					$accent1_rgb = implode( ', ', lsvr_pressville_hex2rgb( $custom_colors[ 'accent1' ] ) );
					$accent2_rgb = implode( ', ', lsvr_pressville_hex2rgb( $custom_colors[ 'accent2' ] ) );

					// Replace RGBA first
					$custom_css = str_replace(
						array( 'rgba( $accent1', 'rgba( $accent2' ),
						array( 'rgba( ' . $accent1_rgb, 'rgba( ' . $accent2_rgb ),
						$css_template
					);

					// Replace the rest
					$custom_css = str_replace(
						array( '$accent1', '$accent2', '$body-link', '$body-font', "\r", "\n", "\t" ),
						array( $custom_colors[ 'accent1' ], $custom_colors[ 'accent2' ], $custom_colors[ 'body-link' ], $custom_colors[ 'body-font' ], '', '', '' ),
						$custom_css
					);

					// Save colors and CSS to DB
					update_option( 'lsvr_pressville_custom_colors', $custom_colors );
					update_option( 'lsvr_pressville_custom_colors_css', $custom_css );
					update_option( 'lsvr_pressville_custom_colors_version', $theme_version );

					return $custom_css;

				} else {
					return '';
				}

			}

		}
	}


/**
 * HEADER
 */

	// Has header site title
	if ( ! function_exists( 'lsvr_pressville_has_header_site_title' ) ) {
		function lsvr_pressville_has_header_site_title() {

			$site_title = get_bloginfo( 'name' );
			return ! empty( $site_title ) && true === get_theme_mod( 'header_site_title_enable', true ) ? true : false;

		}
	}

	// Has header tagline
	if ( ! function_exists( 'lsvr_pressville_has_header_description' ) ) {
		function lsvr_pressville_has_header_description() {

			$site_description = get_bloginfo( 'description' );

			// Enable via URL
			if ( ! empty( $site_description ) && ! empty( $_GET['lsvr-title-description'] ) && 'true' === $_GET['lsvr-title-description'] ) {
				return true;
			}

			if ( ! empty( $site_description ) && true === get_theme_mod( 'header_site_description_enable', true ) ) {

				// Front page only
				if ( true === get_theme_mod( 'header_site_description_frontpage_only_enable', true ) && is_front_page() ) {
					return true;
				}

				// Not front page
				else if ( true === get_theme_mod( 'header_site_description_frontpage_only_enable', true ) ) {
					return false;
				}

				// Display everywhere
				else {
					return true;
				}

			} else {
				return false;
			}

		}
	}


/**
 * FOOTER
 */

	// Footer widgets before widget
	if ( ! function_exists( 'lsvr_pressville_get_footer_widgets_before_widget' ) ) {
		function lsvr_pressville_get_footer_widgets_before_widget() {

			$columns = (int) get_theme_mod( 'footer_widgets_columns', 4 );

			// Wider first col
			if ( 4 === $columns && true === get_theme_mod( 'footer_widgets_wider_col_enable', false ) ) {

				$span = 2;
				$span_lg = $columns >= 2 ? 6 : 12;

			}

			// Equal cols
			else {
				$span = 12 / $columns;
				$span_lg = $columns >= 2 ? 6 : 12;
			}

			$return = '<div class="footer-widgets__column lsvr-grid__col lsvr-grid__col--span-' . esc_attr( $span );
			$return .= ' lsvr-grid__col--lg lsvr-grid__col--lg-span-' . esc_attr( $span_lg ) . '">';
			$return .= '<div class="footer-widgets__column-inner"><div id="%1$s" class="footer-widget %2$s"><div class="footer-widget__inner">';

			return $return;

		}
	}

	// Footer widgets after widget
	if ( ! function_exists( 'lsvr_pressville_get_footer_widgets_after_widget' ) ) {
		function lsvr_pressville_get_footer_widgets_after_widget() {

			return '</div></div></div></div>';

		}
	}


/**
 * CORE
 */

	// Has narrow content
	if ( ! function_exists( 'lsvr_pressville_has_narrow_content' ) ) {
		function lsvr_pressville_has_narrow_content() {

			if ( false === lsvr_pressville_has_page_sidebar() && (
				is_singular( 'post' )
				|| ( ( is_category() || is_home() ) && 'default' === get_theme_mod( 'blog_archive_layout', 'default' ) )
				|| is_singular( 'lsvr_listing' )
				|| is_singular( 'lsvr_event' )
					|| ( ( is_post_type_archive( 'lsvr_event' )
						|| is_tax( 'lsvr_event_cat' )
						|| is_tax( 'lsvr_event_lcoation' ) ||
						is_tax( 'lsvr_event_tag' ) )
					&& 'timeline' === get_theme_mod( 'lsvr_event_archive_layout', 'default' ) )
				|| is_singular( 'lsvr_person' )
				|| is_singular( 'lsvr_document' ) || is_post_type_archive( 'lsvr_document' )
				)) {
				return true;
			} else {
				return false;
			}

		}
	}


/**
 * BLOG
 */

	// Is blog page
	if ( ! function_exists( 'lsvr_pressville_is_blog' ) ) {
		function lsvr_pressville_is_blog() {

			if ( is_home() || is_post_type_archive( 'post' ) || is_category() || is_singular( 'post' ) ||
				is_tag() || is_day() || is_month() || is_year() || is_author() ) {
				return true;
			} else {
				return false;
			}

		}
	}

	// Get blog archive layout
	if ( ! function_exists( 'lsvr_pressville_get_blog_archive_layout' ) ) {
		function lsvr_pressville_get_blog_archive_layout() {

			$path_prefix = 'template-parts/blog/archive-layout-';

			// Get layout from Customizer
			if ( ! empty( locate_template( $path_prefix . get_theme_mod( 'blog_archive_layout', 'default' ) . '.php' ) ) ) {
				return get_theme_mod( 'blog_archive_layout', 'default' );
			}

			// Default layout
			else {
				return 'default';
			}

		}
	}

	// Get blog archive title
	if ( ! function_exists( 'lsvr_pressville_get_blog_archive_title' ) ) {
		function lsvr_pressville_get_blog_archive_title() {

			if ( ! is_home() && ! is_post_type_archive( 'post' ) ) {
				return get_the_archive_title();
			} else if ( get_option( 'page_for_posts' ) ) {
				return esc_html( get_the_title( get_option( 'page_for_posts' ) ) );
			} else {
				return esc_html__( 'News', 'pressville' );
			}

		}
	}

?>