<?php

/**
 * GENERAL
 */

	// Alert message
	if ( ! function_exists( 'lsvr_pressville_the_alert_message' ) ) {
		function lsvr_pressville_the_alert_message( $message ) {

			echo '<p class="c-alert-message">' . esc_html( $message ) . '</p>';

		}
	}

	// Post archive categories
	if ( ! function_exists( 'lsvr_pressville_the_post_archive_categories' ) ) {
		function lsvr_pressville_the_post_archive_categories( $post_type, $taxonomy ) {

			$terms = get_terms( $taxonomy );
			if ( ! empty( $terms ) ) { ?>

				<!-- POST ARCHIVE CATEGORIES : begin -->
				<div class="post-archive-categories">
					<h6 class="screen-reader-text"><?php esc_html_e( 'Categories:', 'pressville' ); ?></h6>
					<ul class="post-archive-categories__list">

						<li class="post-archive-categories__item">
							<?php if ( is_tax( $taxonomy ) ) : ?>
								<a href="<?php echo esc_url( get_post_type_archive_link( $post_type ) ); ?>" class="post-archive-categories__item-link"><?php esc_html_e( 'All', 'pressville' ); ?></a>
							<?php else : ?>
								<strong><?php esc_html_e( 'All', 'pressville' ); ?></strong>
							<?php endif; ?>
						</li>

						<?php foreach ( $terms as $term ) : ?>
							<li class="post-archive-categories__item">
								<?php if ( get_queried_object_id() === $term->term_id ) : ?>
									<?php echo esc_html( $term->name ); ?>
								<?php else : ?>
									<a href="<?php echo esc_url( get_term_link( $term->term_id, $taxonomy ) ); ?>" class="post-archive-categories__item-link"><?php echo esc_html( $term->name ); ?></a>
								<?php endif; ?>
							</li>
						<?php endforeach; ?>

					</ul>
				</div>
				<!-- POST ARCHIVE CATEGORIES : end -->

			<?php }

		}
	}

	// Post categories
	if ( ! function_exists( 'lsvr_pressville_the_post_categories' ) ) {
		function lsvr_pressville_the_post_categories( $post_id, $taxonomy, $template = '%s', $separator = ', ', $limit = 0 ) {

			$terms = wp_get_post_terms( $post_id, $taxonomy );
			$terms_parsed = array();
			if ( ! empty( $terms ) ) {
				foreach ( $terms as $term ) {
					array_push( $terms_parsed, '<a href="' . esc_url( get_term_link( $term->term_id, $taxonomy ) ) . '" class="post__category-link">' . esc_html( $term->name ) . '</a>' );
				}
				if ( $limit > 0 && count( $terms_parsed ) > $limit ) {
					$terms_parsed = array_slice( $terms_parsed, 0, $limit );
				}
			}

			if ( ! empty( $terms_parsed ) ) { ?>

				<span class="post__categories">
					<?php echo sprintf( $template, implode( ', ', $terms_parsed ) ); ?>
				</span>

			<?php }

		}
	}

	// Post tags
	if ( ! function_exists( 'lsvr_pressville_the_post_tags' ) ) {
		function lsvr_pressville_the_post_tags( $post_id, $taxonomy ) {

			$terms = wp_get_post_terms( $post_id, $taxonomy );

			if ( ! empty( $terms ) ) { ?>

				<!-- POST TAGS : begin -->
				<ul class="post__tags-list">
					<?php foreach ( $terms as $term ) : ?>

						<li class="post__tag-item">
							<a href="<?php echo esc_url( get_term_link( $term->term_id, $taxonomy ) ); ?>"
								class="post__tag-item-link">
								<?php echo esc_html( $term->name ); ?>
							</a>
						</li>

					<?php endforeach; ?>
				</ul>
				<!-- POST TAGS : end -->

			<?php }

		}
	}

	// Tax term description
	if ( ! function_exists( 'lsvr_pressville_the_tax_term_description' ) ) {
		function lsvr_pressville_the_tax_term_description() {

			if ( is_tax() && lsvr_pressville_has_tax_term_description( get_queried_object_id(), get_query_var( 'taxonomy' ) ) ) : ?>

				<!-- POST ARCHIVE DESCRIPTION : begin -->
				<div class="post-archive-description">
					<?php echo wp_kses( lsvr_pressville_get_tax_term_description( get_queried_object_id(), get_query_var( 'taxonomy' ) ), array(
						'p' => array(),
					) ); ?>
				</div>
				<!-- POST ARCHIVE DESCRIPTION : end -->

			<?php endif;

		}
	}


/**
 * HEADER
 */

	// Header titlebar class
	if ( ! function_exists( 'lsvr_pressville_the_header_titlebar_class' ) ) {
		function lsvr_pressville_the_header_titlebar_class() {

			$classes = array( 'header-titlebar' );

			// Large header
			if ( is_front_page() || ( ! empty( $_GET['lsvr-large-header'] ) && 'true' === $_GET['lsvr-large-header'] ) ) {
				array_push( $classes, 'header-titlebar--large' );
			}

			// Has topbar
			if ( has_nav_menu( 'lsvr-pressville-header-menu-secondary' ) || lsvr_pressville_has_languages() ) {
				array_push( $classes, 'header-titlebar--has-topbar' );
			}

			// Has logo
			if ( has_custom_logo() ) {
				array_push( $classes, 'header-titlebar--has-logo' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . implode( ' ', $classes ) . '"';
			}

		}
	}

	// Header background
	if ( ! function_exists( 'lsvr_pressville_the_header_titlebar_background' ) ) {
		function lsvr_pressville_the_header_titlebar_background() {

			$images = array();

			// Get background type
			$background_type = get_theme_mod( 'header_background_type', 'single' );

			// Get align
			$titlebar_background_class_arr = array( 'header-titlebar__background' );
			array_push( $titlebar_background_class_arr, 'header-titlebar__background--align-' . get_theme_mod( 'header_background_vertical_align', 'top' ) );
			array_push( $titlebar_background_class_arr, 'header-titlebar__background--' . get_theme_mod( 'header_background_type', 'single' ) );
 			if ( ( is_front_page() && true === get_theme_mod( 'header_background_animated_enable', false ) ) ||
 				( ! empty( $_GET['lsvr-animated-header'] ) && 'true' === $_GET['lsvr-animated-header'] ) ) {
 				array_push( $titlebar_background_class_arr, 'header-titlebar__background--animated' );
 			}

 			// If is page and has featured image, use it instead of image defined via Customizer
 			if ( is_page() && has_post_thumbnail( get_the_ID() ) ) {
				array_push( $images, get_the_post_thumbnail_url( get_the_ID() ) );
 			}

 			// Get image from Customizer
 			else {

				// Get default image
				$default_image_url = get_theme_mod( 'header_background_image', '' );
				if ( ! empty( $default_image_url )  ) {
					array_push( $images, $default_image_url );
				}

				// Get additional images
				if ( 'slideshow' === $background_type || 'random' === $background_type ||
					( 'slideshow-home' === $background_type && is_front_page() ) ) {

					for ( $i = 2; $i <= 5; $i++ ) {

						$image_url = get_theme_mod( 'header_background_image_' . $i, '' );
						if ( ! empty( $image_url )  ) {
							array_push( $images, $image_url );
						}

					}

				}

			}

			// Create background element
			if ( ! empty( $images ) ) { ?>

				<div class="<?php echo implode( ' ', $titlebar_background_class_arr ); ?>"
					data-slideshow-speed="<?php echo esc_attr( get_theme_mod( 'header_background_slideshow_speed', 10 ) ); ?>">

					<?php // Pick random image
					if ( 'random' === $background_type ) : $random_index = rand( 0, count( $images ) - 1 ); ?>

						<div class="header-titlebar__background-image header-titlebar__background-image--default"
							style="background-image: url( '<?php echo ! empty( $images[ $random_index ] ) ? esc_url( $images[ $random_index ] ) : esc_url( reset( $images ) ); ?>' );"></div>

					<?php // List all images
					else : ?>

						<?php foreach ( $images as $image_url ) : ?>

							<div class="header-titlebar__background-image<?php if ( $image_url === reset( $images ) ) { echo ' header-titlebar__background-image--default'; } ?>"
								style="background-image: url('<?php echo esc_url( $image_url ); ?>'); "></div>

						<?php endforeach; ?>

					<?php endif; ?>

				</div>

			<?php }

		}
	}

	// Header titlebar overlay
	if ( ! function_exists( 'lsvr_pressville_the_header_titlebar_overlay' ) ) {
		function lsvr_pressville_the_header_titlebar_overlay() {
			$overlay_opacity = (int) get_theme_mod( 'header_background_overlay_opacity', 80 ) / 100;
			$opacity_css = 'opacity: ' . $overlay_opacity . ';'; // For modern browsers
			$opacity_filter_css = 'filter: alpha(opacity=' . $overlay_opacity . ');'; // For IE
			echo '<span class="header-titlebar__overlay" style="' . esc_attr( $opacity_css . $opacity_filter_css ) . '"></span>';
		}
	}

	// Header languages
	if ( ! function_exists( 'lsvr_pressville_the_header_languages' ) ) {
		function lsvr_pressville_the_header_languages() {

			$languages = lsvr_pressville_get_languages();

			if ( ! empty( $languages ) ) { ?>

				<!-- HEADER LANGUAGES : begin -->
				<div class="header-languages">
					<span class="screen-reader-text"><?php esc_html_e( 'Choose language:', 'pressville' ); ?></span>
					<ul class="header-languages__list">

						<?php foreach ( $languages as $language ) : ?>
							<?php if ( ! empty( $language['label'] ) && ! empty( $language['url'] ) ) : ?>

								<li class="header-languages__item<?php if ( ! empty( $language['active'] ) ) { echo ' header-languages__item--active'; } ?>">
									<a href="<?php echo esc_url( $language['url'] ); ?>" class="header-languages__item-link"><?php echo esc_html( $language['label'] ); ?></a>
								</li>

							<?php endif; ?>
						<?php endforeach; ?>

					</ul>
				</div>
				<!-- HEADER LANGUAGES : end -->

			<?php }

		}
	}

	// Header navbar class
	if ( ! function_exists( 'lsvr_pressville_the_header_navbar_class' ) ) {
		function lsvr_pressville_the_header_navbar_class() {

			$classes = array( 'header-navbar' );

			// Sticky navbar
			if ( true === get_theme_mod( 'sticky_navbar_enable', true ) ) {
				array_push( $classes, 'header-navbar--is-sticky' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . implode( ' ', $classes ) . '"';
			}

		}
	}

	// Header search
	if ( ! function_exists( 'lsvr_pressville_the_header_search' ) ) {
		function lsvr_pressville_the_header_search() {

			if ( true === get_theme_mod( 'header_search_enable', true ) ) { ?>

				<!-- HEADER SEARCH WRAPPER : begin -->
				<div class="header-search__wrapper">

					<!-- HEADER SEARCH TOGGLE : begin -->
					<button type="button" class="header-search__toggle">
						<i class="header-search__toggle-icon"></i>
					</button>
					<!-- HEADER SEARCH TOGGLE : end -->

					<!-- HEADER SEARCH : begin -->
					<div class="header-search<?php if ( true === get_theme_mod( 'header_search_ajax_enable', true ) ) { echo ' header-search--ajaxed'; } ?>">
						<div class="header-search__inner">

							<!-- SEARCH FORM : begin -->
							<form class="header-search__form"
								action="<?php echo esc_url( home_url( '/' ) ); ?>"
								method="get">

								<!-- SEARCH OPTIONS : begin -->
								<div class="header-search__options">

									<label for="header-search-input" class="header-search__input-label"><?php esc_html_e( 'Search:', 'pressville' ); ?></label>

									<!-- INPUT WRAPPER : begin -->
									<div class="header-search__input-wrapper">

										<input class="header-search__input" type="text" name="s" autocomplete="off"
											id="header-search-input"
											placeholder="<?php echo get_theme_mod( 'header_search_input_placeholder', esc_html__( 'Search this site', 'pressville' ) ); ?>"
											value="<?php echo esc_attr( get_search_query() ); ?>">
										<button class="header-search__submit" type="submit" title="<?php esc_html_e( 'Search', 'pressville' ); ?>">
											<i class="header-search__submit-icon"></i>
										</button>
										<div class="c-spinner header-search__spinner"></div>

									</div>
									<!-- INPUT WRAPPER : end -->

									<?php if ( true === get_theme_mod( 'header_search_filter_enable', true ) ) : ?>

										<?php // Default filters
										$filters = array(
											array(
												'name' => 'post',
												'label' => esc_html__( 'posts', 'pressville' ),
											),
											array(
												'name' => 'page',
												'label' => esc_html__( 'pages', 'pressville' ),
											),
										);

										// bbPress filters
										if ( class_exists( 'bbPress' ) && post_type_exists( 'forum' ) && post_type_exists( 'topic' ) ) {
											array_push( $filters, array(
												'name' => 'forum',
												'label' => esc_html__( 'forums', 'pressville' ),
											));
											array_push( $filters, array(
												'name' => 'topic',
												'label' => esc_html__( 'topics', 'pressville' ),
											));
										}

										// Custom filters
										$custom_filters = (array) apply_filters( 'lsvr_pressville_add_header_search_filter', array() );
										$filters = array_merge( $filters, $custom_filters );

										// Active filters
										if ( isset( $_GET['lsvr-search-filter'] ) ) {
											$active_filters = (array) $_GET['lsvr-search-filter'];
										} elseif ( isset( $_GET['lsvr-search-filter-serialized'] ) ) {
											$active_filters = explode( ',', esc_attr( $_GET['lsvr-search-filter-serialized'] ) );
										} else {
											$active_filters = array();
										}

										?>

										<?php if ( ! empty( $filters ) ) : ?>

											<!-- SEARCH FILTER : begin -->
											<div class="header-search__filter">

												<h5 class="header-search__filter-title"><?php esc_html_e( 'Filter results:', 'pressville' ); ?></h5>

												<label for="header-search-filter-type-any" class="header-search__filter-label">
													<input type="checkbox" class="header-search__filter-checkbox"
														id="header-search-filter-type-any"
														name="lsvr-search-filter[]" value="any"
														<?php if ( empty( $active_filters ) || in_array( 'any', $active_filters ) ) { echo ' checked="checked"'; } ?>>
														<?php esc_html_e( 'everything', 'pressville' ); ?>
												</label>

												<?php foreach ( $filters as $filter ) : if ( ! empty( $filter['name'] ) && ! empty( $filter['label'] ) ) : ?>

													<label for="header-search-filter-type-<?php echo esc_attr( $filter['name'] ); ?>" class="header-search__filter-label">
														<input type="checkbox" class="header-search__filter-checkbox"
															id="header-search-filter-type-<?php echo esc_attr( $filter['name'] ); ?>"
															name="lsvr-search-filter[]" value="<?php echo esc_attr( $filter['name'] ); ?>"
															<?php if ( in_array( $filter['name'], $active_filters ) ) { echo ' checked="checked"'; } ?>>
															<?php echo esc_html( $filter['label'] ); ?>
													</label>

												<?php endif; endforeach; ?>


											</div>
											<!-- SEARCH FILTER : end -->

										<?php endif; ?>

									<?php endif; ?>

								</div>
								<!-- SEARCH OPTIONS : end -->

							</form>
							<!-- SEARCH FORM : end -->

							<span class="header-search__arrow"></span>

						</div>
					</div>
					<!-- HEADER SEARCH : end -->

				</div>
				<!-- HEADER SEARCH WRAPPER : end -->

			<?php }

		}
	}

	// Header languages mobile
	if ( ! function_exists( 'lsvr_pressville_the_header_languages_mobile' ) ) {
		function lsvr_pressville_the_header_languages_mobile() {

			$languages = lsvr_pressville_get_languages();
			$active_language = lsvr_pressville_get_active_language();

			if ( ! empty( $languages ) ) { ?>

				<!-- HEADER LANGUAGES MOBILE : begin -->
				<div class="header-languages-mobile">

					<div class="header-languages-mobile__inner">
						<span class="screen-reader-text"><?php esc_html_e( 'Choose language:', 'pressville' ); ?></span>
						<ul class="header-languages-mobile__list">

							<?php foreach ( $languages as $language ) : ?>
								<?php if ( ! empty( $language['label'] ) && ! empty( $language['url'] ) ) : ?>

									<li class="header-languages-mobile__item">
										<a href="<?php echo esc_url( $language['url'] ); ?>"
											class="header-languages-mobile__item-link<?php if ( ! empty( $language['active'] ) ) { echo ' header-languages-mobile__item-link--active'; } ?>"><?php echo esc_html( $language['label'] ); ?></a>
									</li>

								<?php endif; ?>
							<?php endforeach; ?>

						</ul>
					</div>

					<?php if ( ! empty( $active_language['label'] ) ) : ?>
						<button type="button" class="header-languages-mobile__toggle"><?php echo esc_html( $active_language['label'] ); ?></button>
					<?php endif; ?>

				</div>
				<!-- HEADER LANGUAGES MOBILE : end -->

			<?php }

		}
	}

	// Header mobile menu toggle
	if ( ! function_exists( 'lsvr_pressville_the_header_mobile_toggle' ) ) {
		function lsvr_pressville_the_header_mobile_toggle() {

			?>

			<button type="button" class="header-mobile-toggle">
				<?php esc_html_e( 'Menu', 'pressville' ); ?>
				<i class="header-mobile-toggle__icon"></i>
			</button>

			<?php

		}
	}



/**
 * FOOTER
 */

	// Footer background image
	if ( ! function_exists( 'lsvr_pressville_the_footer_background_image' ) ) {
		function lsvr_pressville_the_footer_background_image() {

			$image_url = get_theme_mod( 'footer_background_image', '' );
			if ( ! empty( $image_url )  ) {
				echo ' style="background-image: url( \'' . esc_url( $image_url ) . '\' );"';
			}

		}
	}

	// Footer background overlay
	if ( ! function_exists( 'lsvr_pressville_the_footer_overlay' ) ) {
		function lsvr_pressville_the_footer_overlay() {

			$overlay_opacity = (int) get_theme_mod( 'footer_background_overlay_opacity', 80 );
			$opacity_css = 'opacity: ' . $overlay_opacity / 100 . ';'; // For modern browsers
			$opacity_filter_css = 'filter: alpha(opacity=' . $overlay_opacity . ');'; // For IE
			echo '<div class="footer__overlay" style="' . esc_attr( $opacity_css . ' ' . $opacity_filter_css ) . '"></div>';

		}
	}

	// Footer widgets class
	if ( ! function_exists( 'lsvr_pressville_the_footer_widgets_class' ) ) {
		function lsvr_pressville_the_footer_widgets_class() {

			$classes = array( 'footer-widgets' );

			// Wider first col
			if ( true === get_theme_mod( 'footer_widgets_wider_col_enable', false ) ) {
				array_push( $classes, 'lsvr-grid--wider-first-col' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . esc_attr( implode( ' ', $classes ) ) . '"';
			}

		}
	}

	// Footer widgets grid class
	if ( ! function_exists( 'lsvr_pressville_the_footer_widgets_grid_class' ) ) {
		function lsvr_pressville_the_footer_widgets_grid_class() {

			$classes = array( 'lsvr-grid' );
			$columns = get_theme_mod( 'footer_widgets_columns', 4 );

			// Cols
			array_push( $classes, 'lsvr-grid--' . $columns . '-cols' );

			// Cold md
			if ( $columns >= 2 ) {
				array_push( $classes, 'lsvr-grid--md-2-cols' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . esc_attr( implode( ' ', $classes ) ) . '"';
			}

		}
	}

	// Footer social links
	if ( ! function_exists( 'lsvr_pressville_the_footer_social_links' ) ) {
		function lsvr_pressville_the_footer_social_links() {

			$social_links = lsvr_pressville_get_social_links();
			if ( get_theme_mod( 'footer_social_links_enable', true ) &&
				! empty( $social_links ) ) {  ?>

				<!-- FOOTER SOCIAL LINKS : begin -->
				<div class="footer-social">
					<ul class="footer-social__list">
						<?php foreach ( $social_links as $social_link_id => $social_link ) : ?>
							<?php if ( ! empty( $social_link['url'] ) && ! empty( $social_link['icon'] ) ) : ?>
								<li class="footer-social__item">
									<a class="footer-social__link" target="_blank"
										<?php if ( 'email' === $social_link_id ) : ?>
											href="mailto:<?php echo esc_attr( $social_link['url'] ); ?>"
										<?php else : ?>
											href="<?php echo esc_url( $social_link['url'] ); ?>"
										<?php endif; ?>
										<?php if ( ! empty( $social_link['label'] ) ) { echo ' title="' . esc_attr( $social_link['label'] ) . '"'; } ?>>
										<i class="footer-social__icon <?php echo esc_attr( $social_link['icon'] ); ?>"></i>
									</a>
								</li>
							<?php endif; ?>
						<?php endforeach; ?>
					</ul>
				</div>
				<!-- FOOTER SOCIAL LINKS : end -->

			<?php }

		}
	}

	// Footer text
	if ( ! function_exists( 'lsvr_pressville_the_footer_text' ) ) {
		function lsvr_pressville_the_footer_text() {

			$footer_text = get_theme_mod( 'footer_text', '&copy; ' . date( 'Y' ) . ' ' . get_bloginfo( 'name' ) );

			if ( ! empty( $footer_text ) ) { ?>

				<!-- FOOTER TEXT : begin -->
				<div class="footer-text">
					<?php echo wpautop( wp_kses( $footer_text, array(
						'a' => array(
							'href' => array(),
							'title' => array(),
							'target' => array(),
						),
						'em' => array(),
						'br' => array(),
						'strong' => array(),
						'p' => array(),
					))); ?>
				</div>
				<!-- FOOTER TEXT : end -->

			<?php }

		}
	}

	// Back to top button
	if ( ! function_exists( 'lsvr_pressville_the_back_to_top_button' ) ) {
		function lsvr_pressville_the_back_to_top_button() {

			if ( 'disable' !== get_theme_mod( 'back_to_top_button_enable', 'disable' ) ) {

				$class = array( 'back-to-top' );
				array_push( $class, 'back-to-top--type-' . get_theme_mod( 'back_to_top_button_enable', 'disable' ) );
				array_push( $class, 'back-to-top--threshold-' . strval( get_theme_mod( 'back_to_top_button_threshold', 100 ) ) );

				?>

				<!-- BACK TO TOP : begin -->
				<div class="<?php echo esc_attr( implode( $class, ' ' ) ); ?>"
					data-threshold="<?php echo esc_attr( get_theme_mod( 'back_to_top_button_threshold', 100 ) ); ?>">
					<a class="back-to-top__link" href="#header"><span class="back-to-top__label"><?php esc_html_e( 'Back to top', 'pressville' ); ?></span></a>
				</div>
				<!-- BACK TO TOP : end -->

			<?php }

		}
	}


/**
 * BLOG
 */

	// Blog post archive grid class
	if ( ! function_exists( 'lsvr_pressville_the_blog_post_archive_grid_class' ) ) {
		function lsvr_pressville_the_blog_post_archive_grid_class() {

			echo 'lsvr-grid';

		}
	}

	// Blog post grid column class
	if ( ! function_exists( 'lsvr_pressville_the_blog_post_archive_grid_column_class' ) ) {
		function lsvr_pressville_the_blog_post_archive_grid_column_class( $post_id ) {

			global $paged;

			$number_of_columns = ! empty( get_theme_mod( 'blog_archive_grid_columns', 3 ) ) ? (int) get_theme_mod( 'blog_archive_grid_columns', 3 ) : 3;
			$span = 12 / $number_of_columns;

			// Get large span class
			$span_lg_class =  3 === $span ? ' lsvr-grid__col--lg-span-4' : '';

			// Get medium span class
			$span_md_class =  3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md-span-6' : '';

			echo 'lsvr-grid__col lsvr-grid__col--span-' . esc_attr( $span . $span_lg_class . $span_md_class );

		}
	}

	// Blog post background thumbnail
	if ( ! function_exists( 'lsvr_pressville_the_blog_post_background_thumbnail' ) ) {
		function lsvr_pressville_the_blog_post_background_thumbnail( $post_id ) {

			if ( has_post_thumbnail( $post_id ) ) {
				echo ' style="background-image: url( \'' . esc_url( get_the_post_thumbnail_url( $post_id, 'large' ) ) . '\' );"';
			}

		}
	}

?>