<?php

// Load gallery JS files
add_action( 'lsvr_pressville_load_assets', 'lsvr_pressville_gallery_load_js', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_load_js' ) ) {
	function lsvr_pressville_gallery_load_js() {

		// Masonry
		if ( is_singular( 'lsvr_gallery' ) ||
			( ( lsvr_pressville_is_gallery() && ! is_singular( 'lsvr_gallery' ) ) &&
			true === get_theme_mod( 'lsvr_gallery_archive_masonry_enable', false ) &&
			'default' === get_theme_mod( 'lsvr_gallery_archive_layout', 'default' ) ) ) {
			wp_enqueue_script( 'masonry' );
		}

	}
}

// Page title
add_filter( 'document_title_parts', 'lsvr_pressville_gallery_title', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_title' ) ) {
	function lsvr_pressville_gallery_title( $title ) {

		if ( is_post_type_archive( 'lsvr_gallery' ) ) {
			$title['title'] = sanitize_text_field( lsvr_pressville_get_gallery_archive_title() );
		}
		return $title;

	}
}

// Add lsvr_gallery to search filter
add_filter( 'lsvr_pressville_add_header_search_filter', 'lsvr_pressville_gallery_search_filter', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_search_filter' ) ) {
	function lsvr_pressville_gallery_search_filter( $filter ) {

		$filter = array_merge( $filter, array(
			array(
				'name' => 'lsvr_gallery',
				'label' => esc_html__( 'galleries', 'pressville' ),
			),
		));
		return $filter;

	}
}

// Breadcrumbs
add_filter( 'lsvr_pressville_add_to_breadcrumbs', 'lsvr_pressville_gallery_breadcrumbs', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_breadcrumbs' ) ) {
	function lsvr_pressville_gallery_breadcrumbs( $breadcrumbs ) {

		if ( lsvr_pressville_is_gallery() && ! is_post_type_archive( 'lsvr_gallery' ) ) {
			$breadcrumbs = array(
				array(
					'url' => get_post_type_archive_link( 'lsvr_gallery' ),
					'label' => lsvr_pressville_get_gallery_archive_title(),
				),
			);
		}
		return $breadcrumbs;

	}
}

// Archive pre_get_posts actions
add_action( 'pre_get_posts', 'lsvr_pressville_gallery_archive_pre_get_posts' );
if ( ! function_exists( 'lsvr_pressville_gallery_archive_pre_get_posts' ) ) {
	function lsvr_pressville_gallery_archive_pre_get_posts( $query ) {
		if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_gallery' ) ||
			$query->is_tax( 'lsvr_gallery_cat' ) || $query->is_tax( 'lsvr_gallery_tag' ) ) ) {

			// Posts per page
			if ( 0 === get_theme_mod( 'lsvr_gallery_archive_posts_per_page', 12 ) ) {
				$query->set( 'posts_per_page', 1000 );
			} else {
				$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_gallery_archive_posts_per_page', 12 ) ) );
			}

		}
	}
}

// Sidebar position
add_filter( 'lsvr_pressville_sidebar_position', 'lsvr_pressville_gallery_sidebar_position', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_sidebar_position' ) ) {
	function lsvr_pressville_gallery_sidebar_position( $sidebar_position ) {

		// Is gallery single
		if ( is_singular( 'lsvr_gallery' ) ) {
			$sidebar_position = get_theme_mod( 'lsvr_gallery_single_sidebar_position', 'disable' );
		}

		// Is gallery archive
		else if ( lsvr_pressville_is_gallery() ) {
			$sidebar_position = get_theme_mod( 'lsvr_gallery_archive_sidebar_position', 'disable' );
		}

		return $sidebar_position;

	}
}

// Sidebar ID
add_filter( 'lsvr_pressville_sidebar_id', 'lsvr_pressville_gallery_sidebar_id', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_gallery_sidebar_id' ) ) {
	function lsvr_pressville_gallery_sidebar_id( $sidebar_id ) {

		// Is gallery single
		if ( is_singular( 'lsvr_gallery' ) ) {
			$sidebar_id = get_theme_mod( 'lsvr_gallery_single_sidebar_id' );
		}

		// Is gallery archive
		else if ( lsvr_pressville_is_gallery() ) {
			$sidebar_id = get_theme_mod( 'lsvr_gallery_archive_sidebar_id' );
		}

		return $sidebar_id;

	}
}

// Add post meta data
add_action( 'lsvr_pressville_gallery_single_bottom', 'lsvr_pressville_add_gallery_single_meta', 10, 2 );
if ( ! function_exists( 'lsvr_pressville_add_gallery_single_meta' ) ) {
	function lsvr_pressville_add_gallery_single_meta() { ?>

		<script type="application/ld+json">
		{
			"@context" : "http://schema.org",
			"@type" : "ImageGallery",
			"headline": "<?php echo esc_js( get_the_title() ); ?>",
			"url" : "<?php echo esc_url( get_permalink() ); ?>",
			"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
		 	"datePublished": "<?php echo esc_js( get_the_time( 'c' ) ); ?>",
		 	"dateModified": "<?php echo esc_js( get_the_modified_date( 'c' ) ); ?>",
		 	"description": "<?php echo esc_js( get_the_excerpt() ); ?>",
		 	"author": {
		 		"@type" : "person",
		 		"name" : "<?php echo esc_js( get_the_author() ); ?>",
		 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
		 	},
		 	"publisher" : {
		 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
		 	}

		 	<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) : ?>
			,"keywords": "<?php echo esc_js( implode( ',', lsvr_pressville_get_post_term_names( get_the_ID(), 'lsvr_gallery_tag' ) ) ); ?>"
		 	<?php endif; ?>

			<?php if ( has_post_thumbnail() ) : ?>
		 	,"image": {
		 		"@type" : "ImageObject",
		 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
		 		"width" : "<?php echo esc_js( lsvr_pressville_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"height" : "<?php echo esc_js( lsvr_pressville_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
		 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
		 	}
		 	<?php endif; ?>

		 	<?php if ( lsvr_pressville_has_gallery_images( get_the_ID() ) ) : ?>
		 		,"associatedMedia" : [
		 		<?php $i = 1; foreach ( lsvr_pressville_get_gallery_images( get_the_ID() ) as $image ) : ?>
					{
			 			"@type" : "ImageObject",
			 			"url" : "<?php echo esc_url( $image['full_url'] ); ?>",
			 			"width" : "<?php echo esc_js( $image['full_width'] ); ?>",
			 			"height" : "<?php echo esc_js( $image['full_height'] ); ?>",
			 			"thumbnailUrl" : "<?php echo esc_url( $image['thumb_url'] ); ?>"
			 		}<?php if ( $i < count( lsvr_pressville_get_gallery_images( get_the_ID() ) ) ) { echo ','; } ?>
		 		<?php $i++; endforeach; ?>
		 		]
		 	<?php endif; ?>

		}
		</script>

	<?php }
}

?>