<?php

add_action( 'customize_register', 'lsvr_pressville_galleries_customize_register' );
if ( ! function_exists( 'lsvr_pressville_galleries_customize_register' ) ) {
    function lsvr_pressville_galleries_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_pressville_' );

            $lsvr_customizer->add_section( 'lsvr_gallery_settings', array(
                'title' => esc_html__( 'Galleries', 'pressville' ),
                'priority' => 150,
            ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_title', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Gallery Archive Title', 'pressville' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'pressville' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Galleries', 'pressville' ),
                    'priority' => 1010,
                ));

                // Archive layout
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_layout', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Layout', 'pressville' ),
                    'description' => esc_html__( 'Change layout for gallery archive page.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'pressville' ),
                        'grid' => esc_html__( 'Grid', 'pressville' ),
                    ),
                    'default' => 'default',
                    'priority' => 1020,
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_categories_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'pressville' ),
                    'description' => esc_html__( 'Display links to gallery categories.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1030,
                ));

                // Enable masonry
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_masonry_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Enable Archive Masonry', 'pressville' ),
                    'description' => esc_html__( 'Display gallery posts in masonry.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1040,
                    'required' => array(
                        'setting' => 'lsvr_gallery_archive_layout',
                        'operator' => '==',
                        'value' => 'default',
                    ),
                ));

                // Crop thumbnail
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_cropped_thumb_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Crop Thumbnails', 'pressville' ),
                    'description' => esc_html__( 'Make each gallery thumbnail the same size.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1050,
                    'required' => array(
                        'setting' => 'lsvr_gallery_archive_layout',
                        'operator' => '==',
                        'value' => 'default',
                    ),
                ));

                // Archive grid columns
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_grid_columns', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Number of Columns', 'pressville' ),
                    'description' => esc_html__( 'Divide layout into several columns.', 'pressville' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 3,
                    'priority' => 1060,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_posts_per_page', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Posts Per Page', 'pressville' ),
                    'description' => esc_html__( 'How many gallery posts should be displayed per page. Set to 0 to display all.', 'pressville' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 12,
                    'priority' => 1070,
                ));

                // Enable archive images count
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_image_count_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Image Count on Archive', 'pressville' ),
                    'description' => esc_html__( 'Display the number of gallery images on post archive.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1075,
                ));

                // Archive sidebar position
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_sidebar_position', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the gallery post archive sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1080,
                ));

                // Archive sidebar ID
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_sidebar_id', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 1090,
                    'required' => array(
                        'setting' => 'lsvr_gallery_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_gallery_separator_2', array(
                    'section' => 'lsvr_gallery_settings',
                    'priority' => 2000,
                ));

                // Single grid columns
                $lsvr_customizer->add_field( 'lsvr_gallery_single_grid_columns', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Number of Columns', 'pressville' ),
                    'description' => esc_html__( 'Divide layout into several columns.', 'pressville' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 4,
                    'priority' => 2010,
                ));

                // Enable date
                $lsvr_customizer->add_field( 'lsvr_gallery_single_date_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Date on Detail', 'pressville' ),
                    'description' => esc_html__( 'Display the gallery post date on post detail.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2020,
                ));

                // Single sidebar position
                $lsvr_customizer->add_field( 'lsvr_gallery_single_sidebar_position', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the gallery post detail sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 2030,
                ));

                // Single sidebar ID
                $lsvr_customizer->add_field( 'lsvr_gallery_single_sidebar_id', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 2040,
                    'required' => array(
                        'setting' => 'lsvr_gallery_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

        }
    }
}

?>