<?php

add_action( 'customize_register', 'lsvr_pressville_notices_customize_register' );
if ( ! function_exists( 'lsvr_pressville_notices_customize_register' ) ) {
    function lsvr_pressville_notices_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_pressville_' );

            $lsvr_customizer->add_section( 'lsvr_notice_settings', array(
                'title' => esc_html__( 'Notices', 'pressville' ),
                'priority' => 125,
            ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_notice_archive_title', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Notice Archive Title', 'pressville' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'pressville' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Notices', 'pressville' ),
                    'priority' => 1010,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_notice_archive_posts_per_page', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Posts Per Page', 'pressville' ),
                    'description' => esc_html__( 'How many notice posts should be displayed per page. Set to 0 to display all.', 'pressville' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 10,
                    'priority' => 1020,
                ));

                // Archive sidebar position
                $lsvr_customizer->add_field( 'lsvr_notice_archive_sidebar_position', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the notice post archive sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1040,
                ));

                // Archive sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_archive_sidebar_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 1050,
                    'required' => array(
                        'setting' => 'lsvr_notice_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_notice_separator_2', array(
                    'section' => 'lsvr_notice_settings',
                    'priority' => 2000,
                ));

                // Single sidebar position
                $lsvr_customizer->add_field( 'lsvr_notice_single_sidebar_position', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the notice post detail sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 2010,
                ));

                // Single sidebar ID
                $lsvr_customizer->add_field( 'lsvr_notice_single_sidebar_id', array(
                    'section' => 'lsvr_notice_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 2020,
                    'required' => array(
                        'setting' => 'lsvr_notice_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

        }
    }
}

?>