<?php

add_action( 'customize_register', 'lsvr_pressville_people_customize_register' );
if ( ! function_exists( 'lsvr_pressville_people_customize_register' ) ) {
    function lsvr_pressville_people_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_pressville_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_pressville_' );

            $lsvr_pressville_customizer->add_section( 'lsvr_person_settings', array(
                'title' => esc_html__( 'People', 'pressville' ),
                'priority' => 170,
            ));

                // Title
                $lsvr_pressville_customizer->add_field( 'lsvr_person_archive_title', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Person Archive Title', 'pressville' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'pressville' ),
                    'type' => 'text',
                    'default' => esc_html__( 'People', 'pressville' ),
                    'priority' => 1010,
                ));

                // Enable categories
                $lsvr_pressville_customizer->add_field( 'lsvr_person_archive_categories_enable', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'pressville' ),
                    'description' => esc_html__( 'Display links to person categories.', 'pressville' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1020,
                ));

                // Archive grid columns
                $lsvr_pressville_customizer->add_field( 'lsvr_person_archive_grid_columns', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Number of Columns', 'pressville' ),
                    'description' => esc_html__( 'Divide layout into several columns.', 'pressville' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 4,
                    'priority' => 1030,
                ));

                // Archive sidebar position
                $lsvr_pressville_customizer->add_field( 'lsvr_person_archive_sidebar_position', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the person post archive sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1040,
                ));

                // Archive sidebar ID
                $lsvr_pressville_customizer->add_field( 'lsvr_person_archive_sidebar_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 1050,
                    'required' => array(
                        'setting' => 'lsvr_person_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_pressville_customizer->add_separator( 'lsvr_person_separator_2', array(
                    'section' => 'lsvr_person_settings',
                    'priority' => 2000,
                ));

                // Single sidebar position
                $lsvr_pressville_customizer->add_field( 'lsvr_person_single_sidebar_position', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'pressville' ),
                    'description' => esc_html__( 'Change the person post detail sidebar position.', 'pressville' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'pressville' ),
                        'left' => esc_html__( 'Left', 'pressville' ),
                        'right' => esc_html__( 'Right', 'pressville' ),
                    ),
                    'default' => 'disable',
                    'priority' => 2010,
                ));

                // Single sidebar ID
                $lsvr_pressville_customizer->add_field( 'lsvr_person_single_sidebar_id', array(
                    'section' => 'lsvr_person_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'pressville' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'pressville' ),
                    'type' => 'select',
                    'choices' => lsvr_pressville_get_sidebars(),
                    'priority' => 2020,
                    'required' => array(
                        'setting' => 'lsvr_person_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

        }
    }
}

?>