<?php get_header(); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<!-- COLUMNS : begin -->
<div id="columns">
	<div class="columns__inner">
		<div class="lsvr-container">

			<div class="lsvr-grid">
				<div class="lsvr-grid__col lsvr-grid__col--xlg-span-8 lsvr-grid__col--xlg-push-2">

					<!-- MAIN : begin -->
					<main id="main">
						<div class="main__inner">

							<!-- SEARCH RESULTS PAGE : begin -->
							<div class="search-results-page">

								<!-- MAIN HEADER : begin -->
								<header class="main__header">
									<h1 class="main__title is-main-headline">
										<?php esc_html_e( 'Search results', 'pressville' ); ?>
									</h1>
								</header>
								<!-- MAIN HEADER : end -->

								<?php // Search form
								get_search_form() ?>

								<?php // Results info
								global $wp_query;
								if ( isset( $wp_query->found_posts ) ) : ?>
									<p><?php echo sprintf( esc_html__( 'Showing %d results for "%s":', 'pressville' ), $wp_query->found_posts, get_search_query() ); ?></p>
								<?php endif; ?>

								<?php if ( have_posts() ) : ?>

									<ul class="search-results-page__list">

										<?php while ( have_posts() ) : the_post(); ?>

											<li class="search-results-page__item">
												<i class="search-results-page__item-icon <?php echo esc_attr( lsvr_pressville_get_post_type_icon_class( get_post_type() ) ); ?>"></i>
												<h3 class="search-results-page__item-title">
													<a href="<?php the_permalink(); ?>" class="search-results-page__item-title-link"><?php the_title(); ?></a>
												</h3>

												<?php $post_object = get_post_type_object( get_post_type() ); ?>
												<span class="search-results-page__item-type"><?php echo esc_html( $post_object->labels->singular_name ); ?></span>

											</li>

										<?php endwhile; ?>

									</ul>

									<?php // Pagination
									the_posts_pagination(); ?>

								<?php endif; ?>

							</div>
							<!-- SEARCH RESULTS PAGE : end -->

						</div>
					</main>
					<!-- MAIN : end -->

				</div>
			</div>

		</div>
	</div>
</div>
<!-- COLUMNS : end -->

<?php get_footer(); ?>