<?php get_header(); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<?php // MAIN START
get_template_part( 'template-parts/main', 'begin' ); ?>

<!-- DOCUMENT POST SINGLE : begin -->
<div class="lsvr_document-post-page post-single lsvr_document-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST HEADER : begin -->
				<header class="post__header">

					<!-- POST TITLE : begin -->
					<h1 class="post__title is-main-headline"><?php the_title(); ?></h1>
					<!-- POST TITLE : end -->

					<?php if ( true === get_theme_mod( 'lsvr_document_single_date_enable', true ) || true === get_theme_mod( 'lsvr_document_single_author_enable', true )
						|| lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_document_cat' ) ) : ?>

						<!-- POST META : begin -->
						<p class="post__meta">

							<?php if ( true === get_theme_mod( 'lsvr_document_single_date_enable', true ) ) : ?>
								<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php the_date(); ?></time>
							<?php endif; ?>

							<?php if ( true === get_theme_mod( 'lsvr_document_single_author_enable', true ) ) : ?>
								<span class="post__meta-author"><?php echo sprintf( esc_html__( 'by %s', 'pressville' ), '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" class="post__meta-author-link" rel="author">' . get_the_author() . '</a>' ); ?></span>
							<?php endif; ?>

							<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_document_cat' ) ) : ?>
								<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_document_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
							<?php endif; ?>

						</p>
						<!-- POST META : end -->

					<?php endif; ?>

				</header>
				<!-- POST HEADER : end -->

				<!-- POST CONTENT : begin -->
				<div class="post__content">

					<?php if ( ! empty( get_post()->post_content ) ) : ?>
					<!-- POST TEXT : begin -->
					<div class="post__text">
						<?php the_content(); ?>
					</div>
					<!-- POST TEXT : end -->
					<?php endif; ?>

					<?php // Get post attachments
					if ( lsvr_pressville_has_document_attachments( get_the_ID() ) && ! post_password_required( get_the_ID() ) ) : ?>

						<!-- POST ATTACHMENTS : begin -->
						<div class="post__attachments">
							<h4 class="post__attachments-title"><?php esc_html_e( 'Attachments', 'pressville' ); ?></h4>
							<?php lsvr_pressville_the_document_attachments( get_the_ID() ); ?>
						</div>
						<!-- POST ATTACHMENTS : end -->

					<?php endif;  ?>

				</div>
				<!-- POST CONTENT : end -->

				<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_document_tag' ) ) : ?>
				<!-- POST FOOTER : begin -->
				<footer class="post__footer">

					<!-- POST TAGS : begin -->
					<div class="post__tags">
						<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'pressville' ); ?></h6>
						<?php lsvr_pressville_the_post_tags( get_the_ID(), 'lsvr_document_tag' ); ?>
					</div>
					<!-- POST TAGS : end -->

				</footer>
				<!-- POST FOOTER : end -->
				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_pressville_document_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- DOCUMENT POST SINGLE : end -->

<?php // MAIN END
get_template_part( 'template-parts/main', 'end' ); ?>

<?php get_footer(); ?>