<?php get_header(); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<?php // MAIN BEGIN
get_template_part( 'template-parts/main', 'begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_gallery-post-page post-single lsvr_gallery-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST HEADER : begin -->
				<header class="post__header">

					<!-- POST TITLE : begin -->
					<h1 class="post__title is-main-headline"><?php the_title(); ?></h1>
					<!-- POST TITLE : end -->

					<?php if ( true === get_theme_mod( 'lsvr_gallery_single_date_enable', true ) || lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>

						<!-- POST META : begin -->
						<p class="post__meta">

							<?php if ( true === get_theme_mod( 'lsvr_gallery_single_date_enable', true ) ) : ?>
								<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php the_date(); ?></time>
							<?php endif; ?>

							<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>
								<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_gallery_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
							<?php endif; ?>

						</p>
						<!-- POST META : end -->

					<?php endif; ?>

				</header>
				<!-- POST HEADER : end -->

				<!-- POST CONTENT : begin -->
				<div class="post__content">

					<?php if ( ! empty( get_post()->post_content ) ) : ?>
					<!-- POST TEXT : begin -->
					<div class="post__text">
						<?php the_content(); ?>
					</div>
					<!-- POST TEXT : end -->
					<?php endif; ?>

					<?php // Gallery images
					lsvr_pressville_the_gallery_images( get_the_ID() ); ?>

				</div>
				<!-- POST CONTENT : end -->

				<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) : ?>
				<!-- POST FOOTER : begin -->
				<footer class="post__footer">

					<!-- POST TAGS : begin -->
					<div class="post__tags">
						<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'pressville' ); ?></h6>
						<?php lsvr_pressville_the_post_tags( get_the_ID(), 'lsvr_gallery_tag' ); ?>
					</div>
					<!-- POST TAGS : end -->

				</footer>
				<!-- POST FOOTER : end -->
				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_pressville_gallery_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // MAIN END
get_template_part( 'template-parts/main', 'end' ); ?>

<?php get_footer(); ?>