<?php get_header(); ?>

<?php // Post gallery / featured image
lsvr_pressville_the_listing_gallery_header( get_the_ID() ); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<?php // MAIN BEGIN
get_template_part( 'template-parts/main', 'begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_listing-post-page post-single lsvr_listing-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST HEADER : begin -->
				<header class="post__header">

					<!-- POST TITLE : begin -->
					<h1 class="post__title is-main-headline"><?php the_title(); ?></h1>
					<!-- POST TITLE : end -->

					<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_listing_cat' ) ) : ?>

						<!-- POST META : begin -->
						<p class="post__meta">
							<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_listing_cat', esc_html__( 'in %s', 'pressville' ) ); ?></span>
						</p>
						<!-- POST META : end -->

					<?php endif; ?>

					<?php // Social links
					lsvr_pressville_the_listing_social_links( get_the_ID() ); ?>

				</header>
				<!-- POST HEADER : end -->

				<?php if ( true === lsvr_pressville_has_listing_single_featured_image( get_the_ID() ) ) : ?>
				<!-- POST THUMBNAIL : begin -->
				<p class="post__thumbnail">
					<?php the_post_thumbnail( 'full' ); ?>
				</p>
				<!-- POST THUMBNAIL : end -->
				<?php endif; ?>

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php the_content(); ?>
					</div>
					<!-- POST CONTENT : end -->

				<?php endif; ?>

				<?php // Contact info
				lsvr_pressville_the_listing_contact_info( get_the_ID() ); ?>

				<?php // Map and address
				if ( true === get_theme_mod( 'lsvr_listing_single_map_enable', true ) &&
					lsvr_pressville_has_listing_map_location( get_the_ID() ) && lsvr_pressville_has_listing_address( get_the_ID() ) ) : ?>

					<!-- POST ADDRESS & MAP : begin -->
					<div class="post__addressmap">

						<div class="post__addressmap-inner">
							<h3 class="post__addressmap-title"><?php esc_html_e( 'Address', 'pressville' ); ?></h3>
							<p class="post__addressmap-address">
								<?php lsvr_pressville_the_listing_address( get_the_ID() ); ?>
							</p>
							<?php if ( lsvr_pressville_has_listing_map_link( get_the_ID() ) ) : ?>
								<p class="post__addressmap-link-wrapper">
									<a href="<?php echo esc_url( lsvr_pressville_get_listing_map_link( get_the_ID() ) ); ?>" class="post__addressmap-link"
										target="_blank"><?php esc_html_e( 'Open in Google Maps', 'pressville' ); ?></a>
								</p>
							<?php endif; ?>
						</div>

						<?php // Location map
						lsvr_pressville_the_listing_map( get_the_ID() ); ?>

					</div>
					<!-- POST ADDRESS & MAP : end -->

				<?php // Map only
				elseif ( true === get_theme_mod( 'lsvr_listing_single_map_enable', true ) && lsvr_pressville_has_listing_map_location( get_the_ID() ) ) : ?>

					<?php // Location map
					lsvr_pressville_the_listing_map( get_the_ID() ); ?>

				<?php // Address only
				elseif ( lsvr_pressville_has_listing_address( get_the_ID() ) ) : ?>

					<!-- POST ADDRESS : begin -->
					<p class="post__address">
						<?php lsvr_pressville_the_listing_address( get_the_ID(), false ); ?>
					</p>
					<!-- POST ADDRESS : end -->

				<?php endif; ?>

				<?php if ( lsvr_pressville_has_listing_opening_hours( get_the_ID() ) ) :?>

					<!-- OPENING HOURS : begin -->
					<div class="post__hours">

						<h3 class="post__hours-title"><?php esc_html_e( 'Opening hours', 'pressville' ); ?></h3>
						<?php lsvr_pressville_the_listing_opening_hours( get_the_ID() ); ?>

					</div>
					<!-- OPENING HOURS : end -->

				<?php endif; ?>

				<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_listing_tag' ) ) : ?>

					<!-- POST FOOTER : begin -->
					<footer class="post__footer">

						<?php // Post tags
						lsvr_pressville_the_post_tags( get_the_ID(), 'lsvr_listing_tag' ); ?>

					</footer>
					<!-- POST FOOTER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_pressville_listing_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // MAIN END
get_template_part( 'template-parts/main', 'end' ); ?>

<?php get_footer(); ?>