<?php get_header(); ?>

<?php // BREADCRUMBS
get_template_part( 'template-parts/breadcrumbs' ); ?>

<?php // MAIN BEGIN
get_template_part( 'template-parts/main', 'begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_person-post-page post-single lsvr_person-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST HEADER : begin -->
				<header class="post__header<?php if ( has_post_thumbnail() ) { echo ' post__header--has-thumb'; } ?>">

					<?php if ( has_post_thumbnail() ) : ?>
						<!-- POST THUMBNAIL : begin -->
						<p class="post__thumbnail">
							<?php the_post_thumbnail( 'thumbnail' ); ?>
						</p>
						<!-- POST THUMBNAIL : end -->
					<?php endif; ?>

					<!-- POST TITLE : begin -->
					<h1 class="post__title is-main-headline"><?php the_title(); ?></h1>
					<!-- POST TITLE : end -->

					<?php if ( lsvr_pressville_has_person_role( get_the_ID() ) ) : ?>
						<!-- POST SUBTITLE : begin -->
						<h4 class="post__subtitle"><?php lsvr_pressville_the_person_role( get_the_ID() ); ?></h4>
						<!-- POST SUBTITLE : end -->
					<?php endif; ?>

					<?php // Social links
					lsvr_pressville_the_person_social_links( get_the_ID() ); ?>

				</header>
				<!-- POST HEADER : end -->

				<?php // Contact info
				lsvr_pressville_the_person_contact_info( get_the_ID() ); ?>

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">

						<div class="post__text">
							<?php the_content(); ?>
						</div>

					</div>
					<!-- POST CONTENT : begin -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_pressville_person_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // MAIN END
get_template_part( 'template-parts/main', 'end' ); ?>

<?php get_footer(); ?>