<?php // Add custom code before header titlebar
do_action( 'lsvr_pressville_header_titlebar_before' ); ?>

<!-- HEADER TITLEBAR : begin -->
<div <?php lsvr_pressville_the_header_titlebar_class(); ?>>

	<div class="header-titlebar__inner">
		<div class="lsvr-container">

			<?php // Add custom code at the top of header titlebar
			do_action( 'lsvr_pressville_header_titlebar_top' ); ?>

			<?php // Header logo
			if ( has_custom_logo() ) : ?>

				<div class="header-titlebar__logo">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="header-titlebar__logo-link">
						<img src="<?php echo esc_url( wp_get_attachment_url( get_theme_mod( 'custom_logo' ) ) ); ?>"
							class="header-titlebar__logo-image"
							alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>">
					</a>
				</div>

			<?php endif; ?>

			<?php // Header title and description
			if ( lsvr_pressville_has_header_site_title() || lsvr_pressville_has_header_description() ) : ?>

				<div class="header-titlebar__text">

					<?php if ( lsvr_pressville_has_header_site_title() ) : ?>
						<h1 class="header-titlebar__title">
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="header-titlebar__title-link">
								<?php bloginfo( 'name' ); ?>
							</a>
						</h1>
					<?php endif; ?>

					<?php if ( lsvr_pressville_has_header_description() ) : ?>
						<p class="header-titlebar__description"><?php bloginfo( 'description' ); ?></p>
					<?php endif; ?>

				</div>

			<?php endif; ?>

			<?php // Add custom code at the bottom of header titlebar
			do_action( 'lsvr_pressville_header_titlebar_bottom' ); ?>

		</div>
	</div>

	<?php // Background images
	lsvr_pressville_the_header_titlebar_background(); ?>

	<?php // Background overlay
	lsvr_pressville_the_header_titlebar_overlay(); ?>

</div>
<!-- HEADER TITLEBAR : end -->

<?php // Add custom code after header titlebar
do_action( 'lsvr_pressville_header_titlebar_after' ); ?>