<!-- POST ARCHIVE : begin -->
<div class="lsvr_listing-post-page post-archive lsvr_listing-post-archive lsvr_listing-post-archive--grid">

	<?php // ARCHIVE HEADER
	get_template_part( 'template-parts/lsvr_listing/archive-header' ); ?>

	<?php // Directory categories
	if ( true === get_theme_mod( 'lsvr_listing_archive_categories_enable', true ) ) {
		lsvr_pressville_the_post_archive_categories( 'lsvr_listing', 'lsvr_listing_cat' );
	} ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE GRID : begin -->
		<div class="post-archive__grid">
			<div class="<?php lsvr_pressville_the_listing_archive_grid_class(); ?>">

				<?php while ( have_posts() ) : the_post(); ?>

					<div class="<?php lsvr_pressville_the_listing_archive_grid_column_class(); ?>">

						<!-- POST : begin -->
						<article <?php post_class( 'post' ); ?>
							<?php lsvr_pressville_the_listing_post_archive_background_thumbnail( get_the_ID() ); ?>>
							<div class="post__inner">
								<div class="post__bg">

									<?php if ( lsvr_pressville_has_post_terms( get_the_ID(), 'lsvr_listing_cat' ) ) : ?>

										<!-- POST META : begin -->
										<p class="post__meta">
											<span class="post__meta-categories"><?php lsvr_pressville_the_post_categories( get_the_ID(), 'lsvr_listing_cat', esc_html__( 'in %s', 'pressville' ), '', 1 ); ?></span>
										</p>
										<!-- POST META : end -->

									<?php endif; ?>

									<!-- POST CONTENT : begin -->
									<div class="post__content">

										<!-- POST TITLE : begin -->
										<h2 class="post__title">
											<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
										</h2>
										<!-- POST TITLE : end -->

										<?php if ( lsvr_pressville_has_listing_address( get_the_ID() ) ) : ?>
										<!-- POST ADDRESS : begin -->
										<p class="post__address">
											<?php lsvr_pressville_the_listing_address( get_the_ID() ); ?>
										</p>
										<!-- POST ADDRESS : end -->
										<?php endif; ?>

									</div>
									<!-- POST CONTENT : end -->

									<!-- OVERLAY LINK : begin -->
									<a href="<?php echo get_permalink( get_the_ID() ); ?>"
										class="post__overlay-link">
										<span class="screen-reader-text"><?php esc_html_e( 'More Info', 'pressville' ); ?></span>
									</a>
									<!-- OVERLAY LINK : end -->

								</div>
							</div>
						</article>
						<!-- POST : end -->

					</div>

				<?php endwhile; ?>

			</div>
		</div>
		<!-- POST ARCHIVE GRID : end -->

		<?php // PAGINATION
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_pressville_the_alert_message( esc_html__( 'No listings matched your criteria', 'pressville' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->